/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.hardware.camera2.params.RggbChannelVector;
import android.hardware.camera2.utils.HashCodeHelpers;
import com.android.internal.util.Preconditions;
import java.util.Arrays;

public final class LensShadingMap {
    public static final float MINIMUM_GAIN_FACTOR = 1.0f;
    private final int mColumns;
    private final float[] mElements;
    private final int mRows;

    public LensShadingMap(float[] fArray, int n, int n2) {
        this.mRows = Preconditions.checkArgumentPositive(n, "rows must be positive");
        this.mColumns = Preconditions.checkArgumentPositive(n2, "columns must be positive");
        this.mElements = Preconditions.checkNotNull(fArray, "elements must not be null");
        if (fArray.length != this.getGainFactorCount()) {
            throw new IllegalArgumentException("elements must be " + this.getGainFactorCount() + " length, received " + fArray.length);
        }
        Preconditions.checkArrayElementsInRange(fArray, 1.0f, Float.MAX_VALUE, "elements");
    }

    public void copyGainFactors(float[] fArray, int n) {
        Preconditions.checkArgumentNonnegative(n, "offset must not be negative");
        Preconditions.checkNotNull(fArray, "destination must not be null");
        if (n + fArray.length < this.getGainFactorCount()) {
            throw new ArrayIndexOutOfBoundsException("destination too small to fit elements");
        }
        System.arraycopy((float[])this.mElements, (int)0, (float[])fArray, (int)n, (int)this.getGainFactorCount());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl = true;
        if (object == null) {
            return false;
        }
        if (this == object) {
            return bl;
        }
        if (!(object instanceof LensShadingMap)) return false;
        LensShadingMap lensShadingMap = (LensShadingMap)object;
        if (this.mRows != lensShadingMap.mRows) return false;
        if (this.mColumns != lensShadingMap.mColumns) return false;
        if (!Arrays.equals(this.mElements, lensShadingMap.mElements)) return false;
        return bl;
    }

    public int getColumnCount() {
        return this.mColumns;
    }

    public float getGainFactor(int n, int n2, int n3) {
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("colorChannel out of range");
        }
        if (n2 < 0 || n2 >= this.mColumns) {
            throw new IllegalArgumentException("column out of range");
        }
        if (n3 < 0 || n3 >= this.mRows) {
            throw new IllegalArgumentException("row out of range");
        }
        return this.mElements[n + 4 * (n2 + n3 * this.mColumns)];
    }

    public int getGainFactorCount() {
        return 4 * (this.mRows * this.mColumns);
    }

    public RggbChannelVector getGainFactorVector(int n, int n2) {
        if (n < 0 || n >= this.mColumns) {
            throw new IllegalArgumentException("column out of range");
        }
        if (n2 < 0 || n2 >= this.mRows) {
            throw new IllegalArgumentException("row out of range");
        }
        int n3 = 4 * (n + n2 * this.mColumns);
        return new RggbChannelVector(this.mElements[n3 + 0], this.mElements[n3 + 1], this.mElements[n3 + 2], this.mElements[n3 + 3]);
    }

    public int getRowCount() {
        return this.mRows;
    }

    public int hashCode() {
        int n = HashCodeHelpers.hashCode(this.mElements);
        return HashCodeHelpers.hashCode(this.mRows, this.mColumns, n);
    }
}

