/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.display;

import android.content.Context;
import android.hardware.display.DisplayManager;
import android.hardware.display.IDisplayManager;
import android.hardware.display.IDisplayManagerCallback;
import android.hardware.display.IVirtualDisplayCallback;
import android.hardware.display.UsbDisplayStatus;
import android.hardware.display.VirtualDisplay;
import android.hardware.display.WifiDisplayStatus;
import android.media.projection.IMediaProjection;
import android.media.projection.MediaProjection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import android.view.Display;
import android.view.DisplayAdjustments;
import android.view.DisplayInfo;
import android.view.Surface;
import java.util.ArrayList;

public final class DisplayManagerGlobal {
    private static final boolean DEBUG = false;
    public static final int EVENT_DISPLAY_ADDED = 1;
    public static final int EVENT_DISPLAY_CHANGED = 2;
    public static final int EVENT_DISPLAY_REMOVED = 3;
    private static final String TAG = "DisplayManager";
    private static final boolean USE_CACHE;
    private static DisplayManagerGlobal sInstance;
    private DisplayManagerCallback mCallback;
    private int[] mDisplayIdCache;
    private final SparseArray<DisplayInfo> mDisplayInfoCache;
    private final ArrayList<DisplayListenerDelegate> mDisplayListeners;
    private final IDisplayManager mDm;
    private final Object mLock = new Object();
    private int mWifiDisplayScanNestCount;

    private DisplayManagerGlobal(IDisplayManager iDisplayManager) {
        this.mDisplayListeners = new ArrayList();
        this.mDisplayInfoCache = new SparseArray();
        this.mDm = iDisplayManager;
    }

    private int findDisplayListenerLocked(DisplayManager.DisplayListener displayListener) {
        int n = this.mDisplayListeners.size();
        for (int i = 0; i < n; ++i) {
            if (this.mDisplayListeners.get((int)i).mListener != displayListener) continue;
            return i;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DisplayManagerGlobal getInstance() {
        synchronized (DisplayManagerGlobal.class) {
            if (sInstance != null) return sInstance;
            IBinder iBinder = ServiceManager.getService("display");
            if (iBinder == null) return sInstance;
            sInstance = new DisplayManagerGlobal(IDisplayManager.Stub.asInterface(iBinder));
            return sInstance;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleDisplayEvent(int n, int n2) {
        Object object = this.mLock;
        synchronized (object) {
            int n3 = this.mDisplayListeners.size();
            int n4 = 0;
            while (n4 < n3) {
                this.mDisplayListeners.get(n4).sendDisplayEvent(n, n2);
                ++n4;
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void registerCallbackIfNeededLocked() {
        if (this.mCallback != null) return;
        this.mCallback = new DisplayManagerCallback();
        try {
            this.mDm.registerCallback(this.mCallback);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Failed to register callback with display manager service.", remoteException);
            this.mCallback = null;
            return;
        }
    }

    public void connectUsbDisplay(String string2) {
        try {
            this.mDm.connectUsbDisplay(string2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Failed to connect to Usb display.");
            return;
        }
    }

    public void connectWifiDisplay(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("deviceAddress must not be null");
        }
        try {
            this.mDm.connectWifiDisplay(string2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Failed to connect to Wifi display " + string2 + ".", remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public VirtualDisplay createVirtualDisplay(Context context, MediaProjection mediaProjection, String string2, int n, int n2, int n3, Surface surface, int n4, VirtualDisplay.Callback callback, Handler handler) {
        int n5;
        VirtualDisplayCallback virtualDisplayCallback;
        block6: {
            if (TextUtils.isEmpty(string2)) {
                throw new IllegalArgumentException("name must be non-null and non-empty");
            }
            if (n <= 0) throw new IllegalArgumentException("width, height, and densityDpi must be greater than 0");
            if (n2 <= 0) throw new IllegalArgumentException("width, height, and densityDpi must be greater than 0");
            if (n3 <= 0) {
                throw new IllegalArgumentException("width, height, and densityDpi must be greater than 0");
            }
            virtualDisplayCallback = new VirtualDisplayCallback(callback, handler);
            IMediaProjection iMediaProjection = mediaProjection != null ? mediaProjection.getProjection() : null;
            try {
                n5 = this.mDm.createVirtualDisplay(virtualDisplayCallback, iMediaProjection, context.getPackageName(), string2, n, n2, n3, surface, n4);
                if (n5 >= 0) break block6;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Could not create virtual display: " + string2, remoteException);
                return null;
            }
            Log.e(TAG, "Could not create virtual display: " + string2);
            return null;
        }
        Display display = this.getRealDisplay(n5);
        if (display != null) return new VirtualDisplay(this, display, virtualDisplayCallback, surface);
        Log.wtf(TAG, "Could not obtain display info for newly created virtual display: " + string2);
        try {
            this.mDm.releaseVirtualDisplay(virtualDisplayCallback);
            return null;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public void disconnectUsbDisplay() {
        try {
            this.mDm.disconnectUsbDisplay();
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Failed to disconnect from USB display.", remoteException);
            return;
        }
    }

    public void disconnectWifiDisplay() {
        try {
            this.mDm.disconnectWifiDisplay();
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Failed to disconnect from Wifi display.", remoteException);
            return;
        }
    }

    public void forgetWifiDisplay(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("deviceAddress must not be null");
        }
        try {
            this.mDm.forgetWifiDisplay(string2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Failed to forget Wifi display.", remoteException);
            return;
        }
    }

    public Display getCompatibleDisplay(int n, DisplayAdjustments displayAdjustments) {
        DisplayInfo displayInfo = this.getDisplayInfo(n);
        if (displayInfo == null) {
            return null;
        }
        return new Display(this, n, displayInfo, displayAdjustments);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] getDisplayIds() {
        try {
            Object object = this.mLock;
            synchronized (object) {
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Could not get display ids from display manager.", remoteException);
            return new int[]{0};
        }
        {
            int[] nArray = this.mDm.getDisplayIds();
            this.registerCallbackIfNeededLocked();
            return nArray;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DisplayInfo getDisplayInfo(int n) {
        try {
            Object object = this.mLock;
            synchronized (object) {
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Could not get display information from display manager.", remoteException);
            return null;
        }
        {
            DisplayInfo displayInfo = this.mDm.getDisplayInfo(n);
            if (displayInfo == null) {
                return null;
            }
            this.registerCallbackIfNeededLocked();
            return displayInfo;
        }
    }

    public Display getRealDisplay(int n) {
        return this.getCompatibleDisplay(n, DisplayAdjustments.DEFAULT_DISPLAY_ADJUSTMENTS);
    }

    public Display getRealDisplay(int n, IBinder iBinder) {
        return this.getCompatibleDisplay(n, new DisplayAdjustments(iBinder));
    }

    public UsbDisplayStatus getUsbDisplayStatus() {
        try {
            UsbDisplayStatus usbDisplayStatus = this.mDm.getUsbDisplayStatus();
            return usbDisplayStatus;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Failed to get USB display status.", remoteException);
            return new UsbDisplayStatus();
        }
    }

    public WifiDisplayStatus getWifiDisplayStatus() {
        try {
            WifiDisplayStatus wifiDisplayStatus = this.mDm.getWifiDisplayStatus();
            return wifiDisplayStatus;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Failed to get Wifi display status.", remoteException);
            return new WifiDisplayStatus();
        }
    }

    public void pauseWifiDisplay() {
        try {
            this.mDm.pauseWifiDisplay();
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Failed to pause Wifi display.", remoteException);
            return;
        }
    }

    public void reconnectWifiDisplay() {
        try {
            this.mDm.reconnectWifiDisplay();
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Failed to reconnect to Wifi display.", remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerDisplayListener(DisplayManager.DisplayListener displayListener, Handler handler) {
        if (displayListener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.findDisplayListenerLocked(displayListener) < 0) {
                this.mDisplayListeners.add(new DisplayListenerDelegate(displayListener, handler));
                this.registerCallbackIfNeededLocked();
            }
            return;
        }
    }

    public void releaseVirtualDisplay(IVirtualDisplayCallback iVirtualDisplayCallback) {
        try {
            this.mDm.releaseVirtualDisplay(iVirtualDisplayCallback);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed to release virtual display.", remoteException);
            return;
        }
    }

    public void renameWifiDisplay(String string2, String string3) {
        if (string2 == null) {
            throw new IllegalArgumentException("deviceAddress must not be null");
        }
        try {
            this.mDm.renameWifiDisplay(string2, string3);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Failed to rename Wifi display " + string2 + " with alias " + string3 + ".", remoteException);
            return;
        }
    }

    public void resizeVirtualDisplay(IVirtualDisplayCallback iVirtualDisplayCallback, int n, int n2, int n3) {
        try {
            this.mDm.resizeVirtualDisplay(iVirtualDisplayCallback, n, n2, n3);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed to resize virtual display.", remoteException);
            return;
        }
    }

    public void resumeWifiDisplay() {
        try {
            this.mDm.resumeWifiDisplay();
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Failed to resume Wifi display.", remoteException);
            return;
        }
    }

    public void setVirtualDisplaySurface(IVirtualDisplayCallback iVirtualDisplayCallback, Surface surface) {
        try {
            this.mDm.setVirtualDisplaySurface(iVirtualDisplayCallback, surface);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed to set virtual display surface.", remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startWifiDisplayScan() {
        Object object = this.mLock;
        synchronized (object) {
            int n = this.mWifiDisplayScanNestCount;
            this.mWifiDisplayScanNestCount = n + 1;
            if (n == 0) {
                this.registerCallbackIfNeededLocked();
                try {
                    this.mDm.startWifiDisplayScan();
                }
                catch (RemoteException remoteException) {
                    Log.e(TAG, "Failed to scan for Wifi displays.", remoteException);
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stopWifiDisplayScan() {
        Object object = this.mLock;
        synchronized (object) {
            int n;
            this.mWifiDisplayScanNestCount = n = -1 + this.mWifiDisplayScanNestCount;
            if (n == 0) {
                try {
                    this.mDm.stopWifiDisplayScan();
                }
                catch (RemoteException remoteException) {
                    Log.e(TAG, "Failed to scan for Wifi displays.", remoteException);
                }
            } else if (this.mWifiDisplayScanNestCount < 0) {
                Log.wtf(TAG, "Wifi display scan nest count became negative: " + this.mWifiDisplayScanNestCount);
                this.mWifiDisplayScanNestCount = 0;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unregisterDisplayListener(DisplayManager.DisplayListener displayListener) {
        if (displayListener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            int n = this.findDisplayListenerLocked(displayListener);
            if (n >= 0) {
                this.mDisplayListeners.get(n).clearEvents();
                this.mDisplayListeners.remove(n);
            }
            return;
        }
    }

    public void updateBuiltInDisplayBlanking(boolean bl) {
        try {
            this.mDm.updateBuiltInDisplayBlanking(bl);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Failed to blank/unblank built-in display", remoteException);
            return;
        }
    }

    private static final class DisplayListenerDelegate
    extends Handler {
        public final DisplayManager.DisplayListener mListener;

        /*
         * Enabled aggressive block sorting
         */
        public DisplayListenerDelegate(DisplayManager.DisplayListener displayListener, Handler handler) {
            Looper looper = handler != null ? handler.getLooper() : Looper.myLooper();
            super(looper, null, true);
            this.mListener = displayListener;
        }

        public void clearEvents() {
            this.removeCallbacksAndMessages(null);
        }

        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    return;
                }
                case 1: {
                    this.mListener.onDisplayAdded(message.arg1);
                    return;
                }
                case 2: {
                    this.mListener.onDisplayChanged(message.arg1);
                    return;
                }
                case 3: 
            }
            this.mListener.onDisplayRemoved(message.arg1);
        }

        public void sendDisplayEvent(int n, int n2) {
            this.sendMessage(this.obtainMessage(n2, n, 0));
        }
    }

    private final class DisplayManagerCallback
    extends IDisplayManagerCallback.Stub {
        private DisplayManagerCallback() {
        }

        @Override
        public void onDisplayEvent(int n, int n2) {
            DisplayManagerGlobal.this.handleDisplayEvent(n, n2);
        }
    }

    private static final class VirtualDisplayCallback
    extends IVirtualDisplayCallback.Stub {
        private VirtualDisplayCallbackDelegate mDelegate;

        public VirtualDisplayCallback(VirtualDisplay.Callback callback, Handler handler) {
            if (callback != null) {
                this.mDelegate = new VirtualDisplayCallbackDelegate(callback, handler);
            }
        }

        @Override
        public void onPaused() {
            if (this.mDelegate != null) {
                this.mDelegate.sendEmptyMessage(0);
            }
        }

        @Override
        public void onResumed() {
            if (this.mDelegate != null) {
                this.mDelegate.sendEmptyMessage(1);
            }
        }

        @Override
        public void onStopped() {
            if (this.mDelegate != null) {
                this.mDelegate.sendEmptyMessage(2);
            }
        }
    }

    private static final class VirtualDisplayCallbackDelegate
    extends Handler {
        public static final int MSG_DISPLAY_PAUSED = 0;
        public static final int MSG_DISPLAY_RESUMED = 1;
        public static final int MSG_DISPLAY_STOPPED = 2;
        private final VirtualDisplay.Callback mCallback;

        /*
         * Enabled aggressive block sorting
         */
        public VirtualDisplayCallbackDelegate(VirtualDisplay.Callback callback, Handler handler) {
            Looper looper = handler != null ? handler.getLooper() : Looper.myLooper();
            super(looper, null, true);
            this.mCallback = callback;
        }

        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    return;
                }
                case 0: {
                    this.mCallback.onPaused();
                    return;
                }
                case 1: {
                    this.mCallback.onResumed();
                    return;
                }
                case 2: 
            }
            this.mCallback.onStopped();
        }
    }
}

