/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.display;

import android.os.Parcel;
import android.os.Parcelable;

public final class UsbDisplay
implements Parcelable {
    public static final Parcelable.Creator<UsbDisplay> CREATOR;
    public static final int DISPLAY_FLAG_SCREEN_OFF_MODE = 4;
    public static final UsbDisplay[] EMPTY_ARRAY;
    private final int mDeviceId;
    private final String mDeviceName;

    static {
        EMPTY_ARRAY = new UsbDisplay[0];
        CREATOR = new Parcelable.Creator<UsbDisplay>(){

            @Override
            public UsbDisplay createFromParcel(Parcel parcel) {
                return new UsbDisplay(parcel.readInt(), parcel.readString());
            }

            public UsbDisplay[] newArray(int n) {
                if (n == 0) {
                    return EMPTY_ARRAY;
                }
                return new UsbDisplay[n];
            }
        };
    }

    public UsbDisplay(int n, String string2) {
        if (n == -1) {
            throw new IllegalArgumentException("deviceId must not be -1");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("deviceName must not be null");
        }
        this.mDeviceId = n;
        this.mDeviceName = string2;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(UsbDisplay usbDisplay) {
        return usbDisplay != null && this.mDeviceId == usbDisplay.mDeviceId && this.mDeviceName.equals(usbDisplay.mDeviceName);
    }

    public boolean equals(Object object) {
        return object instanceof UsbDisplay && this.equals((UsbDisplay)object);
    }

    public int getDeviceId() {
        return this.mDeviceId;
    }

    public String getDeviceName() {
        return this.mDeviceName;
    }

    public boolean hasSameId(UsbDisplay usbDisplay) {
        return usbDisplay != null && this.mDeviceId == usbDisplay.mDeviceId;
    }

    public int hashCode() {
        return this.mDeviceId;
    }

    public String toString() {
        return this.mDeviceName + " (" + this.mDeviceId + ")";
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mDeviceId);
        parcel.writeString(this.mDeviceName);
    }
}

