/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.display;

import android.hardware.display.WifiDisplay;
import android.hardware.display.WifiDisplaySessionInfo;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;

public final class WifiDisplayStatus
implements Parcelable {
    public static final Parcelable.Creator<WifiDisplayStatus> CREATOR = new Parcelable.Creator<WifiDisplayStatus>(){

        @Override
        public WifiDisplayStatus createFromParcel(Parcel parcel) {
            int n = parcel.readInt();
            int n2 = parcel.readInt();
            int n3 = parcel.readInt();
            int n4 = parcel.readInt();
            WifiDisplay wifiDisplay = null;
            if (n4 != 0) {
                wifiDisplay = WifiDisplay.CREATOR.createFromParcel(parcel);
            }
            WifiDisplay[] wifiDisplayArray = WifiDisplay.CREATOR.newArray(parcel.readInt());
            for (int i = 0; i < wifiDisplayArray.length; ++i) {
                wifiDisplayArray[i] = WifiDisplay.CREATOR.createFromParcel(parcel);
            }
            return new WifiDisplayStatus(n, n2, n3, wifiDisplay, wifiDisplayArray, WifiDisplaySessionInfo.CREATOR.createFromParcel(parcel));
        }

        public WifiDisplayStatus[] newArray(int n) {
            return new WifiDisplayStatus[n];
        }
    };
    public static final int DISPLAY_STATE_CONNECTED = 2;
    public static final int DISPLAY_STATE_CONNECTING = 1;
    public static final int DISPLAY_STATE_DISCONNECTING = 3;
    public static final int DISPLAY_STATE_NOT_CONNECTED = 0;
    public static final int FEATURE_STATE_DISABLED = 1;
    public static final int FEATURE_STATE_OFF = 2;
    public static final int FEATURE_STATE_ON = 3;
    public static final int FEATURE_STATE_UNAVAILABLE = 0;
    public static final int SCAN_STATE_NOT_SCANNING = 0;
    public static final int SCAN_STATE_SCANNING = 1;
    private final WifiDisplay mActiveDisplay;
    private final int mActiveDisplayState;
    private final WifiDisplay[] mDisplays;
    private final int mFeatureState;
    private final int mScanState;
    private final WifiDisplaySessionInfo mSessionInfo;

    public WifiDisplayStatus() {
        this(0, 0, 0, null, WifiDisplay.EMPTY_ARRAY, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public WifiDisplayStatus(int n, int n2, int n3, WifiDisplay wifiDisplay, WifiDisplay[] wifiDisplayArray, WifiDisplaySessionInfo wifiDisplaySessionInfo) {
        if (wifiDisplayArray == null) {
            throw new IllegalArgumentException("displays must not be null");
        }
        this.mFeatureState = n;
        this.mScanState = n2;
        this.mActiveDisplayState = n3;
        this.mActiveDisplay = wifiDisplay;
        this.mDisplays = wifiDisplayArray;
        if (wifiDisplaySessionInfo == null) {
            wifiDisplaySessionInfo = new WifiDisplaySessionInfo();
        }
        this.mSessionInfo = wifiDisplaySessionInfo;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public WifiDisplay getActiveDisplay() {
        return this.mActiveDisplay;
    }

    public int getActiveDisplayState() {
        return this.mActiveDisplayState;
    }

    public WifiDisplay[] getDisplays() {
        return this.mDisplays;
    }

    public int getFeatureState() {
        return this.mFeatureState;
    }

    public int getScanState() {
        return this.mScanState;
    }

    public WifiDisplaySessionInfo getSessionInfo() {
        return this.mSessionInfo;
    }

    public String toString() {
        return "WifiDisplayStatus{featureState=" + this.mFeatureState + ", scanState=" + this.mScanState + ", activeDisplayState=" + this.mActiveDisplayState + ", activeDisplay=" + this.mActiveDisplay + ", displays=" + Arrays.toString(this.mDisplays) + ", sessionInfo=" + this.mSessionInfo + "}";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mFeatureState);
        parcel.writeInt(this.mScanState);
        parcel.writeInt(this.mActiveDisplayState);
        if (this.mActiveDisplay != null) {
            parcel.writeInt(1);
            this.mActiveDisplay.writeToParcel(parcel, n);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.mDisplays.length);
        WifiDisplay[] wifiDisplayArray = this.mDisplays;
        int n2 = wifiDisplayArray.length;
        int n3 = 0;
        while (true) {
            if (n3 >= n2) {
                this.mSessionInfo.writeToParcel(parcel, n);
                return;
            }
            wifiDisplayArray[n3].writeToParcel(parcel, n);
            ++n3;
        }
    }
}

