/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.hdmi;

import android.hardware.hdmi.HdmiRecordSources;

public abstract class HdmiRecordListener {
    protected HdmiRecordListener() {
    }

    public abstract HdmiRecordSources.RecordSource getOneTouchRecordSource(int var1);

    public void onClearTimerRecordingResult(int n) {
    }

    public void onOneTouchRecordResult(int n) {
    }

    public void onTimerRecordingResult(TimerStatusData timerStatusData) {
    }

    public static class TimerStatusData {
        private int mDurationHour;
        private int mDurationMinute;
        private int mExtraError;
        private int mMediaInfo;
        private int mNotProgrammedError;
        private boolean mOverlapped;
        private boolean mProgrammed;
        private int mProgrammedInfo;

        private TimerStatusData() {
        }

        private static int bcdByteToInt(byte by) {
            return 0xF & by + 10 * (0xF & by >> 4);
        }

        /*
         * Enabled aggressive block sorting
         */
        static TimerStatusData parseFrom(int n) {
            boolean bl = true;
            TimerStatusData timerStatusData = new TimerStatusData();
            boolean bl2 = (1 & n >> 31) != 0 ? bl : false;
            timerStatusData.mOverlapped = bl2;
            timerStatusData.mMediaInfo = 3 & n >> 29;
            if ((1 & n >> 28) == 0) {
                bl = false;
            }
            timerStatusData.mProgrammed = bl;
            if (timerStatusData.mProgrammed) {
                timerStatusData.mProgrammedInfo = 0xF & n >> 24;
                timerStatusData.mDurationHour = TimerStatusData.bcdByteToInt((byte)(0xFF & n >> 16));
                timerStatusData.mDurationMinute = TimerStatusData.bcdByteToInt((byte)(0xFF & n >> 8));
            } else {
                timerStatusData.mNotProgrammedError = 0xF & n >> 24;
                timerStatusData.mDurationHour = TimerStatusData.bcdByteToInt((byte)(0xFF & n >> 16));
                timerStatusData.mDurationMinute = TimerStatusData.bcdByteToInt((byte)(0xFF & n >> 8));
            }
            timerStatusData.mExtraError = n & 0xFF;
            return timerStatusData;
        }

        public int getDurationHour() {
            return this.mDurationHour;
        }

        public int getDurationMinute() {
            return this.mDurationMinute;
        }

        public int getExtraError() {
            return this.mExtraError;
        }

        public int getMediaInfo() {
            return this.mMediaInfo;
        }

        public int getNotProgammedError() {
            if (this.isProgrammed()) {
                throw new IllegalStateException("Has no not-programmed error. Call getProgrammedInfo() instead.");
            }
            return this.mNotProgrammedError;
        }

        public int getProgrammedInfo() {
            if (!this.isProgrammed()) {
                throw new IllegalStateException("No programmed info. Call getNotProgammedError() instead.");
            }
            return this.mProgrammedInfo;
        }

        public boolean isOverlapped() {
            return this.mOverlapped;
        }

        public boolean isProgrammed() {
            return this.mProgrammed;
        }
    }
}

