/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.location;

import android.content.Context;
import android.hardware.location.ActivityChangedEvent;
import android.hardware.location.ActivityRecognitionEvent;
import android.hardware.location.IActivityRecognitionHardware;
import android.hardware.location.IActivityRecognitionHardwareSink;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;

public class ActivityRecognitionHardware
extends IActivityRecognitionHardware.Stub {
    private static final String HARDWARE_PERMISSION = "android.permission.LOCATION_HARDWARE";
    private static final int INVALID_ACTIVITY_TYPE = -1;
    private static final int NATIVE_SUCCESS_RESULT = 0;
    private static final String TAG = "ActivityRecognitionHardware";
    private static ActivityRecognitionHardware sSingletonInstance = null;
    private static final Object sSingletonInstanceLock = new Object();
    private final Context mContext;
    private final RemoteCallbackList<IActivityRecognitionHardwareSink> mSinks = new RemoteCallbackList();
    private final String[] mSupportedActivities;

    static {
        ActivityRecognitionHardware.nativeClassInit();
    }

    private ActivityRecognitionHardware(Context context) {
        this.nativeInitialize();
        this.mContext = context;
        this.mSupportedActivities = this.fetchSupportedActivities();
    }

    private void checkPermissions() {
        String string2 = String.format("Permission '%s' not granted to access ActivityRecognitionHardware", HARDWARE_PERMISSION);
        this.mContext.enforceCallingPermission(HARDWARE_PERMISSION, string2);
    }

    private String[] fetchSupportedActivities() {
        String[] stringArray = this.nativeGetSupportedActivities();
        if (stringArray != null) {
            return stringArray;
        }
        return new String[0];
    }

    private String getActivityName(int n) {
        if (n < 0 || n >= this.mSupportedActivities.length) {
            Object[] objectArray = new Object[]{n, this.mSupportedActivities.length};
            Log.e(TAG, String.format("Invalid ActivityType: %d, SupportedActivities: %d", objectArray));
            return null;
        }
        return this.mSupportedActivities[n];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getActivityType(String string2) {
        if (TextUtils.isEmpty(string2)) {
            return -1;
        }
        int n = this.mSupportedActivities.length;
        int n2 = 0;
        while (n2 < n) {
            if (string2.equals(this.mSupportedActivities[n2])) return n2;
            ++n2;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ActivityRecognitionHardware getInstance(Context context) {
        Object object = sSingletonInstanceLock;
        synchronized (object) {
            if (sSingletonInstance != null) return sSingletonInstance;
            sSingletonInstance = new ActivityRecognitionHardware(context);
            return sSingletonInstance;
        }
    }

    public static boolean isSupported() {
        return ActivityRecognitionHardware.nativeIsSupported();
    }

    private static native void nativeClassInit();

    private native int nativeDisableActivityEvent(int var1, int var2);

    private native int nativeEnableActivityEvent(int var1, int var2, long var3);

    private native int nativeFlush();

    private native String[] nativeGetSupportedActivities();

    private native void nativeInitialize();

    private static native boolean nativeIsSupported();

    private native void nativeRelease();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onActivityChanged(Event[] eventArray) {
        if (eventArray == null || eventArray.length == 0) {
            Log.d(TAG, "No events to broadcast for onActivityChanged.");
            return;
        }
        int n = eventArray.length;
        ActivityRecognitionEvent[] activityRecognitionEventArray = new ActivityRecognitionEvent[n];
        for (int i = 0; i < n; ++i) {
            Event event = eventArray[i];
            activityRecognitionEventArray[i] = new ActivityRecognitionEvent(this.getActivityName(event.activity), event.type, event.timestamp);
        }
        ActivityChangedEvent activityChangedEvent = new ActivityChangedEvent(activityRecognitionEventArray);
        int n2 = this.mSinks.beginBroadcast();
        int n3 = 0;
        while (true) {
            if (n3 >= n2) {
                this.mSinks.finishBroadcast();
                return;
            }
            IActivityRecognitionHardwareSink iActivityRecognitionHardwareSink = this.mSinks.getBroadcastItem(n3);
            try {
                iActivityRecognitionHardwareSink.onActivityChanged(activityChangedEvent);
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Error delivering activity changed event.", remoteException);
            }
            ++n3;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean disableActivityEvent(String string2, int n) {
        this.checkPermissions();
        int n2 = this.getActivityType(string2);
        return n2 != -1 && this.nativeDisableActivityEvent(n2, n) == 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean enableActivityEvent(String string2, int n, long l) {
        this.checkPermissions();
        int n2 = this.getActivityType(string2);
        return n2 != -1 && this.nativeEnableActivityEvent(n2, n, l) == 0;
    }

    @Override
    public boolean flush() {
        this.checkPermissions();
        return this.nativeFlush() == 0;
    }

    @Override
    public String[] getSupportedActivities() {
        this.checkPermissions();
        return this.mSupportedActivities;
    }

    @Override
    public boolean isActivitySupported(String string2) {
        this.checkPermissions();
        return this.getActivityType(string2) != -1;
    }

    @Override
    public boolean registerSink(IActivityRecognitionHardwareSink iActivityRecognitionHardwareSink) {
        this.checkPermissions();
        return this.mSinks.register(iActivityRecognitionHardwareSink);
    }

    @Override
    public boolean unregisterSink(IActivityRecognitionHardwareSink iActivityRecognitionHardwareSink) {
        this.checkPermissions();
        return this.mSinks.unregister(iActivityRecognitionHardwareSink);
    }

    private static class Event {
        public int activity;
        public long timestamp;
        public int type;

        private Event() {
        }
    }
}

