/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import java.util.Locale;

public class Country
implements Parcelable {
    public static final int COUNTRY_SOURCE_LOCALE = 3;
    public static final int COUNTRY_SOURCE_LOCATION = 1;
    public static final int COUNTRY_SOURCE_NETWORK = 0;
    public static final int COUNTRY_SOURCE_SIM = 2;
    public static final Parcelable.Creator<Country> CREATOR = new Parcelable.Creator<Country>(){

        @Override
        public Country createFromParcel(Parcel parcel) {
            return new Country(parcel.readString(), parcel.readInt(), parcel.readLong());
        }

        public Country[] newArray(int n) {
            return new Country[n];
        }
    };
    private final String mCountryIso;
    private int mHashCode;
    private final int mSource;
    private final long mTimestamp;

    public Country(Country country) {
        this.mCountryIso = country.mCountryIso;
        this.mSource = country.mSource;
        this.mTimestamp = country.mTimestamp;
    }

    public Country(String string2, int n) {
        if (string2 == null || n < 0 || n > 3) {
            throw new IllegalArgumentException();
        }
        this.mCountryIso = string2.toUpperCase(Locale.US);
        this.mSource = n;
        this.mTimestamp = SystemClock.elapsedRealtime();
    }

    private Country(String string2, int n, long l) {
        if (string2 == null || n < 0 || n > 3) {
            throw new IllegalArgumentException();
        }
        this.mCountryIso = string2.toUpperCase(Locale.US);
        this.mSource = n;
        this.mTimestamp = l;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block5: {
            block4: {
                if (object == this) break block4;
                if (!(object instanceof Country)) {
                    return false;
                }
                Country country = (Country)object;
                if (!this.mCountryIso.equals(country.getCountryIso()) || this.mSource != country.getSource()) break block5;
            }
            return true;
        }
        return false;
    }

    public boolean equalsIgnoreSource(Country country) {
        return country != null && this.mCountryIso.equals(country.getCountryIso());
    }

    public final String getCountryIso() {
        return this.mCountryIso;
    }

    public final int getSource() {
        return this.mSource;
    }

    public final long getTimestamp() {
        return this.mTimestamp;
    }

    public int hashCode() {
        if (this.mHashCode == 0) {
            this.mHashCode = 13 * (221 + this.mCountryIso.hashCode()) + this.mSource;
        }
        return this.mHashCode;
    }

    public String toString() {
        return "Country {ISO=" + this.mCountryIso + ", source=" + this.mSource + ", time=" + this.mTimestamp + "}";
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.mCountryIso);
        parcel.writeInt(this.mSource);
        parcel.writeLong(this.mTimestamp);
    }
}

