/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.content.Context;
import android.location.Address;
import android.location.GeocoderParams;
import android.location.ILocationManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class Geocoder {
    private static final String TAG = "Geocoder";
    private GeocoderParams mParams;
    private ILocationManager mService;

    public Geocoder(Context context) {
        this(context, Locale.getDefault());
    }

    public Geocoder(Context context, Locale locale) {
        if (locale == null) {
            throw new NullPointerException("locale == null");
        }
        this.mParams = new GeocoderParams(context, locale);
        this.mService = ILocationManager.Stub.asInterface(ServiceManager.getService("location"));
    }

    public static boolean isPresent() {
        ILocationManager iLocationManager = ILocationManager.Stub.asInterface(ServiceManager.getService("location"));
        try {
            boolean bl = iLocationManager.geocoderIsPresent();
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "isPresent: got RemoteException", remoteException);
            return false;
        }
    }

    public List<Address> getFromLocation(double d, double d2, int n) throws IOException {
        ArrayList<Address> arrayList;
        block5: {
            if (d < -90.0 || d > 90.0) {
                throw new IllegalArgumentException("latitude == " + d);
            }
            if (d2 < -180.0 || d2 > 180.0) {
                throw new IllegalArgumentException("longitude == " + d2);
            }
            arrayList = new ArrayList<Address>();
            String string2 = this.mService.getFromLocation(d, d2, n, this.mParams, arrayList);
            if (string2 == null) break block5;
            try {
                throw new IOException(string2);
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "getFromLocation: got RemoteException", remoteException);
                arrayList = null;
            }
        }
        return arrayList;
    }

    public List<Address> getFromLocationName(String string2, int n) throws IOException {
        ArrayList<Address> arrayList;
        block4: {
            if (string2 == null) {
                throw new IllegalArgumentException("locationName == null");
            }
            arrayList = new ArrayList<Address>();
            String string3 = this.mService.getFromLocationName(string2, 0.0, 0.0, 0.0, 0.0, n, this.mParams, arrayList);
            if (string3 == null) break block4;
            try {
                throw new IOException(string3);
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "getFromLocationName: got RemoteException", remoteException);
                arrayList = null;
            }
        }
        return arrayList;
    }

    public List<Address> getFromLocationName(String string2, int n, double d, double d2, double d3, double d4) throws IOException {
        ArrayList<Address> arrayList;
        block8: {
            if (string2 == null) {
                throw new IllegalArgumentException("locationName == null");
            }
            if (d < -90.0 || d > 90.0) {
                throw new IllegalArgumentException("lowerLeftLatitude == " + d);
            }
            if (d2 < -180.0 || d2 > 180.0) {
                throw new IllegalArgumentException("lowerLeftLongitude == " + d2);
            }
            if (d3 < -90.0 || d3 > 90.0) {
                throw new IllegalArgumentException("upperRightLatitude == " + d3);
            }
            if (d4 < -180.0 || d4 > 180.0) {
                throw new IllegalArgumentException("upperRightLongitude == " + d4);
            }
            arrayList = new ArrayList<Address>();
            String string3 = this.mService.getFromLocationName(string2, d, d2, d3, d4, n, this.mParams, arrayList);
            if (string3 == null) break block8;
            try {
                throw new IOException(string3);
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "getFromLocationName: got RemoteException", remoteException);
                arrayList = null;
            }
        }
        return arrayList;
    }
}

