/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.security.InvalidParameterException;

public class GpsNavigationMessage
implements Parcelable {
    public static final Parcelable.Creator<GpsNavigationMessage> CREATOR;
    private static final byte[] EMPTY_ARRAY;
    private static final String TAG = "GpsNavigationMessage";
    public static final byte TYPE_CNAV2 = 4;
    public static final byte TYPE_L1CA = 1;
    public static final byte TYPE_L2CNAV = 2;
    public static final byte TYPE_L5CNAV = 3;
    public static final byte TYPE_UNKNOWN;
    private byte[] mData;
    private short mMessageId;
    private byte mPrn;
    private short mSubmessageId;
    private byte mType;

    static {
        EMPTY_ARRAY = new byte[0];
        CREATOR = new Parcelable.Creator<GpsNavigationMessage>(){

            @Override
            public GpsNavigationMessage createFromParcel(Parcel parcel) {
                GpsNavigationMessage gpsNavigationMessage = new GpsNavigationMessage();
                gpsNavigationMessage.setType(parcel.readByte());
                gpsNavigationMessage.setPrn(parcel.readByte());
                gpsNavigationMessage.setMessageId((short)parcel.readInt());
                gpsNavigationMessage.setSubmessageId((short)parcel.readInt());
                byte[] byArray = new byte[parcel.readInt()];
                parcel.readByteArray(byArray);
                gpsNavigationMessage.setData(byArray);
                return gpsNavigationMessage;
            }

            public GpsNavigationMessage[] newArray(int n) {
                return new GpsNavigationMessage[n];
            }
        };
    }

    GpsNavigationMessage() {
        this.initialize();
    }

    private String getTypeString() {
        switch (this.mType) {
            default: {
                return "<Invalid>";
            }
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "L1 C/A";
            }
            case 2: {
                return "L2-CNAV";
            }
            case 3: {
                return "L5-CNAV";
            }
            case 4: 
        }
        return "CNAV-2";
    }

    private void initialize() {
        this.mType = 0;
        this.mPrn = 0;
        this.mMessageId = (short)-1;
        this.mSubmessageId = (short)-1;
        this.mData = EMPTY_ARRAY;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public byte[] getData() {
        return this.mData;
    }

    public short getMessageId() {
        return this.mMessageId;
    }

    public byte getPrn() {
        return this.mPrn;
    }

    public short getSubmessageId() {
        return this.mSubmessageId;
    }

    public byte getType() {
        return this.mType;
    }

    public void reset() {
        this.initialize();
    }

    public void set(GpsNavigationMessage gpsNavigationMessage) {
        this.mType = gpsNavigationMessage.mType;
        this.mPrn = gpsNavigationMessage.mPrn;
        this.mMessageId = gpsNavigationMessage.mMessageId;
        this.mSubmessageId = gpsNavigationMessage.mSubmessageId;
        this.mData = gpsNavigationMessage.mData;
    }

    public void setData(byte[] byArray) {
        if (byArray == null) {
            throw new InvalidParameterException("Data must be a non-null array");
        }
        this.mData = byArray;
    }

    public void setMessageId(short s) {
        this.mMessageId = s;
    }

    public void setPrn(byte by) {
        this.mPrn = by;
    }

    public void setSubmessageId(short s) {
        this.mSubmessageId = s;
    }

    public void setType(byte by) {
        switch (by) {
            default: {
                Log.d(TAG, "Sanitizing invalid 'type': " + by);
                this.mType = 0;
                return;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
        }
        this.mType = by;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("GpsNavigationMessage:\n");
        Object[] objectArray = new Object[]{"Type", this.getTypeString()};
        stringBuilder.append(String.format("   %-15s = %s\n", objectArray));
        Object[] objectArray2 = new Object[]{"Prn", this.mPrn};
        stringBuilder.append(String.format("   %-15s = %s\n", objectArray2));
        Object[] objectArray3 = new Object[]{"MessageId", this.mMessageId};
        stringBuilder.append(String.format("   %-15s = %s\n", objectArray3));
        Object[] objectArray4 = new Object[]{"SubmessageId", this.mSubmessageId};
        stringBuilder.append(String.format("   %-15s = %s\n", objectArray4));
        stringBuilder.append(String.format("   %-15s = %s\n", "Data", "{"));
        String string2 = "        ";
        for (byte by : this.mData) {
            stringBuilder.append(string2);
            stringBuilder.append(by);
            string2 = ", ";
        }
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeByte(this.mType);
        parcel.writeByte(this.mPrn);
        parcel.writeInt(this.mMessageId);
        parcel.writeInt(this.mSubmessageId);
        parcel.writeInt(this.mData.length);
        parcel.writeByteArray(this.mData);
    }
}

