/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.graphics.Rect;
import java.nio.ByteBuffer;

public abstract class Image
implements AutoCloseable {
    private Rect mCropRect;

    protected Image() {
    }

    @Override
    public abstract void close();

    public Rect getCropRect() {
        if (this.mCropRect == null) {
            return new Rect(0, 0, this.getWidth(), this.getHeight());
        }
        return new Rect(this.mCropRect);
    }

    public abstract int getFormat();

    public abstract int getHeight();

    public abstract Plane[] getPlanes();

    public abstract long getTimestamp();

    public abstract int getWidth();

    public void setCropRect(Rect rect) {
        Rect rect2 = new Rect(rect);
        rect2.intersect(0, 0, this.getWidth(), this.getHeight());
        this.mCropRect = rect2;
    }

    public static abstract class Plane {
        protected Plane() {
        }

        public abstract ByteBuffer getBuffer();

        public abstract int getPixelStride();

        public abstract int getRowStride();
    }
}

