/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.DecoderCapabilities;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class MediaFile {
    public static final int FILE_TYPE_3GA = 11;
    public static final int FILE_TYPE_3GPP = 23;
    public static final int FILE_TYPE_3GPP2 = 24;
    public static final int FILE_TYPE_AAC = 8;
    public static final int FILE_TYPE_ABU = 308;
    public static final int FILE_TYPE_ACSM = 301;
    public static final int FILE_TYPE_AMR = 4;
    public static final int FILE_TYPE_ASF = 26;
    public static final int FILE_TYPE_AVI = 29;
    public static final int FILE_TYPE_AWB = 5;
    public static final int FILE_TYPE_BMP = 34;
    public static final int FILE_TYPE_CALLLOG_BACKUP = 109;
    public static final int FILE_TYPE_CEPUB = 302;
    public static final int FILE_TYPE_EML = 307;
    public static final int FILE_TYPE_EPUB = 300;
    public static final int FILE_TYPE_FL = 51;
    public static final int FILE_TYPE_FLAC = 10;
    public static final int FILE_TYPE_GIF = 32;
    public static final int FILE_TYPE_HTML = 101;
    public static final int FILE_TYPE_HTTPLIVE = 44;
    public static final int FILE_TYPE_IMY = 14;
    public static final int FILE_TYPE_JPEG = 31;
    public static final int FILE_TYPE_M3U = 41;
    public static final int FILE_TYPE_M4A = 2;
    public static final int FILE_TYPE_M4V = 22;
    public static final int FILE_TYPE_MID = 12;
    public static final int FILE_TYPE_MKA = 9;
    public static final int FILE_TYPE_MKV = 27;
    public static final int FILE_TYPE_MP2PS = 200;
    public static final int FILE_TYPE_MP2TS = 28;
    public static final int FILE_TYPE_MP3 = 1;
    public static final int FILE_TYPE_MP4 = 21;
    public static final int FILE_TYPE_MS_EXCEL = 105;
    public static final int FILE_TYPE_MS_POWERPOINT = 106;
    public static final int FILE_TYPE_MS_WORD = 104;
    public static final int FILE_TYPE_OGG = 7;
    public static final int FILE_TYPE_PDB = 304;
    public static final int FILE_TYPE_PDF = 102;
    public static final int FILE_TYPE_PLS = 42;
    public static final int FILE_TYPE_PNG = 33;
    public static final int FILE_TYPE_PUB = 306;
    public static final int FILE_TYPE_RMVB = 303;
    public static final int FILE_TYPE_SMF = 13;
    public static final int FILE_TYPE_SMS_BACKUP = 108;
    public static final int FILE_TYPE_TEXT = 100;
    public static final int FILE_TYPE_UPDB = 305;
    public static final int FILE_TYPE_WAV = 3;
    public static final int FILE_TYPE_WBMP = 35;
    public static final int FILE_TYPE_WEBM = 30;
    public static final int FILE_TYPE_WEBP = 36;
    public static final int FILE_TYPE_WMA = 6;
    public static final int FILE_TYPE_WMV = 25;
    public static final int FILE_TYPE_WPL = 43;
    public static final int FILE_TYPE_XML = 103;
    public static final int FILE_TYPE_ZIP = 107;
    private static final int FIRST_AUDIO_FILE_TYPE = 1;
    private static final int FIRST_DRM_FILE_TYPE = 51;
    private static final int FIRST_IMAGE_FILE_TYPE = 31;
    private static final int FIRST_MIDI_FILE_TYPE = 12;
    private static final int FIRST_PLAYLIST_FILE_TYPE = 41;
    private static final int FIRST_VIDEO_FILE_TYPE = 21;
    private static final int FIRST_VIDEO_FILE_TYPE2 = 200;
    private static final int LAST_AUDIO_FILE_TYPE = 11;
    private static final int LAST_DRM_FILE_TYPE = 51;
    private static final int LAST_IMAGE_FILE_TYPE = 36;
    private static final int LAST_MIDI_FILE_TYPE = 14;
    private static final int LAST_PLAYLIST_FILE_TYPE = 44;
    private static final int LAST_VIDEO_FILE_TYPE = 30;
    private static final int LAST_VIDEO_FILE_TYPE2 = 200;
    private static final HashMap<String, MediaFileType> sFileTypeMap = new HashMap();
    private static final HashMap<String, Integer> sFileTypeToFormatMap;
    private static final HashMap<Integer, String> sFormatToMimeTypeMap;
    private static final HashMap<String, Integer> sMimeTypeMap;
    private static final HashMap<String, Integer> sMimeTypeToFormatMap;

    static {
        sMimeTypeMap = new HashMap();
        sFileTypeToFormatMap = new HashMap();
        sMimeTypeToFormatMap = new HashMap();
        sFormatToMimeTypeMap = new HashMap();
        MediaFile.addFileType("MP3", 1, "audio/mpeg", 12297);
        MediaFile.addFileType("MPGA", 1, "audio/mpeg", 12297);
        MediaFile.addFileType("M4A", 2, "audio/mp4", 12299);
        MediaFile.addFileType("WAV", 3, "audio/x-wav", 12296);
        MediaFile.addFileType("AMR", 4, "audio/amr");
        MediaFile.addFileType("AWB", 5, "audio/amr-wb");
        MediaFile.addFileType("3GA", 11, "audio/3ga");
        MediaFile.addFileType("OGG", 7, "audio/ogg", 47362);
        MediaFile.addFileType("OGG", 7, "application/ogg", 47362);
        MediaFile.addFileType("OGA", 7, "application/ogg", 47362);
        MediaFile.addFileType("AAC", 8, "audio/aac", 47363);
        MediaFile.addFileType("AAC", 8, "audio/aac-adts", 47363);
        MediaFile.addFileType("MKA", 9, "audio/x-matroska");
        MediaFile.addFileType("MID", 12, "audio/midi");
        MediaFile.addFileType("MIDI", 12, "audio/midi");
        MediaFile.addFileType("XMF", 12, "audio/midi");
        MediaFile.addFileType("RTTTL", 12, "audio/midi");
        MediaFile.addFileType("SMF", 13, "audio/sp-midi");
        MediaFile.addFileType("IMY", 14, "audio/imelody");
        MediaFile.addFileType("RTX", 12, "audio/midi");
        MediaFile.addFileType("OTA", 12, "audio/midi");
        MediaFile.addFileType("MPEG", 21, "video/mpeg", 12299);
        MediaFile.addFileType("MPG", 21, "video/mpeg", 12299);
        MediaFile.addFileType("MP4", 21, "video/mp4", 12299);
        MediaFile.addFileType("M4V", 22, "video/mp4", 12299);
        MediaFile.addFileType("3GP", 23, "video/3gpp", 47492);
        MediaFile.addFileType("3GPP", 23, "video/3gpp", 47492);
        MediaFile.addFileType("3G2", 24, "video/3gpp2", 47492);
        MediaFile.addFileType("3GPP2", 24, "video/3gpp2", 47492);
        MediaFile.addFileType("MKV", 27, "video/x-matroska");
        MediaFile.addFileType("WEBM", 30, "video/webm");
        MediaFile.addFileType("TS", 28, "video/mp2ts");
        MediaFile.addFileType("AVI", 29, "video/avi");
        MediaFile.addFileType("JPG", 31, "image/jpeg", 14337);
        MediaFile.addFileType("JPEG", 31, "image/jpeg", 14337);
        MediaFile.addFileType("GIF", 32, "image/gif", 14343);
        MediaFile.addFileType("PNG", 33, "image/png", 14347);
        MediaFile.addFileType("BMP", 34, "image/x-ms-bmp", 14340);
        MediaFile.addFileType("WBMP", 35, "image/vnd.wap.wbmp");
        MediaFile.addFileType("WEBP", 36, "image/webp");
        MediaFile.addFileType("M3U", 41, "audio/x-mpegurl", 47633);
        MediaFile.addFileType("M3U", 41, "application/x-mpegurl", 47633);
        MediaFile.addFileType("PLS", 42, "audio/x-scpls", 47636);
        MediaFile.addFileType("WPL", 43, "application/vnd.ms-wpl", 47632);
        MediaFile.addFileType("M3U8", 44, "application/vnd.apple.mpegurl");
        MediaFile.addFileType("M3U8", 44, "audio/mpegurl");
        MediaFile.addFileType("M3U8", 44, "audio/x-mpegurl");
        MediaFile.addFileType("FL", 51, "application/x-android-drm-fl");
        MediaFile.addFileType("TXT", 100, "text/plain", 12292);
        MediaFile.addFileType("HTM", 101, "text/html", 12293);
        MediaFile.addFileType("HTML", 101, "text/html", 12293);
        MediaFile.addFileType("PDF", 102, "application/pdf");
        MediaFile.addFileType("DOC", 104, "application/msword", 47747);
        MediaFile.addFileType("XLS", 105, "application/vnd.ms-excel", 47749);
        MediaFile.addFileType("PPT", 106, "application/vnd.ms-powerpoint", 47750);
        MediaFile.addFileType("FLAC", 10, "audio/flac", 47366);
        MediaFile.addFileType("ZIP", 107, "application/zip");
        MediaFile.addFileType("MPG", 200, "video/mp2p");
        MediaFile.addFileType("MPEG", 200, "video/mp2p");
        MediaFile.addFileType("SMSBACKUP", 108, "application/sms-backup");
        MediaFile.addFileType("CLBU", 109, "application/calllog-backup");
        MediaFile.addFileType("DOCX", 104, "application/msword");
        MediaFile.addFileType("XLT", 105, "application/vnd.ms-excel");
        MediaFile.addFileType("XLSX", 105, "application/vnd.ms-excel");
        MediaFile.addFileType("POT", 106, "application/vnd.ms-powerpoint");
        MediaFile.addFileType("PPS", 106, "application/vnd.ms-powerpoint");
        MediaFile.addFileType("PPTX", 106, "application/vnd.ms-powerpoint");
        MediaFile.addFileType("EPUB", 300, "application/epub+zip");
        MediaFile.addFileType("ACSM", 301, "application/vnd.adobe.adept+xml");
        MediaFile.addFileType("CEPUB", 302, "application/octet-stream");
        MediaFile.addFileType("RMVB", 303, "video/vnd.rn-realvideo");
        MediaFile.addFileType("AAC", 8, "audio/aac-adts", 47363);
        MediaFile.addFileType("PDB", 304, "application/vnd.palm");
        MediaFile.addFileType("UPDB", 305, "application/vnd.palm");
        MediaFile.addFileType("PUB", 306, "application/x-mspublisher");
        MediaFile.addFileType("EML", 307, "message/rfc822");
        MediaFile.addFileType("ABU", 308, "application/vnd.asus-appbackup");
    }

    static void addFileType(String string2, int n, String string3) {
        sFileTypeMap.put(string2, new MediaFileType(n, string3));
        sMimeTypeMap.put(string3, n);
    }

    static void addFileType(String string2, int n, String string3, int n2) {
        MediaFile.addFileType(string2, n, string3);
        sFileTypeToFormatMap.put(string2, n2);
        sMimeTypeToFormatMap.put(string3, n2);
        sFormatToMimeTypeMap.put(n2, string3);
    }

    public static String getFileTitle(String string2) {
        int n;
        int n2;
        int n3 = string2.lastIndexOf(47);
        if (n3 >= 0 && (n2 = n3 + 1) < string2.length()) {
            string2 = string2.substring(n2);
        }
        if ((n = string2.lastIndexOf(46)) > 0) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    public static MediaFileType getFileType(String string2) {
        int n = string2.lastIndexOf(46);
        if (n < 0) {
            return null;
        }
        return sFileTypeMap.get(string2.substring(n + 1).toUpperCase(Locale.ROOT));
    }

    public static int getFileTypeForMimeType(String string2) {
        Integer n = sMimeTypeMap.get(string2);
        if (n == null) {
            return 0;
        }
        return n;
    }

    public static int getFormatCode(String string2, String string3) {
        String string4;
        Integer n;
        Integer n2;
        if (string3 != null && (n2 = sMimeTypeToFormatMap.get(string3)) != null) {
            return n2;
        }
        int n3 = string2.lastIndexOf(46);
        if (n3 > 0 && (n = sFileTypeToFormatMap.get(string4 = string2.substring(n3 + 1).toUpperCase(Locale.ROOT))) != null) {
            return n;
        }
        return 12288;
    }

    public static String getMimeTypeForFile(String string2) {
        MediaFileType mediaFileType = MediaFile.getFileType(string2);
        if (mediaFileType == null) {
            return null;
        }
        return mediaFileType.mimeType;
    }

    public static String getMimeTypeForFormatCode(int n) {
        return sFormatToMimeTypeMap.get(n);
    }

    public static boolean isAudioFileType(int n) {
        return n >= 1 && n <= 11 || n >= 12 && n <= 14;
    }

    public static boolean isDrmFileType(int n) {
        return n >= 51 && n <= 51;
    }

    public static boolean isImageFileType(int n) {
        return n >= 31 && n <= 36;
    }

    public static boolean isMimeTypeMedia(String string2) {
        int n = MediaFile.getFileTypeForMimeType(string2);
        return MediaFile.isAudioFileType(n) || MediaFile.isVideoFileType(n) || MediaFile.isImageFileType(n) || MediaFile.isPlayListFileType(n);
    }

    public static boolean isPlayListFileType(int n) {
        return n >= 41 && n <= 44;
    }

    public static boolean isVideoFileType(int n) {
        return n >= 21 && n <= 30 || n >= 200 && n <= 200;
    }

    private static boolean isWMAEnabled() {
        List<DecoderCapabilities.AudioDecoder> list = DecoderCapabilities.getAudioDecoders();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (list.get(i) != DecoderCapabilities.AudioDecoder.AUDIO_DECODER_WMA) continue;
            return true;
        }
        return false;
    }

    private static boolean isWMVEnabled() {
        List<DecoderCapabilities.VideoDecoder> list = DecoderCapabilities.getVideoDecoders();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (list.get(i) != DecoderCapabilities.VideoDecoder.VIDEO_DECODER_WMV) continue;
            return true;
        }
        return false;
    }

    public static class MediaFileType {
        public final int fileType;
        public final String mimeType;

        MediaFileType(int n, String string2) {
            this.fileType = n;
            this.mimeType = string2;
        }
    }
}

