/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.media.IMediaScannerListener;
import android.media.IMediaScannerService;
import android.net.Uri;
import android.os.IBinder;
import android.os.RemoteException;

public class MediaScannerConnection
implements ServiceConnection {
    private static final String TAG = "MediaScannerConnection";
    private MediaScannerConnectionClient mClient;
    private boolean mConnected;
    private Context mContext;
    private final IMediaScannerListener.Stub mListener = new IMediaScannerListener.Stub(){

        @Override
        public void scanCompleted(String string2, Uri uri) {
            MediaScannerConnectionClient mediaScannerConnectionClient = MediaScannerConnection.this.mClient;
            if (mediaScannerConnectionClient != null) {
                mediaScannerConnectionClient.onScanCompleted(string2, uri);
            }
        }
    };
    private IMediaScannerService mService;

    public MediaScannerConnection(Context context, MediaScannerConnectionClient mediaScannerConnectionClient) {
        this.mContext = context;
        this.mClient = mediaScannerConnectionClient;
    }

    public static void scanFile(Context context, String[] stringArray, String[] stringArray2, OnScanCompletedListener onScanCompletedListener) {
        MediaScannerConnection mediaScannerConnection;
        ClientProxy clientProxy = new ClientProxy(stringArray, stringArray2, onScanCompletedListener);
        clientProxy.mConnection = mediaScannerConnection = new MediaScannerConnection(context, clientProxy);
        mediaScannerConnection.connect();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect() {
        synchronized (this) {
            if (!this.mConnected) {
                Intent intent = new Intent(IMediaScannerService.class.getName());
                intent.setComponent(new ComponentName("com.android.providers.media", "com.android.providers.media.MediaScannerService"));
                this.mContext.bindService(intent, this, 1);
                this.mConnected = true;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void disconnect() {
        synchronized (this) {
            boolean bl = this.mConnected;
            if (bl) {
                try {
                    this.mContext.unbindService(this);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                this.mConnected = false;
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isConnected() {
        synchronized (this) {
            if (this.mService == null) return false;
            boolean bl = this.mConnected;
            if (!bl) return false;
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        synchronized (this) {
            this.mService = IMediaScannerService.Stub.asInterface(iBinder);
            if (this.mService != null && this.mClient != null) {
                this.mClient.onMediaScannerConnected();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onServiceDisconnected(ComponentName componentName) {
        synchronized (this) {
            this.mService = null;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void scanFile(String string2, String string3) {
        synchronized (this) {
            if (this.mService == null || !this.mConnected) {
                throw new IllegalStateException("not connected to MediaScannerService");
            }
            try {
                this.mService.requestScanFile(string2, string3, this.mListener);
            }
            catch (RemoteException remoteException) {}
            return;
        }
    }

    static class ClientProxy
    implements MediaScannerConnectionClient {
        final OnScanCompletedListener mClient;
        MediaScannerConnection mConnection;
        final String[] mMimeTypes;
        int mNextPath;
        final String[] mPaths;

        ClientProxy(String[] stringArray, String[] stringArray2, OnScanCompletedListener onScanCompletedListener) {
            this.mPaths = stringArray;
            this.mMimeTypes = stringArray2;
            this.mClient = onScanCompletedListener;
        }

        @Override
        public void onMediaScannerConnected() {
            this.scanNextPath();
        }

        @Override
        public void onScanCompleted(String string2, Uri uri) {
            if (this.mClient != null) {
                this.mClient.onScanCompleted(string2, uri);
            }
            this.scanNextPath();
        }

        /*
         * Enabled aggressive block sorting
         */
        void scanNextPath() {
            if (this.mNextPath >= this.mPaths.length) {
                this.mConnection.disconnect();
                return;
            }
            String string2 = this.mMimeTypes != null ? this.mMimeTypes[this.mNextPath] : null;
            this.mConnection.scanFile(this.mPaths[this.mNextPath], string2);
            this.mNextPath = 1 + this.mNextPath;
        }
    }

    public static interface MediaScannerConnectionClient
    extends OnScanCompletedListener {
        public void onMediaScannerConnected();

        @Override
        public void onScanCompleted(String var1, Uri var2);
    }

    public static interface OnScanCompletedListener {
        public void onScanCompleted(String var1, Uri var2);
    }
}

