/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.Context;
import android.media.SubtitleTrack;
import android.media.TextTrackCue;
import android.media.TextTrackCueSpan;
import android.media.TextTrackRegion;
import android.text.Layout;
import android.text.SpannableStringBuilder;
import android.util.ArrayMap;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.CaptioningManager;
import android.widget.LinearLayout;
import com.android.internal.widget.SubtitleView;
import java.util.ArrayList;
import java.util.Vector;

class WebVttRenderingWidget
extends ViewGroup
implements SubtitleTrack.RenderingWidget {
    private static final boolean DEBUG = false;
    private static final int DEBUG_CUE_BACKGROUND = -2130771968;
    private static final int DEBUG_REGION_BACKGROUND = -2147483393;
    private static final CaptioningManager.CaptionStyle DEFAULT_CAPTION_STYLE = CaptioningManager.CaptionStyle.DEFAULT;
    private static final float LINE_HEIGHT_RATIO = 0.0533f;
    private CaptioningManager.CaptionStyle mCaptionStyle;
    private final CaptioningManager.CaptioningChangeListener mCaptioningListener;
    private final ArrayMap<TextTrackCue, CueLayout> mCueBoxes;
    private float mFontSize;
    private boolean mHasChangeListener;
    private SubtitleTrack.RenderingWidget.OnChangedListener mListener;
    private final CaptioningManager mManager;
    private final ArrayMap<TextTrackRegion, RegionLayout> mRegionBoxes = new ArrayMap();

    public WebVttRenderingWidget(Context context) {
        this(context, null);
    }

    public WebVttRenderingWidget(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public WebVttRenderingWidget(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public WebVttRenderingWidget(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.mCueBoxes = new ArrayMap();
        this.mCaptioningListener = new CaptioningManager.CaptioningChangeListener(){

            @Override
            public void onFontScaleChanged(float f) {
                float f2 = 0.0533f * (f * (float)WebVttRenderingWidget.this.getHeight());
                WebVttRenderingWidget.this.setCaptionStyle(WebVttRenderingWidget.this.mCaptionStyle, f2);
            }

            @Override
            public void onUserStyleChanged(CaptioningManager.CaptionStyle captionStyle) {
                WebVttRenderingWidget.this.setCaptionStyle(captionStyle, WebVttRenderingWidget.this.mFontSize);
            }
        };
        this.setLayerType(1, null);
        this.mManager = (CaptioningManager)context.getSystemService("captioning");
        this.mCaptionStyle = this.mManager.getUserStyle();
        this.mFontSize = 0.0533f * (this.mManager.getFontScale() * (float)this.getHeight());
    }

    /*
     * Enabled aggressive block sorting
     */
    private int calculateLinePosition(CueLayout cueLayout) {
        block5: {
            block4: {
                TextTrackCue textTrackCue = cueLayout.getCue();
                Integer n = textTrackCue.mLinePosition;
                boolean bl = textTrackCue.mSnapToLines;
                boolean bl2 = n == null;
                if (!bl && !bl2 && (n < 0 || n > 100)) break block4;
                if (!bl2) {
                    return n;
                }
                if (bl) break block5;
            }
            return 100;
        }
        return -(1 + cueLayout.mOrder);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void layoutCue(int n, int n2, CueLayout cueLayout) {
        int n3;
        TextTrackCue textTrackCue = cueLayout.getCue();
        int n4 = this.getLayoutDirection();
        int n5 = WebVttRenderingWidget.resolveCueAlignment(n4, textTrackCue.mAlignment);
        boolean bl = textTrackCue.mSnapToLines;
        int n6 = 100 * cueLayout.getMeasuredWidth() / n;
        switch (n5) {
            default: {
                n3 = textTrackCue.mTextPosition - n6 / 2;
                break;
            }
            case 203: {
                n3 = textTrackCue.mTextPosition;
                break;
            }
            case 204: {
                n3 = textTrackCue.mTextPosition - n6;
            }
        }
        if (n4 == 1) {
            n3 = 100 - n3;
        }
        if (bl) {
            float f;
            int n7 = 100 * this.getPaddingLeft() / n;
            int n8 = 100 * this.getPaddingRight() / n;
            if (n3 < n7 && n3 + n6 > n7) {
                n3 += n7;
                n6 -= n7;
            }
            if ((float)n3 < (f = (float)(100 - n8)) && (float)(n3 + n6) > f) {
                n6 -= n8;
            }
        }
        int n9 = n3 * n / 100;
        int n10 = n6 * n / 100;
        int n11 = this.calculateLinePosition(cueLayout);
        int n12 = cueLayout.getMeasuredHeight();
        int n13 = n11 < 0 ? n2 + n11 * n12 : n11 * (n2 - n12) / 100;
        cueLayout.layout(n9, n13, n9 + n10, n13 + n12);
    }

    private void layoutRegion(int n, int n2, RegionLayout regionLayout) {
        TextTrackRegion textTrackRegion = regionLayout.getRegion();
        int n3 = regionLayout.getMeasuredHeight();
        int n4 = regionLayout.getMeasuredWidth();
        float f = textTrackRegion.mViewportAnchorPointX;
        float f2 = textTrackRegion.mViewportAnchorPointY;
        int n5 = (int)(f * (float)(n - n4) / 100.0f);
        int n6 = (int)(f2 * (float)(n2 - n3) / 100.0f);
        regionLayout.layout(n5, n6, n5 + n4, n6 + n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void manageChangeListener() {
        boolean bl = this.isAttachedToWindow() && this.getVisibility() == 0;
        if (this.mHasChangeListener != bl) {
            this.mHasChangeListener = bl;
            if (!bl) {
                this.mManager.removeCaptioningChangeListener(this.mCaptioningListener);
                return;
            }
            this.mManager.addCaptioningChangeListener(this.mCaptioningListener);
            this.setCaptionStyle(this.mManager.getUserStyle(), 0.0533f * (this.mManager.getFontScale() * (float)this.getHeight()));
        }
    }

    private void prepForPrune() {
        int n = this.mRegionBoxes.size();
        for (int i = 0; i < n; ++i) {
            this.mRegionBoxes.valueAt(i).prepForPrune();
        }
        int n2 = this.mCueBoxes.size();
        for (int i = 0; i < n2; ++i) {
            this.mCueBoxes.valueAt(i).prepForPrune();
        }
    }

    private void prune() {
        int n = this.mRegionBoxes.size();
        for (int i = 0; i < n; ++i) {
            RegionLayout regionLayout = this.mRegionBoxes.valueAt(i);
            if (!regionLayout.prune()) continue;
            this.removeView(regionLayout);
            this.mRegionBoxes.removeAt(i);
            --n;
            --i;
        }
        int n2 = this.mCueBoxes.size();
        for (int i = 0; i < n2; ++i) {
            CueLayout cueLayout = this.mCueBoxes.valueAt(i);
            if (cueLayout.isActive()) continue;
            this.removeView(cueLayout);
            this.mCueBoxes.removeAt(i);
            --n2;
            --i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int resolveCueAlignment(int n, int n2) {
        int n3 = 204;
        int n4 = 203;
        switch (n2) {
            default: {
                return n2;
            }
            case 201: {
                if (n == 0) return n4;
                return n3;
            }
            case 202: 
        }
        if (n != 0) return n4;
        return n3;
    }

    private void setCaptionStyle(CaptioningManager.CaptionStyle captionStyle, float f) {
        CaptioningManager.CaptionStyle captionStyle2;
        this.mCaptionStyle = captionStyle2 = DEFAULT_CAPTION_STYLE.applyStyle(captionStyle);
        this.mFontSize = f;
        int n = this.mCueBoxes.size();
        for (int i = 0; i < n; ++i) {
            this.mCueBoxes.valueAt(i).setCaptionStyle(captionStyle2, f);
        }
        int n2 = this.mRegionBoxes.size();
        for (int i = 0; i < n2; ++i) {
            this.mRegionBoxes.valueAt(i).setCaptionStyle(captionStyle2, f);
        }
    }

    @Override
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.manageChangeListener();
    }

    @Override
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.manageChangeListener();
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        int n5 = n3 - n;
        int n6 = n4 - n2;
        this.setCaptionStyle(this.mCaptionStyle, 0.0533f * this.mManager.getFontScale() * (float)n6);
        int n7 = this.mRegionBoxes.size();
        for (int i = 0; i < n7; ++i) {
            this.layoutRegion(n5, n6, this.mRegionBoxes.valueAt(i));
        }
        int n8 = this.mCueBoxes.size();
        for (int i = 0; i < n8; ++i) {
            this.layoutCue(n5, n6, this.mCueBoxes.valueAt(i));
        }
    }

    @Override
    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        int n3 = this.mRegionBoxes.size();
        for (int i = 0; i < n3; ++i) {
            this.mRegionBoxes.valueAt(i).measureForParent(n, n2);
        }
        int n4 = this.mCueBoxes.size();
        for (int i = 0; i < n4; ++i) {
            this.mCueBoxes.valueAt(i).measureForParent(n, n2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setActiveCues(Vector<SubtitleTrack.Cue> vector) {
        Context context = this.getContext();
        CaptioningManager.CaptionStyle captionStyle = this.mCaptionStyle;
        float f = this.mFontSize;
        this.prepForPrune();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            TextTrackCue textTrackCue = (TextTrackCue)vector.get(i);
            TextTrackRegion textTrackRegion = textTrackCue.mRegion;
            if (textTrackRegion != null) {
                RegionLayout regionLayout = this.mRegionBoxes.get(textTrackRegion);
                if (regionLayout == null) {
                    regionLayout = new RegionLayout(context, textTrackRegion, captionStyle, f);
                    this.mRegionBoxes.put(textTrackRegion, regionLayout);
                    this.addView((View)regionLayout, -2, -2);
                }
                regionLayout.put(textTrackCue);
                continue;
            }
            CueLayout cueLayout = this.mCueBoxes.get(textTrackCue);
            if (cueLayout == null) {
                cueLayout = new CueLayout(context, textTrackCue, captionStyle, f);
                this.mCueBoxes.put(textTrackCue, cueLayout);
                this.addView((View)cueLayout, -2, -2);
            }
            cueLayout.update();
            cueLayout.setOrder(i);
        }
        this.prune();
        this.setSize(this.getWidth(), this.getHeight());
        if (this.mListener != null) {
            this.mListener.onChanged(this);
        }
    }

    @Override
    public void setOnChangedListener(SubtitleTrack.RenderingWidget.OnChangedListener onChangedListener) {
        this.mListener = onChangedListener;
    }

    @Override
    public void setSize(int n, int n2) {
        this.measure(View.MeasureSpec.makeMeasureSpec(n, 0x40000000), View.MeasureSpec.makeMeasureSpec(n2, 0x40000000));
        this.layout(0, 0, n, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.setVisibility(0);
        } else {
            this.setVisibility(8);
        }
        this.manageChangeListener();
    }

    private static class CueLayout
    extends LinearLayout {
        private boolean mActive;
        private CaptioningManager.CaptionStyle mCaptionStyle;
        public final TextTrackCue mCue;
        private float mFontSize;
        private int mOrder;

        /*
         * Enabled aggressive block sorting
         */
        public CueLayout(Context context, TextTrackCue textTrackCue, CaptioningManager.CaptionStyle captionStyle, float f) {
            int n = 1;
            super(context);
            this.mCue = textTrackCue;
            this.mCaptionStyle = captionStyle;
            this.mFontSize = f;
            int n2 = textTrackCue.mWritingDirection == 100 ? n : 0;
            int n3 = 0;
            if (n2 != 0) {
                n3 = n;
            }
            this.setOrientation(n3);
            switch (textTrackCue.mAlignment) {
                case 202: {
                    this.setGravity(0x800005);
                    break;
                }
                case 203: {
                    this.setGravity(3);
                    break;
                }
                case 200: {
                    if (n2 == 0) {
                        n = 16;
                    }
                    this.setGravity(n);
                    break;
                }
                case 204: {
                    this.setGravity(5);
                    break;
                }
                case 201: {
                    this.setGravity(0x800003);
                    break;
                }
            }
            this.update();
        }

        public TextTrackCue getCue() {
            return this.mCue;
        }

        public boolean isActive() {
            return this.mActive;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void measureForParent(int n, int n2) {
            int n3;
            TextTrackCue textTrackCue = this.mCue;
            int n4 = View.MeasureSpec.getSize(n);
            int n5 = View.MeasureSpec.getSize(n2);
            switch (WebVttRenderingWidget.resolveCueAlignment(this.getLayoutDirection(), textTrackCue.mAlignment)) {
                default: {
                    n3 = 0;
                    break;
                }
                case 203: {
                    n3 = 100 - textTrackCue.mTextPosition;
                    break;
                }
                case 204: {
                    n3 = textTrackCue.mTextPosition;
                    break;
                }
                case 200: {
                    n3 = textTrackCue.mTextPosition <= 50 ? 2 * textTrackCue.mTextPosition : 2 * (100 - textTrackCue.mTextPosition);
                }
            }
            this.measure(View.MeasureSpec.makeMeasureSpec(n4 * Math.min(textTrackCue.mSize, n3) / 100, Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec(n5, Integer.MIN_VALUE));
        }

        @Override
        protected void onMeasure(int n, int n2) {
            super.onMeasure(n, n2);
        }

        public void prepForPrune() {
            this.mActive = false;
        }

        public void setCaptionStyle(CaptioningManager.CaptionStyle captionStyle, float f) {
            this.mCaptionStyle = captionStyle;
            this.mFontSize = f;
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                View view = this.getChildAt(i);
                if (!(view instanceof SpanLayout)) continue;
                ((SpanLayout)view).setCaptionStyle(captionStyle, f);
            }
        }

        public void setOrder(int n) {
            this.mOrder = n;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void update() {
            Layout.Alignment alignment;
            this.mActive = true;
            this.removeAllViews();
            switch (WebVttRenderingWidget.resolveCueAlignment(this.getLayoutDirection(), this.mCue.mAlignment)) {
                default: {
                    alignment = Layout.Alignment.ALIGN_CENTER;
                    break;
                }
                case 203: {
                    alignment = Layout.Alignment.ALIGN_LEFT;
                    break;
                }
                case 204: {
                    alignment = Layout.Alignment.ALIGN_RIGHT;
                }
            }
            CaptioningManager.CaptionStyle captionStyle = this.mCaptionStyle;
            float f = this.mFontSize;
            TextTrackCueSpan[][] textTrackCueSpanArray = this.mCue.mLines;
            int n = textTrackCueSpanArray.length;
            for (int i = 0; i < n; ++i) {
                SpanLayout spanLayout = new SpanLayout(this.getContext(), textTrackCueSpanArray[i]);
                spanLayout.setAlignment(alignment);
                spanLayout.setCaptionStyle(captionStyle, f);
                this.addView((View)spanLayout, -2, -2);
            }
        }
    }

    private static class RegionLayout
    extends LinearLayout {
        private CaptioningManager.CaptionStyle mCaptionStyle;
        private float mFontSize;
        private final TextTrackRegion mRegion;
        private final ArrayList<CueLayout> mRegionCueBoxes = new ArrayList();

        public RegionLayout(Context context, TextTrackRegion textTrackRegion, CaptioningManager.CaptionStyle captionStyle, float f) {
            super(context);
            this.mRegion = textTrackRegion;
            this.mCaptionStyle = captionStyle;
            this.mFontSize = f;
            this.setOrientation(1);
            this.setBackgroundColor(captionStyle.windowColor);
        }

        public TextTrackRegion getRegion() {
            return this.mRegion;
        }

        public void measureForParent(int n, int n2) {
            TextTrackRegion textTrackRegion = this.mRegion;
            int n3 = View.MeasureSpec.getSize(n);
            int n4 = View.MeasureSpec.getSize(n2);
            this.measure(View.MeasureSpec.makeMeasureSpec(n3 * (int)textTrackRegion.mWidth / 100, Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec(n4, Integer.MIN_VALUE));
        }

        public void prepForPrune() {
            int n = this.mRegionCueBoxes.size();
            for (int i = 0; i < n; ++i) {
                this.mRegionCueBoxes.get(i).prepForPrune();
            }
        }

        public boolean prune() {
            int n = this.mRegionCueBoxes.size();
            for (int i = 0; i < n; ++i) {
                CueLayout cueLayout = this.mRegionCueBoxes.get(i);
                if (cueLayout.isActive()) continue;
                this.mRegionCueBoxes.remove(i);
                this.removeView(cueLayout);
                --n;
                --i;
            }
            return this.mRegionCueBoxes.isEmpty();
        }

        /*
         * Enabled aggressive block sorting
         */
        public void put(TextTrackCue textTrackCue) {
            int n = this.mRegionCueBoxes.size();
            for (int i = 0; i < n; ++i) {
                CueLayout cueLayout = this.mRegionCueBoxes.get(i);
                if (cueLayout.getCue() != textTrackCue) continue;
                cueLayout.update();
                return;
            }
            CueLayout cueLayout = new CueLayout(this.getContext(), textTrackCue, this.mCaptionStyle, this.mFontSize);
            this.mRegionCueBoxes.add(cueLayout);
            this.addView((View)cueLayout, -2, -2);
            if (this.getChildCount() <= this.mRegion.mLines) return;
            this.removeViewAt(0);
        }

        public void setCaptionStyle(CaptioningManager.CaptionStyle captionStyle, float f) {
            this.mCaptionStyle = captionStyle;
            this.mFontSize = f;
            int n = this.mRegionCueBoxes.size();
            for (int i = 0; i < n; ++i) {
                this.mRegionCueBoxes.get(i).setCaptionStyle(captionStyle, f);
            }
            this.setBackgroundColor(captionStyle.windowColor);
        }
    }

    private static class SpanLayout
    extends SubtitleView {
        private final SpannableStringBuilder mBuilder = new SpannableStringBuilder();
        private final TextTrackCueSpan[] mSpans;

        public SpanLayout(Context context, TextTrackCueSpan[] textTrackCueSpanArray) {
            super(context);
            this.mSpans = textTrackCueSpanArray;
            this.update();
        }

        public void setCaptionStyle(CaptioningManager.CaptionStyle captionStyle, float f) {
            this.setBackgroundColor(captionStyle.backgroundColor);
            this.setForegroundColor(captionStyle.foregroundColor);
            this.setEdgeColor(captionStyle.edgeColor);
            this.setEdgeType(captionStyle.edgeType);
            this.setTypeface(captionStyle.getTypeface());
            this.setTextSize(f);
        }

        public void update() {
            SpannableStringBuilder spannableStringBuilder = this.mBuilder;
            TextTrackCueSpan[] textTrackCueSpanArray = this.mSpans;
            spannableStringBuilder.clear();
            spannableStringBuilder.clearSpans();
            int n = textTrackCueSpanArray.length;
            for (int i = 0; i < n; ++i) {
                if (!textTrackCueSpanArray[i].mEnabled) continue;
                spannableStringBuilder.append(textTrackCueSpanArray[i].mText);
            }
            this.setText(spannableStringBuilder);
        }
    }
}

