/*
 * Decompiled with CFR 0.152.
 */
package android.media.browse;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ParceledListSlice;
import android.media.MediaDescription;
import android.media.session.MediaSession;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.service.media.IMediaBrowserService;
import android.service.media.IMediaBrowserServiceCallbacks;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;

public final class MediaBrowser {
    private static final int CONNECT_STATE_CONNECTED = 2;
    private static final int CONNECT_STATE_CONNECTING = 1;
    private static final int CONNECT_STATE_DISCONNECTED = 0;
    private static final int CONNECT_STATE_SUSPENDED = 3;
    private static final boolean DBG = false;
    private static final String TAG = "MediaBrowser";
    private final ConnectionCallback mCallback;
    private final Context mContext;
    private Bundle mExtras;
    private final Handler mHandler = new Handler();
    private MediaSession.Token mMediaSessionToken;
    private final Bundle mRootHints;
    private String mRootId;
    private IMediaBrowserService mServiceBinder;
    private IMediaBrowserServiceCallbacks mServiceCallbacks;
    private final ComponentName mServiceComponent;
    private MediaServiceConnection mServiceConnection;
    private int mState = 0;
    private final ArrayMap<String, Subscription> mSubscriptions = new ArrayMap();

    public MediaBrowser(Context context, ComponentName componentName, ConnectionCallback connectionCallback, Bundle bundle) {
        if (context == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        if (componentName == null) {
            throw new IllegalArgumentException("service component must not be null");
        }
        if (connectionCallback == null) {
            throw new IllegalArgumentException("connection callback must not be null");
        }
        this.mContext = context;
        this.mServiceComponent = componentName;
        this.mCallback = connectionCallback;
        this.mRootHints = bundle;
    }

    static /* synthetic */ IMediaBrowserServiceCallbacks access$1102(MediaBrowser mediaBrowser, IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks) {
        mediaBrowser.mServiceCallbacks = iMediaBrowserServiceCallbacks;
        return iMediaBrowserServiceCallbacks;
    }

    static /* synthetic */ IMediaBrowserService access$1202(MediaBrowser mediaBrowser, IMediaBrowserService iMediaBrowserService) {
        mediaBrowser.mServiceBinder = iMediaBrowserService;
        return iMediaBrowserService;
    }

    static /* synthetic */ int access$502(MediaBrowser mediaBrowser, int n) {
        mediaBrowser.mState = n;
        return n;
    }

    static /* synthetic */ String access$702(MediaBrowser mediaBrowser, String string2) {
        mediaBrowser.mRootId = string2;
        return string2;
    }

    static /* synthetic */ MediaSession.Token access$802(MediaBrowser mediaBrowser, MediaSession.Token token) {
        mediaBrowser.mMediaSessionToken = token;
        return token;
    }

    static /* synthetic */ Bundle access$902(MediaBrowser mediaBrowser, Bundle bundle) {
        mediaBrowser.mExtras = bundle;
        return bundle;
    }

    private void forceCloseConnection() {
        if (this.mServiceConnection != null) {
            this.mContext.unbindService(this.mServiceConnection);
        }
        this.mState = 0;
        this.mServiceConnection = null;
        this.mServiceBinder = null;
        this.mServiceCallbacks = null;
        this.mRootId = null;
        this.mMediaSessionToken = null;
    }

    private ServiceCallbacks getNewServiceCallbacks() {
        return new ServiceCallbacks(this);
    }

    private static String getStateLabel(int n) {
        switch (n) {
            default: {
                return "UNKNOWN/" + n;
            }
            case 0: {
                return "CONNECT_STATE_DISCONNECTED";
            }
            case 1: {
                return "CONNECT_STATE_CONNECTING";
            }
            case 2: {
                return "CONNECT_STATE_CONNECTED";
            }
            case 3: 
        }
        return "CONNECT_STATE_SUSPENDED";
    }

    private boolean isCurrent(IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks, String string2) {
        if (this.mServiceCallbacks != iMediaBrowserServiceCallbacks) {
            if (this.mState != 0) {
                Log.i(TAG, string2 + " for " + this.mServiceComponent + " with mServiceConnection=" + this.mServiceCallbacks + " this=" + this);
            }
            return false;
        }
        return true;
    }

    private final void onConnectionFailed(final IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                Log.e(MediaBrowser.TAG, "onConnectFailed for " + MediaBrowser.this.mServiceComponent);
                if (!MediaBrowser.this.isCurrent(iMediaBrowserServiceCallbacks, "onConnectFailed")) {
                    return;
                }
                if (MediaBrowser.this.mState != 1) {
                    Log.w(MediaBrowser.TAG, "onConnect from service while mState=" + MediaBrowser.getStateLabel(MediaBrowser.this.mState) + "... ignoring");
                    return;
                }
                MediaBrowser.this.forceCloseConnection();
                MediaBrowser.this.mCallback.onConnectionFailed();
            }
        });
    }

    private final void onLoadChildren(final IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks, final String string2, final ParceledListSlice parceledListSlice) {
        this.mHandler.post(new Runnable(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void run() {
                Subscription subscription;
                List<MediaItem> list;
                block5: {
                    block4: {
                        if (!MediaBrowser.this.isCurrent(iMediaBrowserServiceCallbacks, "onLoadChildren")) break block4;
                        list = parceledListSlice.getList();
                        if (list == null) {
                            list = Collections.emptyList();
                        }
                        if ((subscription = (Subscription)MediaBrowser.this.mSubscriptions.get(string2)) != null) break block5;
                    }
                    return;
                }
                subscription.callback.onChildrenLoaded(string2, list);
            }
        });
    }

    private final void onServiceConnected(final IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks, final String string2, final MediaSession.Token token, final Bundle bundle) {
        this.mHandler.post(new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                if (MediaBrowser.this.isCurrent(iMediaBrowserServiceCallbacks, "onConnect")) {
                    if (MediaBrowser.this.mState != 1) {
                        Log.w(MediaBrowser.TAG, "onConnect from service while mState=" + MediaBrowser.getStateLabel(MediaBrowser.this.mState) + "... ignoring");
                        return;
                    }
                    MediaBrowser.access$702(MediaBrowser.this, string2);
                    MediaBrowser.access$802(MediaBrowser.this, token);
                    MediaBrowser.access$902(MediaBrowser.this, bundle);
                    MediaBrowser.access$502(MediaBrowser.this, 2);
                    MediaBrowser.this.mCallback.onConnected();
                    for (String string22 : MediaBrowser.this.mSubscriptions.keySet()) {
                        try {
                            MediaBrowser.this.mServiceBinder.addSubscription(string22, MediaBrowser.this.mServiceCallbacks);
                        }
                        catch (RemoteException remoteException) {
                            Log.d(MediaBrowser.TAG, "addSubscription failed with RemoteException parentId=" + string22);
                        }
                    }
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect() {
        boolean bl;
        MediaServiceConnection mediaServiceConnection;
        if (this.mState != 0) {
            throw new IllegalStateException("connect() called while not disconnected (state=" + MediaBrowser.getStateLabel(this.mState) + ")");
        }
        if (this.mServiceBinder != null) {
            throw new RuntimeException("mServiceBinder should be null. Instead it is " + this.mServiceBinder);
        }
        if (this.mServiceCallbacks != null) {
            throw new RuntimeException("mServiceCallbacks should be null. Instead it is " + this.mServiceCallbacks);
        }
        this.mState = 1;
        Intent intent = new Intent("android.media.browse.MediaBrowserService");
        intent.setComponent(this.mServiceComponent);
        this.mServiceConnection = mediaServiceConnection = new MediaServiceConnection();
        try {
            boolean bl2;
            bl = bl2 = this.mContext.bindService(intent, this.mServiceConnection, 1);
        }
        catch (Exception exception) {
            Log.e(TAG, "Failed binding to service " + this.mServiceComponent);
            bl = false;
        }
        if (!bl) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (mediaServiceConnection == MediaBrowser.this.mServiceConnection) {
                        MediaBrowser.this.forceCloseConnection();
                        MediaBrowser.this.mCallback.onConnectionFailed();
                    }
                }
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void disconnect() {
        if (this.mServiceCallbacks != null) {
            try {
                this.mServiceBinder.disconnect(this.mServiceCallbacks);
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "RemoteException during connect for " + this.mServiceComponent);
            }
        }
        this.forceCloseConnection();
    }

    void dump() {
        Log.d(TAG, "MediaBrowser...");
        Log.d(TAG, "  mServiceComponent=" + this.mServiceComponent);
        Log.d(TAG, "  mCallback=" + this.mCallback);
        Log.d(TAG, "  mRootHints=" + this.mRootHints);
        Log.d(TAG, "  mState=" + MediaBrowser.getStateLabel(this.mState));
        Log.d(TAG, "  mServiceConnection=" + this.mServiceConnection);
        Log.d(TAG, "  mServiceBinder=" + this.mServiceBinder);
        Log.d(TAG, "  mServiceCallbacks=" + this.mServiceCallbacks);
        Log.d(TAG, "  mRootId=" + this.mRootId);
        Log.d(TAG, "  mMediaSessionToken=" + this.mMediaSessionToken);
    }

    public Bundle getExtras() {
        if (!this.isConnected()) {
            throw new IllegalStateException("getExtras() called while not connected (state=" + MediaBrowser.getStateLabel(this.mState) + ")");
        }
        return this.mExtras;
    }

    public String getRoot() {
        if (!this.isConnected()) {
            throw new IllegalStateException("getSessionToken() called while not connected (state=" + MediaBrowser.getStateLabel(this.mState) + ")");
        }
        return this.mRootId;
    }

    public ComponentName getServiceComponent() {
        if (!this.isConnected()) {
            throw new IllegalStateException("getServiceComponent() called while not connected (state=" + this.mState + ")");
        }
        return this.mServiceComponent;
    }

    public MediaSession.Token getSessionToken() {
        if (!this.isConnected()) {
            throw new IllegalStateException("getSessionToken() called while not connected (state=" + this.mState + ")");
        }
        return this.mMediaSessionToken;
    }

    public boolean isConnected() {
        return this.mState == 2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void subscribe(String string2, SubscriptionCallback subscriptionCallback) {
        if (string2 == null) {
            throw new IllegalArgumentException("parentId is null");
        }
        if (subscriptionCallback == null) {
            throw new IllegalArgumentException("callback is null");
        }
        Subscription subscription = this.mSubscriptions.get(string2);
        boolean bl = subscription == null;
        if (bl) {
            subscription = new Subscription(string2);
            this.mSubscriptions.put(string2, subscription);
        }
        subscription.callback = subscriptionCallback;
        if (this.mState != 2) return;
        if (!bl) return;
        try {
            this.mServiceBinder.addSubscription(string2, this.mServiceCallbacks);
            return;
        }
        catch (RemoteException remoteException) {
            Log.d(TAG, "addSubscription failed with RemoteException parentId=" + string2);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unsubscribe(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("parentId is null");
        }
        Subscription subscription = this.mSubscriptions.remove(string2);
        if (this.mState != 2 || subscription == null) return;
        try {
            this.mServiceBinder.removeSubscription(string2, this.mServiceCallbacks);
            return;
        }
        catch (RemoteException remoteException) {
            Log.d(TAG, "removeSubscription failed with RemoteException parentId=" + string2);
            return;
        }
    }

    public static class ConnectionCallback {
        public void onConnected() {
        }

        public void onConnectionFailed() {
        }

        public void onConnectionSuspended() {
        }
    }

    public static class MediaItem
    implements Parcelable {
        public static final Parcelable.Creator<MediaItem> CREATOR = new Parcelable.Creator<MediaItem>(){

            @Override
            public MediaItem createFromParcel(Parcel parcel) {
                return new MediaItem(parcel);
            }

            public MediaItem[] newArray(int n) {
                return new MediaItem[n];
            }
        };
        public static final int FLAG_BROWSABLE = 1;
        public static final int FLAG_PLAYABLE = 2;
        private final MediaDescription mDescription;
        private final int mFlags;

        public MediaItem(MediaDescription mediaDescription, int n) {
            if (mediaDescription == null) {
                throw new IllegalArgumentException("description cannot be null");
            }
            if (TextUtils.isEmpty(mediaDescription.getMediaId())) {
                throw new IllegalArgumentException("description must have a non-empty media id");
            }
            this.mFlags = n;
            this.mDescription = mediaDescription;
        }

        private MediaItem(Parcel parcel) {
            this.mFlags = parcel.readInt();
            this.mDescription = MediaDescription.CREATOR.createFromParcel(parcel);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public MediaDescription getDescription() {
            return this.mDescription;
        }

        public int getFlags() {
            return this.mFlags;
        }

        public String getMediaId() {
            return this.mDescription.getMediaId();
        }

        public boolean isBrowsable() {
            return (1 & this.mFlags) != 0;
        }

        public boolean isPlayable() {
            return (2 & this.mFlags) != 0;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("MediaItem{");
            stringBuilder.append("mFlags=").append(this.mFlags);
            stringBuilder.append(", mDescription=").append(this.mDescription);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.mFlags);
            this.mDescription.writeToParcel(parcel, n);
        }
    }

    private class MediaServiceConnection
    implements ServiceConnection {
        private MediaServiceConnection() {
        }

        private boolean isCurrent(String string2) {
            if (MediaBrowser.this.mServiceConnection != this) {
                if (MediaBrowser.this.mState != 0) {
                    Log.i(MediaBrowser.TAG, string2 + " for " + MediaBrowser.this.mServiceComponent + " with mServiceConnection=" + MediaBrowser.this.mServiceConnection + " this=" + this);
                }
                return false;
            }
            return true;
        }

        @Override
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            if (!this.isCurrent("onServiceConnected")) {
                return;
            }
            MediaBrowser.access$1202(MediaBrowser.this, IMediaBrowserService.Stub.asInterface(iBinder));
            MediaBrowser.access$1102(MediaBrowser.this, MediaBrowser.this.getNewServiceCallbacks());
            MediaBrowser.access$502(MediaBrowser.this, 1);
            try {
                MediaBrowser.this.mServiceBinder.connect(MediaBrowser.this.mContext.getPackageName(), MediaBrowser.this.mRootHints, MediaBrowser.this.mServiceCallbacks);
                return;
            }
            catch (RemoteException remoteException) {
                Log.w(MediaBrowser.TAG, "RemoteException during connect for " + MediaBrowser.this.mServiceComponent);
                return;
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            if (!this.isCurrent("onServiceDisconnected")) {
                return;
            }
            MediaBrowser.access$1202(MediaBrowser.this, null);
            MediaBrowser.access$1102(MediaBrowser.this, null);
            MediaBrowser.access$502(MediaBrowser.this, 3);
            MediaBrowser.this.mCallback.onConnectionSuspended();
        }
    }

    private static class ServiceCallbacks
    extends IMediaBrowserServiceCallbacks.Stub {
        private WeakReference<MediaBrowser> mMediaBrowser;

        public ServiceCallbacks(MediaBrowser mediaBrowser) {
            this.mMediaBrowser = new WeakReference<MediaBrowser>(mediaBrowser);
        }

        @Override
        public void onConnect(String string2, MediaSession.Token token, Bundle bundle) {
            MediaBrowser mediaBrowser = (MediaBrowser)this.mMediaBrowser.get();
            if (mediaBrowser != null) {
                mediaBrowser.onServiceConnected(this, string2, token, bundle);
            }
        }

        @Override
        public void onConnectFailed() {
            MediaBrowser mediaBrowser = (MediaBrowser)this.mMediaBrowser.get();
            if (mediaBrowser != null) {
                mediaBrowser.onConnectionFailed(this);
            }
        }

        @Override
        public void onLoadChildren(String string2, ParceledListSlice parceledListSlice) {
            MediaBrowser mediaBrowser = (MediaBrowser)this.mMediaBrowser.get();
            if (mediaBrowser != null) {
                mediaBrowser.onLoadChildren(this, string2, parceledListSlice);
            }
        }
    }

    private static class Subscription {
        SubscriptionCallback callback;
        final String id;

        Subscription(String string2) {
            this.id = string2;
        }
    }

    public static abstract class SubscriptionCallback {
        public void onChildrenLoaded(String string2, List<MediaItem> list) {
        }

        public void onError(String string2) {
        }
    }
}

