/*
 * Decompiled with CFR 0.152.
 */
package android.media.session;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.media.MediaMetadata;
import android.media.Rating;
import android.media.session.MediaSession;
import android.media.session.MediaSessionManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.ArrayMap;
import android.util.Log;
import android.view.KeyEvent;

public class MediaSessionLegacyHelper {
    private static final boolean DEBUG = false;
    private static final String TAG = "MediaSessionHelper";
    private static MediaSessionLegacyHelper sInstance;
    private static final Object sLock;
    private Context mContext;
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private MediaSessionManager mSessionManager;
    private ArrayMap<PendingIntent, SessionHolder> mSessions = new ArrayMap();

    static {
        DEBUG = Log.isLoggable(TAG, 3);
        sLock = new Object();
    }

    private MediaSessionLegacyHelper(Context context) {
        this.mContext = context;
        this.mSessionManager = (MediaSessionManager)context.getSystemService("media_session");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MediaSessionLegacyHelper getHelper(Context context) {
        if (DEBUG) {
            Log.d(TAG, "Attempting to get helper with context " + context);
        }
        Object object = sLock;
        synchronized (object) {
            if (sInstance == null) {
                sInstance = new MediaSessionLegacyHelper(context);
            }
            return sInstance;
        }
    }

    private SessionHolder getHolder(PendingIntent pendingIntent, boolean bl) {
        SessionHolder sessionHolder = this.mSessions.get(pendingIntent);
        if (sessionHolder == null && bl) {
            MediaSession mediaSession = new MediaSession(this.mContext, "MediaSessionHelper-" + pendingIntent.getCreatorPackage());
            mediaSession.setActive(true);
            sessionHolder = new SessionHolder(mediaSession, pendingIntent);
            this.mSessions.put(pendingIntent, sessionHolder);
        }
        return sessionHolder;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Bundle getOldMetadata(MediaMetadata mediaMetadata, int n, int n2) {
        boolean bl = n != -1 && n2 != -1;
        Bundle bundle = new Bundle();
        if (mediaMetadata.containsKey("android.media.metadata.ALBUM")) {
            bundle.putString(String.valueOf(1), mediaMetadata.getString("android.media.metadata.ALBUM"));
        }
        if (bl && mediaMetadata.containsKey("android.media.metadata.ART")) {
            Bitmap bitmap = mediaMetadata.getBitmap("android.media.metadata.ART");
            bundle.putParcelable(String.valueOf(100), MediaSessionLegacyHelper.scaleBitmapIfTooBig(bitmap, n, n2));
        } else if (bl && mediaMetadata.containsKey("android.media.metadata.ALBUM_ART")) {
            Bitmap bitmap = mediaMetadata.getBitmap("android.media.metadata.ALBUM_ART");
            bundle.putParcelable(String.valueOf(100), MediaSessionLegacyHelper.scaleBitmapIfTooBig(bitmap, n, n2));
        }
        if (mediaMetadata.containsKey("android.media.metadata.ALBUM_ARTIST")) {
            bundle.putString(String.valueOf(13), mediaMetadata.getString("android.media.metadata.ALBUM_ARTIST"));
        }
        if (mediaMetadata.containsKey("android.media.metadata.ARTIST")) {
            bundle.putString(String.valueOf(2), mediaMetadata.getString("android.media.metadata.ARTIST"));
        }
        if (mediaMetadata.containsKey("android.media.metadata.AUTHOR")) {
            bundle.putString(String.valueOf(3), mediaMetadata.getString("android.media.metadata.AUTHOR"));
        }
        if (mediaMetadata.containsKey("android.media.metadata.COMPILATION")) {
            bundle.putString(String.valueOf(15), mediaMetadata.getString("android.media.metadata.COMPILATION"));
        }
        if (mediaMetadata.containsKey("android.media.metadata.COMPOSER")) {
            bundle.putString(String.valueOf(4), mediaMetadata.getString("android.media.metadata.COMPOSER"));
        }
        if (mediaMetadata.containsKey("android.media.metadata.DATE")) {
            bundle.putString(String.valueOf(5), mediaMetadata.getString("android.media.metadata.DATE"));
        }
        if (mediaMetadata.containsKey("android.media.metadata.DISC_NUMBER")) {
            bundle.putLong(String.valueOf(14), mediaMetadata.getLong("android.media.metadata.DISC_NUMBER"));
        }
        if (mediaMetadata.containsKey("android.media.metadata.DURATION")) {
            bundle.putLong(String.valueOf(9), mediaMetadata.getLong("android.media.metadata.DURATION"));
        }
        if (mediaMetadata.containsKey("android.media.metadata.GENRE")) {
            bundle.putString(String.valueOf(6), mediaMetadata.getString("android.media.metadata.GENRE"));
        }
        if (mediaMetadata.containsKey("android.media.metadata.NUM_TRACKS")) {
            bundle.putLong(String.valueOf(10), mediaMetadata.getLong("android.media.metadata.NUM_TRACKS"));
        }
        if (mediaMetadata.containsKey("android.media.metadata.RATING")) {
            bundle.putParcelable(String.valueOf(101), mediaMetadata.getRating("android.media.metadata.RATING"));
        }
        if (mediaMetadata.containsKey("android.media.metadata.USER_RATING")) {
            bundle.putParcelable(String.valueOf(0x10000001), mediaMetadata.getRating("android.media.metadata.USER_RATING"));
        }
        if (mediaMetadata.containsKey("android.media.metadata.TITLE")) {
            bundle.putString(String.valueOf(7), mediaMetadata.getString("android.media.metadata.TITLE"));
        }
        if (mediaMetadata.containsKey("android.media.metadata.TRACK_NUMBER")) {
            bundle.putLong(String.valueOf(0), mediaMetadata.getLong("android.media.metadata.TRACK_NUMBER"));
        }
        if (mediaMetadata.containsKey("android.media.metadata.WRITER")) {
            bundle.putString(String.valueOf(11), mediaMetadata.getString("android.media.metadata.WRITER"));
        }
        if (mediaMetadata.containsKey("android.media.metadata.YEAR")) {
            bundle.putString(String.valueOf(8), mediaMetadata.getString("android.media.metadata.YEAR"));
        }
        return bundle;
    }

    private static Bitmap scaleBitmapIfTooBig(Bitmap bitmap, int n, int n2) {
        if (bitmap != null) {
            int n3 = bitmap.getWidth();
            int n4 = bitmap.getHeight();
            if (n3 > n || n4 > n2) {
                float f = Math.min((float)n / (float)n3, (float)n2 / (float)n4);
                int n5 = Math.round(f * (float)n3);
                int n6 = Math.round(f * (float)n4);
                Bitmap.Config config = bitmap.getConfig();
                if (config == null) {
                    config = Bitmap.Config.ARGB_8888;
                }
                Bitmap bitmap2 = Bitmap.createBitmap(n5, n6, config);
                Canvas canvas = new Canvas(bitmap2);
                Paint paint = new Paint();
                paint.setAntiAlias(true);
                paint.setFilterBitmap(true);
                RectF rectF = new RectF(0.0f, 0.0f, bitmap2.getWidth(), bitmap2.getHeight());
                canvas.drawBitmap(bitmap, null, rectF, paint);
                bitmap = bitmap2;
            }
        }
        return bitmap;
    }

    private static void sendKeyEvent(PendingIntent pendingIntent, Context context, Intent intent) {
        try {
            pendingIntent.send(context, 0, intent);
            return;
        }
        catch (PendingIntent.CanceledException canceledException) {
            Log.e(TAG, "Error sending media key down event:", canceledException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addMediaButtonListener(PendingIntent pendingIntent, ComponentName componentName, Context context) {
        if (pendingIntent == null) {
            Log.w(TAG, "Pending intent was null, can't addMediaButtonListener.");
            return;
        } else {
            SessionHolder sessionHolder = this.getHolder(pendingIntent, true);
            if (sessionHolder == null) return;
            if (sessionHolder.mMediaButtonListener != null && DEBUG) {
                Log.d(TAG, "addMediaButtonListener already added " + pendingIntent);
            }
            sessionHolder.mMediaButtonListener = new MediaButtonListener(pendingIntent, context);
            sessionHolder.mFlags = 1 | sessionHolder.mFlags;
            sessionHolder.mSession.setFlags(sessionHolder.mFlags);
            sessionHolder.mSession.setMediaButtonReceiver(pendingIntent);
            sessionHolder.update();
            if (!DEBUG) return;
            Log.d(TAG, "addMediaButtonListener added " + pendingIntent);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addRccListener(PendingIntent pendingIntent, MediaSession.Callback callback) {
        if (pendingIntent == null) {
            Log.w(TAG, "Pending intent was null, can't add rcc listener.");
            return;
        } else {
            SessionHolder sessionHolder = this.getHolder(pendingIntent, true);
            if (sessionHolder == null) return;
            if (sessionHolder.mRccListener != null && sessionHolder.mRccListener == callback) {
                if (!DEBUG) return;
                Log.d(TAG, "addRccListener listener already added.");
                return;
            } else {
                sessionHolder.mRccListener = callback;
                sessionHolder.mFlags = 2 | sessionHolder.mFlags;
                sessionHolder.mSession.setFlags(sessionHolder.mFlags);
                sessionHolder.update();
                if (!DEBUG) return;
                Log.d(TAG, "Added rcc listener for " + pendingIntent + ".");
                return;
            }
        }
    }

    public MediaSession getSession(PendingIntent pendingIntent) {
        SessionHolder sessionHolder = this.mSessions.get(pendingIntent);
        if (sessionHolder == null) {
            return null;
        }
        return sessionHolder.mSession;
    }

    public boolean isGlobalPriorityActive() {
        return this.mSessionManager.isGlobalPriorityActive();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void removeMediaButtonListener(PendingIntent pendingIntent) {
        block3: {
            block2: {
                SessionHolder sessionHolder;
                if (pendingIntent == null || (sessionHolder = this.getHolder(pendingIntent, false)) == null || sessionHolder.mMediaButtonListener == null) break block2;
                sessionHolder.mFlags = 0xFFFFFFFE & sessionHolder.mFlags;
                sessionHolder.mSession.setFlags(sessionHolder.mFlags);
                sessionHolder.mMediaButtonListener = null;
                sessionHolder.update();
                if (DEBUG) break block3;
            }
            return;
        }
        Log.d(TAG, "removeMediaButtonListener removed " + pendingIntent);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void removeRccListener(PendingIntent pendingIntent) {
        block3: {
            block2: {
                SessionHolder sessionHolder;
                if (pendingIntent == null || (sessionHolder = this.getHolder(pendingIntent, false)) == null || sessionHolder.mRccListener == null) break block2;
                sessionHolder.mRccListener = null;
                sessionHolder.mFlags = 0xFFFFFFFD & sessionHolder.mFlags;
                sessionHolder.mSession.setFlags(sessionHolder.mFlags);
                sessionHolder.update();
                if (DEBUG) break block3;
            }
            return;
        }
        Log.d(TAG, "Removed rcc listener for " + pendingIntent + ".");
    }

    public void sendAdjustVolumeBy(int n, int n2, int n3) {
        this.mSessionManager.dispatchAdjustVolume(n, n2, n3);
        if (DEBUG) {
            Log.d(TAG, "dispatched volume adjustment");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void sendMediaButtonEvent(KeyEvent keyEvent, boolean bl) {
        if (keyEvent == null) {
            Log.w(TAG, "Tried to send a null key event. Ignoring.");
            return;
        } else {
            this.mSessionManager.dispatchMediaKeyEvent(keyEvent, bl);
            if (!DEBUG) return;
            Log.d(TAG, "dispatched media key " + keyEvent);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void sendVolumeKeyEvent(KeyEvent keyEvent, boolean bl) {
        int n;
        int n2;
        if (keyEvent == null) {
            Log.w(TAG, "Tried to send a null key event. Ignoring.");
            return;
        } else {
            boolean bl2 = keyEvent.getAction() == 0;
            boolean bl3 = keyEvent.getAction() == 1;
            int n3 = keyEvent.getKeyCode();
            n2 = 0;
            switch (n3) {
                case 24: {
                    n2 = 1;
                    break;
                }
                case 25: {
                    n2 = -1;
                }
            }
            if (!bl2 && !bl3 || n2 == 0) return;
            if (bl3) {
                n2 = 0;
            }
            n = bl ? 512 : (bl3 ? 20 : 17);
        }
        this.mSessionManager.dispatchAdjustVolume(Integer.MIN_VALUE, n2, n);
    }

    private static final class MediaButtonListener
    extends MediaSession.Callback {
        private final Context mContext;
        private final PendingIntent mPendingIntent;

        public MediaButtonListener(PendingIntent pendingIntent, Context context) {
            this.mPendingIntent = pendingIntent;
            this.mContext = context;
        }

        private void sendKeyEvent(int n) {
            KeyEvent keyEvent = new KeyEvent(0, n);
            Intent intent = new Intent("android.intent.action.MEDIA_BUTTON");
            intent.addFlags(0x10000000);
            intent.putExtra("android.intent.extra.KEY_EVENT", keyEvent);
            MediaSessionLegacyHelper.sendKeyEvent(this.mPendingIntent, this.mContext, intent);
            intent.putExtra("android.intent.extra.KEY_EVENT", new KeyEvent(1, n));
            MediaSessionLegacyHelper.sendKeyEvent(this.mPendingIntent, this.mContext, intent);
            if (DEBUG) {
                Log.d(MediaSessionLegacyHelper.TAG, "Sent " + n + " to pending intent " + this.mPendingIntent);
            }
        }

        @Override
        public void onFastForward() {
            this.sendKeyEvent(90);
        }

        @Override
        public boolean onMediaButtonEvent(Intent intent) {
            MediaSessionLegacyHelper.sendKeyEvent(this.mPendingIntent, this.mContext, intent);
            return true;
        }

        @Override
        public void onPause() {
            this.sendKeyEvent(127);
        }

        @Override
        public void onPlay() {
            this.sendKeyEvent(126);
        }

        @Override
        public void onRewind() {
            this.sendKeyEvent(89);
        }

        @Override
        public void onSkipToNext() {
            this.sendKeyEvent(87);
        }

        @Override
        public void onSkipToPrevious() {
            this.sendKeyEvent(88);
        }

        @Override
        public void onStop() {
            this.sendKeyEvent(86);
        }
    }

    private class SessionHolder {
        public SessionCallback mCb;
        public int mFlags;
        public MediaButtonListener mMediaButtonListener;
        public final PendingIntent mPi;
        public MediaSession.Callback mRccListener;
        public final MediaSession mSession;

        public SessionHolder(MediaSession mediaSession, PendingIntent pendingIntent) {
            this.mSession = mediaSession;
            this.mPi = pendingIntent;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void update() {
            if (this.mMediaButtonListener == null && this.mRccListener == null) {
                this.mSession.setCallback(null);
                this.mSession.release();
                this.mCb = null;
                MediaSessionLegacyHelper.this.mSessions.remove(this.mPi);
                return;
            } else {
                if (this.mCb != null) return;
                this.mCb = new SessionCallback();
                Handler handler = new Handler(Looper.getMainLooper());
                this.mSession.setCallback(this.mCb, handler);
                return;
            }
        }

        private class SessionCallback
        extends MediaSession.Callback {
            private SessionCallback() {
            }

            @Override
            public void onFastForward() {
                if (SessionHolder.this.mMediaButtonListener != null) {
                    SessionHolder.this.mMediaButtonListener.onFastForward();
                }
            }

            @Override
            public boolean onMediaButtonEvent(Intent intent) {
                if (SessionHolder.this.mMediaButtonListener != null) {
                    SessionHolder.this.mMediaButtonListener.onMediaButtonEvent(intent);
                }
                return true;
            }

            @Override
            public void onPause() {
                if (SessionHolder.this.mMediaButtonListener != null) {
                    SessionHolder.this.mMediaButtonListener.onPause();
                }
            }

            @Override
            public void onPlay() {
                if (SessionHolder.this.mMediaButtonListener != null) {
                    SessionHolder.this.mMediaButtonListener.onPlay();
                }
            }

            @Override
            public void onRewind() {
                if (SessionHolder.this.mMediaButtonListener != null) {
                    SessionHolder.this.mMediaButtonListener.onRewind();
                }
            }

            @Override
            public void onSeekTo(long l) {
                if (SessionHolder.this.mRccListener != null) {
                    SessionHolder.this.mRccListener.onSeekTo(l);
                }
            }

            @Override
            public void onSetRating(Rating rating) {
                if (SessionHolder.this.mRccListener != null) {
                    SessionHolder.this.mRccListener.onSetRating(rating);
                }
            }

            @Override
            public void onSkipToNext() {
                if (SessionHolder.this.mMediaButtonListener != null) {
                    SessionHolder.this.mMediaButtonListener.onSkipToNext();
                }
            }

            @Override
            public void onSkipToPrevious() {
                if (SessionHolder.this.mMediaButtonListener != null) {
                    SessionHolder.this.mMediaButtonListener.onSkipToPrevious();
                }
            }

            @Override
            public void onStop() {
                if (SessionHolder.this.mMediaButtonListener != null) {
                    SessionHolder.this.mMediaButtonListener.onStop();
                }
            }
        }
    }
}

