/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;

public final class TvTrackInfo
implements Parcelable {
    public static final Parcelable.Creator<TvTrackInfo> CREATOR = new Parcelable.Creator<TvTrackInfo>(){

        @Override
        public TvTrackInfo createFromParcel(Parcel parcel) {
            return new TvTrackInfo(parcel);
        }

        public TvTrackInfo[] newArray(int n) {
            return new TvTrackInfo[n];
        }
    };
    public static final int TYPE_AUDIO = 0;
    public static final int TYPE_SUBTITLE = 2;
    public static final int TYPE_VIDEO = 1;
    private final int mAudioChannelCount;
    private final int mAudioSampleRate;
    private final Bundle mExtra;
    private final String mId;
    private final String mLanguage;
    private final int mType;
    private final float mVideoFrameRate;
    private final int mVideoHeight;
    private final int mVideoWidth;

    private TvTrackInfo(int n, String string2, String string3, int n2, int n3, int n4, int n5, float f, Bundle bundle) {
        this.mType = n;
        this.mId = string2;
        this.mLanguage = string3;
        this.mAudioChannelCount = n2;
        this.mAudioSampleRate = n3;
        this.mVideoWidth = n4;
        this.mVideoHeight = n5;
        this.mVideoFrameRate = f;
        this.mExtra = bundle;
    }

    private TvTrackInfo(Parcel parcel) {
        this.mType = parcel.readInt();
        this.mId = parcel.readString();
        this.mLanguage = parcel.readString();
        this.mAudioChannelCount = parcel.readInt();
        this.mAudioSampleRate = parcel.readInt();
        this.mVideoWidth = parcel.readInt();
        this.mVideoHeight = parcel.readInt();
        this.mVideoFrameRate = parcel.readFloat();
        this.mExtra = parcel.readBundle();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public final int getAudioChannelCount() {
        if (this.mType != 0) {
            throw new IllegalStateException("Not an audio track");
        }
        return this.mAudioChannelCount;
    }

    public final int getAudioSampleRate() {
        if (this.mType != 0) {
            throw new IllegalStateException("Not an audio track");
        }
        return this.mAudioSampleRate;
    }

    public final Bundle getExtra() {
        return this.mExtra;
    }

    public final String getId() {
        return this.mId;
    }

    public final String getLanguage() {
        return this.mLanguage;
    }

    public final int getType() {
        return this.mType;
    }

    public final float getVideoFrameRate() {
        if (this.mType != 1) {
            throw new IllegalStateException("Not a video track");
        }
        return this.mVideoFrameRate;
    }

    public final int getVideoHeight() {
        if (this.mType != 1) {
            throw new IllegalStateException("Not a video track");
        }
        return this.mVideoHeight;
    }

    public final int getVideoWidth() {
        if (this.mType != 1) {
            throw new IllegalStateException("Not a video track");
        }
        return this.mVideoWidth;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mType);
        parcel.writeString(this.mId);
        parcel.writeString(this.mLanguage);
        parcel.writeInt(this.mAudioChannelCount);
        parcel.writeInt(this.mAudioSampleRate);
        parcel.writeInt(this.mVideoWidth);
        parcel.writeInt(this.mVideoHeight);
        parcel.writeFloat(this.mVideoFrameRate);
        parcel.writeBundle(this.mExtra);
    }

    public static final class Builder {
        private int mAudioChannelCount;
        private int mAudioSampleRate;
        private Bundle mExtra;
        private final String mId;
        private String mLanguage;
        private final int mType;
        private float mVideoFrameRate;
        private int mVideoHeight;
        private int mVideoWidth;

        public Builder(int n, String string2) {
            if (n != 0 && n != 1 && n != 2) {
                throw new IllegalArgumentException("Unknown type: " + n);
            }
            if (string2 == null) {
                throw new IllegalArgumentException("id cannot be null");
            }
            this.mType = n;
            this.mId = string2;
        }

        public TvTrackInfo build() {
            return new TvTrackInfo(this.mType, this.mId, this.mLanguage, this.mAudioChannelCount, this.mAudioSampleRate, this.mVideoWidth, this.mVideoHeight, this.mVideoFrameRate, this.mExtra);
        }

        public final Builder setAudioChannelCount(int n) {
            if (this.mType != 0) {
                throw new IllegalStateException("Not an audio track");
            }
            this.mAudioChannelCount = n;
            return this;
        }

        public final Builder setAudioSampleRate(int n) {
            if (this.mType != 0) {
                throw new IllegalStateException("Not an audio track");
            }
            this.mAudioSampleRate = n;
            return this;
        }

        public final Builder setExtra(Bundle bundle) {
            this.mExtra = new Bundle(bundle);
            return this;
        }

        public final Builder setLanguage(String string2) {
            this.mLanguage = string2;
            return this;
        }

        public final Builder setVideoFrameRate(float f) {
            if (this.mType != 1) {
                throw new IllegalStateException("Not a video track");
            }
            this.mVideoFrameRate = f;
            return this;
        }

        public final Builder setVideoHeight(int n) {
            if (this.mType != 1) {
                throw new IllegalStateException("Not a video track");
            }
            this.mVideoHeight = n;
            return this;
        }

        public final Builder setVideoWidth(int n) {
            if (this.mType != 1) {
                throw new IllegalStateException("Not a video track");
            }
            this.mVideoWidth = n;
            return this;
        }
    }
}

