/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkMisc;
import android.net.UidRange;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.util.Log;
import com.android.internal.util.AsyncChannel;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class NetworkAgent
extends Handler {
    private static final int BASE = 528384;
    public static final int CMD_REPORT_NETWORK_STATUS = 528391;
    public static final int CMD_SUSPECT_BAD = 528384;
    private static final boolean DBG = true;
    public static final int EVENT_NETWORK_CAPABILITIES_CHANGED = 528386;
    public static final int EVENT_NETWORK_INFO_CHANGED = 528385;
    public static final int EVENT_NETWORK_PROPERTIES_CHANGED = 528387;
    public static final int EVENT_NETWORK_SCORE_CHANGED = 528388;
    public static final int EVENT_SET_EXPLICITLY_SELECTED = 528392;
    public static final int EVENT_UID_RANGES_ADDED = 528389;
    public static final int EVENT_UID_RANGES_REMOVED = 528390;
    public static final int INVALID_NETWORK = 2;
    public static final int VALID_NETWORK = 1;
    private static final boolean VDBG = false;
    public static final int WIFI_BASE_SCORE = 60;
    private final String LOG_TAG;
    private volatile AsyncChannel mAsyncChannel;
    private final Context mContext;
    private final ArrayList<Message> mPreConnectedQueue = new ArrayList();

    public NetworkAgent(Looper looper, Context context, String string2, NetworkInfo networkInfo, NetworkCapabilities networkCapabilities, LinkProperties linkProperties, int n) {
        this(looper, context, string2, networkInfo, networkCapabilities, linkProperties, n, null);
    }

    public NetworkAgent(Looper looper, Context context, String string2, NetworkInfo networkInfo, NetworkCapabilities networkCapabilities, LinkProperties linkProperties, int n, NetworkMisc networkMisc) {
        super(looper);
        this.LOG_TAG = string2;
        this.mContext = context;
        if (networkInfo == null || networkCapabilities == null || linkProperties == null) {
            throw new IllegalArgumentException();
        }
        ((ConnectivityManager)this.mContext.getSystemService("connectivity")).registerNetworkAgent(new Messenger(this), new NetworkInfo(networkInfo), new LinkProperties(linkProperties), new NetworkCapabilities(networkCapabilities), n, networkMisc);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void queueOrSendMessage(int n, Object object) {
        ArrayList<Message> arrayList = this.mPreConnectedQueue;
        synchronized (arrayList) {
            if (this.mAsyncChannel != null) {
                this.mAsyncChannel.sendMessage(n, object);
            } else {
                Message message = Message.obtain();
                message.what = n;
                message.obj = object;
                this.mPreConnectedQueue.add(message);
            }
            return;
        }
    }

    public void addUidRanges(UidRange[] uidRangeArray) {
        this.queueOrSendMessage(528389, uidRangeArray);
    }

    public void explicitlySelected() {
        this.queueOrSendMessage(528392, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleMessage(Message message) {
        switch (message.what) {
            case 69633: {
                if (this.mAsyncChannel != null) {
                    this.log("Received new connection while already connected!");
                    return;
                }
                AsyncChannel asyncChannel = new AsyncChannel();
                asyncChannel.connected(null, this, message.replyTo);
                asyncChannel.replyToMessage(message, 69634, 0);
                ArrayList<Message> arrayList = this.mPreConnectedQueue;
                synchronized (arrayList) {
                    this.mAsyncChannel = asyncChannel;
                    Iterator<Message> iterator = this.mPreConnectedQueue.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            this.mPreConnectedQueue.clear();
                            return;
                        }
                        asyncChannel.sendMessage(iterator.next());
                    }
                }
            }
            case 69635: {
                if (this.mAsyncChannel != null) {
                    this.mAsyncChannel.disconnect();
                    return;
                }
            }
            default: {
                return;
            }
            case 69636: {
                this.log("NetworkAgent channel lost");
                this.unwanted();
                ArrayList<Message> arrayList = this.mPreConnectedQueue;
                synchronized (arrayList) {
                    this.mAsyncChannel = null;
                    return;
                }
            }
            case 528384: {
                this.log("Unhandled Message " + message);
                return;
            }
            case 528391: 
        }
        this.networkStatus(message.arg1);
    }

    protected void log(String string2) {
        Log.d(this.LOG_TAG, "NetworkAgent: " + string2);
    }

    protected void networkStatus(int n) {
    }

    public void removeUidRanges(UidRange[] uidRangeArray) {
        this.queueOrSendMessage(528390, uidRangeArray);
    }

    public void sendLinkProperties(LinkProperties linkProperties) {
        this.queueOrSendMessage(528387, new LinkProperties(linkProperties));
    }

    public void sendNetworkCapabilities(NetworkCapabilities networkCapabilities) {
        this.queueOrSendMessage(528386, new NetworkCapabilities(networkCapabilities));
    }

    public void sendNetworkInfo(NetworkInfo networkInfo) {
        this.queueOrSendMessage(528385, new NetworkInfo(networkInfo));
    }

    public void sendNetworkScore(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Score must be >= 0");
        }
        this.queueOrSendMessage(528388, new Integer(n));
    }

    protected abstract void unwanted();
}

