/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;

public final class NetworkCapabilities
implements Parcelable {
    public static final Parcelable.Creator<NetworkCapabilities> CREATOR = new Parcelable.Creator<NetworkCapabilities>(){

        @Override
        public NetworkCapabilities createFromParcel(Parcel parcel) {
            NetworkCapabilities networkCapabilities = new NetworkCapabilities();
            NetworkCapabilities.access$002(networkCapabilities, parcel.readLong());
            NetworkCapabilities.access$102(networkCapabilities, parcel.readLong());
            NetworkCapabilities.access$202(networkCapabilities, parcel.readInt());
            NetworkCapabilities.access$302(networkCapabilities, parcel.readInt());
            NetworkCapabilities.access$402(networkCapabilities, parcel.readString());
            return networkCapabilities;
        }

        public NetworkCapabilities[] newArray(int n) {
            return new NetworkCapabilities[n];
        }
    };
    private static final boolean DBG = false;
    private static final int MAX_NET_CAPABILITY = 15;
    private static final int MAX_TRANSPORT = 4;
    private static final int MIN_NET_CAPABILITY = 0;
    private static final int MIN_TRANSPORT = 0;
    public static final int NET_CAPABILITY_CBS = 5;
    public static final int NET_CAPABILITY_DUN = 2;
    public static final int NET_CAPABILITY_EIMS = 10;
    public static final int NET_CAPABILITY_FOTA = 3;
    public static final int NET_CAPABILITY_IA = 7;
    public static final int NET_CAPABILITY_IMS = 4;
    public static final int NET_CAPABILITY_INTERNET = 12;
    public static final int NET_CAPABILITY_MMS = 0;
    public static final int NET_CAPABILITY_NOT_METERED = 11;
    public static final int NET_CAPABILITY_NOT_RESTRICTED = 13;
    public static final int NET_CAPABILITY_NOT_VPN = 15;
    public static final int NET_CAPABILITY_RCS = 8;
    public static final int NET_CAPABILITY_SUPL = 1;
    public static final int NET_CAPABILITY_TRUSTED = 14;
    public static final int NET_CAPABILITY_WIFI_P2P = 6;
    public static final int NET_CAPABILITY_XCAP = 9;
    private static final String TAG = "NetworkCapabilities";
    public static final int TRANSPORT_BLUETOOTH = 2;
    public static final int TRANSPORT_CELLULAR = 0;
    public static final int TRANSPORT_ETHERNET = 3;
    public static final int TRANSPORT_VPN = 4;
    public static final int TRANSPORT_WIFI = 1;
    private int mLinkDownBandwidthKbps;
    private int mLinkUpBandwidthKbps;
    private long mNetworkCapabilities = 57344L;
    private String mNetworkSpecifier;
    private long mTransportTypes;

    public NetworkCapabilities() {
    }

    public NetworkCapabilities(NetworkCapabilities networkCapabilities) {
        if (networkCapabilities != null) {
            this.mNetworkCapabilities = networkCapabilities.mNetworkCapabilities;
            this.mTransportTypes = networkCapabilities.mTransportTypes;
            this.mLinkUpBandwidthKbps = networkCapabilities.mLinkUpBandwidthKbps;
            this.mLinkDownBandwidthKbps = networkCapabilities.mLinkDownBandwidthKbps;
            this.mNetworkSpecifier = networkCapabilities.mNetworkSpecifier;
        }
    }

    static /* synthetic */ long access$002(NetworkCapabilities networkCapabilities, long l) {
        networkCapabilities.mNetworkCapabilities = l;
        return l;
    }

    static /* synthetic */ long access$102(NetworkCapabilities networkCapabilities, long l) {
        networkCapabilities.mTransportTypes = l;
        return l;
    }

    static /* synthetic */ int access$202(NetworkCapabilities networkCapabilities, int n) {
        networkCapabilities.mLinkUpBandwidthKbps = n;
        return n;
    }

    static /* synthetic */ int access$302(NetworkCapabilities networkCapabilities, int n) {
        networkCapabilities.mLinkDownBandwidthKbps = n;
        return n;
    }

    static /* synthetic */ String access$402(NetworkCapabilities networkCapabilities, String string2) {
        networkCapabilities.mNetworkSpecifier = string2;
        return string2;
    }

    private void combineLinkBandwidths(NetworkCapabilities networkCapabilities) {
        this.mLinkUpBandwidthKbps = Math.max(this.mLinkUpBandwidthKbps, networkCapabilities.mLinkUpBandwidthKbps);
        this.mLinkDownBandwidthKbps = Math.max(this.mLinkDownBandwidthKbps, networkCapabilities.mLinkDownBandwidthKbps);
    }

    private void combineNetCapabilities(NetworkCapabilities networkCapabilities) {
        this.mNetworkCapabilities |= networkCapabilities.mNetworkCapabilities;
    }

    private void combineSpecifiers(NetworkCapabilities networkCapabilities) {
        String string2 = networkCapabilities.getNetworkSpecifier();
        if (TextUtils.isEmpty(string2)) {
            return;
        }
        if (!TextUtils.isEmpty(this.mNetworkSpecifier)) {
            throw new IllegalStateException("Can't combine two networkSpecifiers");
        }
        this.setNetworkSpecifier(string2);
    }

    private void combineTransportTypes(NetworkCapabilities networkCapabilities) {
        this.mTransportTypes |= networkCapabilities.mTransportTypes;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int[] enumerateBits(long l) {
        int[] nArray = new int[Long.bitCount(l)];
        int n = 0;
        int n2 = 0;
        while (l > 0L) {
            int n3;
            if ((l & 1L) == 1L) {
                n3 = n2 + 1;
                nArray[n2] = n;
            } else {
                n3 = n2;
            }
            l >>= 1;
            ++n;
            n2 = n3;
        }
        return nArray;
    }

    private boolean equalsLinkBandwidths(NetworkCapabilities networkCapabilities) {
        return this.mLinkUpBandwidthKbps == networkCapabilities.mLinkUpBandwidthKbps && this.mLinkDownBandwidthKbps == networkCapabilities.mLinkDownBandwidthKbps;
    }

    private boolean equalsNetCapabilities(NetworkCapabilities networkCapabilities) {
        return networkCapabilities.mNetworkCapabilities == this.mNetworkCapabilities;
    }

    private boolean equalsSpecifier(NetworkCapabilities networkCapabilities) {
        if (TextUtils.isEmpty(this.mNetworkSpecifier)) {
            return TextUtils.isEmpty(networkCapabilities.mNetworkSpecifier);
        }
        return this.mNetworkSpecifier.equals(networkCapabilities.mNetworkSpecifier);
    }

    private boolean equalsTransportTypes(NetworkCapabilities networkCapabilities) {
        return networkCapabilities.mTransportTypes == this.mTransportTypes;
    }

    private boolean satisfiedByLinkBandwidths(NetworkCapabilities networkCapabilities) {
        return this.mLinkUpBandwidthKbps <= networkCapabilities.mLinkUpBandwidthKbps && this.mLinkDownBandwidthKbps <= networkCapabilities.mLinkDownBandwidthKbps;
    }

    private boolean satisfiedByNetCapabilities(NetworkCapabilities networkCapabilities) {
        return (networkCapabilities.mNetworkCapabilities & this.mNetworkCapabilities) == this.mNetworkCapabilities;
    }

    private boolean satisfiedBySpecifier(NetworkCapabilities networkCapabilities) {
        return TextUtils.isEmpty(this.mNetworkSpecifier) || this.mNetworkSpecifier.equals(networkCapabilities.mNetworkSpecifier);
    }

    private boolean satisfiedByTransportTypes(NetworkCapabilities networkCapabilities) {
        return this.mTransportTypes == 0L || (this.mTransportTypes & networkCapabilities.mTransportTypes) != 0L;
    }

    public NetworkCapabilities addCapability(int n) {
        if (n < 0 || n > 15) {
            throw new IllegalArgumentException("NetworkCapability out of range");
        }
        this.mNetworkCapabilities |= (long)(1 << n);
        return this;
    }

    public NetworkCapabilities addTransportType(int n) {
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("TransportType out of range");
        }
        this.mTransportTypes |= (long)(1 << n);
        this.setNetworkSpecifier(this.mNetworkSpecifier);
        return this;
    }

    public void combineCapabilities(NetworkCapabilities networkCapabilities) {
        this.combineNetCapabilities(networkCapabilities);
        this.combineTransportTypes(networkCapabilities);
        this.combineLinkBandwidths(networkCapabilities);
        this.combineSpecifiers(networkCapabilities);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        NetworkCapabilities networkCapabilities;
        return object != null && object instanceof NetworkCapabilities && this.equalsNetCapabilities(networkCapabilities = (NetworkCapabilities)object) && this.equalsTransportTypes(networkCapabilities) && this.equalsLinkBandwidths(networkCapabilities) && this.equalsSpecifier(networkCapabilities);
    }

    public int[] getCapabilities() {
        return this.enumerateBits(this.mNetworkCapabilities);
    }

    public int getLinkDownstreamBandwidthKbps() {
        return this.mLinkDownBandwidthKbps;
    }

    public int getLinkUpstreamBandwidthKbps() {
        return this.mLinkUpBandwidthKbps;
    }

    public String getNetworkSpecifier() {
        return this.mNetworkSpecifier;
    }

    public int[] getTransportTypes() {
        return this.enumerateBits(this.mTransportTypes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasCapability(int n) {
        int n2 = 1;
        if (n < 0) return 0 != 0;
        if (n > 15) {
            return 0 != 0;
        }
        if ((this.mNetworkCapabilities & (long)(n2 << n)) != 0L) return n2 != 0;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasTransport(int n) {
        int n2 = 1;
        if (n < 0) return 0 != 0;
        if (n > 4) {
            return 0 != 0;
        }
        if ((this.mTransportTypes & (long)(n2 << n)) != 0L) return n2 != 0;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int hashCode() {
        int n;
        int n2 = (int)(0xFFFFFFFFFFFFFFFFL & this.mNetworkCapabilities) + 3 * (int)(this.mNetworkCapabilities >> 32) + 5 * (int)(0xFFFFFFFFFFFFFFFFL & this.mTransportTypes) + 7 * (int)(this.mTransportTypes >> 32) + 11 * this.mLinkUpBandwidthKbps + 13 * this.mLinkDownBandwidthKbps;
        if (TextUtils.isEmpty(this.mNetworkSpecifier)) {
            n = 0;
            return n + n2;
        }
        n = 17 * this.mNetworkSpecifier.hashCode();
        return n + n2;
    }

    public NetworkCapabilities removeCapability(int n) {
        if (n < 0 || n > 15) {
            throw new IllegalArgumentException("NetworkCapability out of range");
        }
        this.mNetworkCapabilities &= (long)(0xFFFFFFFF ^ 1 << n);
        return this;
    }

    public NetworkCapabilities removeTransportType(int n) {
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("TransportType out of range");
        }
        this.mTransportTypes &= (long)(0xFFFFFFFF ^ 1 << n);
        this.setNetworkSpecifier(this.mNetworkSpecifier);
        return this;
    }

    public boolean satisfiedByNetworkCapabilities(NetworkCapabilities networkCapabilities) {
        return networkCapabilities != null && this.satisfiedByNetCapabilities(networkCapabilities) && this.satisfiedByTransportTypes(networkCapabilities) && this.satisfiedByLinkBandwidths(networkCapabilities) && this.satisfiedBySpecifier(networkCapabilities);
    }

    public void setLinkDownstreamBandwidthKbps(int n) {
        this.mLinkDownBandwidthKbps = n;
    }

    public void setLinkUpstreamBandwidthKbps(int n) {
        this.mLinkUpBandwidthKbps = n;
    }

    public void setNetworkSpecifier(String string2) {
        if (!TextUtils.isEmpty(string2) && Long.bitCount(this.mTransportTypes) != 1) {
            throw new IllegalStateException("Must have a single transport specified to use setNetworkSpecifier");
        }
        this.mNetworkSpecifier = string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        String string2;
        int[] nArray = this.getTransportTypes();
        String string3 = nArray.length > 0 ? " Transports: " : "";
        int n = 0;
        while (n < nArray.length) {
            switch (nArray[n]) {
                case 0: {
                    string3 = string3 + "CELLULAR";
                    break;
                }
                case 1: {
                    string3 = string3 + "WIFI";
                    break;
                }
                case 2: {
                    string3 = string3 + "BLUETOOTH";
                    break;
                }
                case 3: {
                    string3 = string3 + "ETHERNET";
                    break;
                }
                case 4: {
                    string3 = string3 + "VPN";
                    break;
                }
            }
            if (++n >= nArray.length) continue;
            string3 = string3 + "|";
        }
        int[] nArray2 = this.getCapabilities();
        String string4 = nArray2.length > 0 ? " Capabilities: " : "";
        int n2 = 0;
        while (n2 < nArray2.length) {
            switch (nArray2[n2]) {
                case 0: {
                    string4 = string4 + "MMS";
                    break;
                }
                case 1: {
                    string4 = string4 + "SUPL";
                    break;
                }
                case 2: {
                    string4 = string4 + "DUN";
                    break;
                }
                case 3: {
                    string4 = string4 + "FOTA";
                    break;
                }
                case 4: {
                    string4 = string4 + "IMS";
                    break;
                }
                case 5: {
                    string4 = string4 + "CBS";
                    break;
                }
                case 6: {
                    string4 = string4 + "WIFI_P2P";
                    break;
                }
                case 7: {
                    string4 = string4 + "IA";
                    break;
                }
                case 8: {
                    string4 = string4 + "RCS";
                    break;
                }
                case 9: {
                    string4 = string4 + "XCAP";
                    break;
                }
                case 10: {
                    string4 = string4 + "EIMS";
                    break;
                }
                case 11: {
                    string4 = string4 + "NOT_METERED";
                    break;
                }
                case 12: {
                    string4 = string4 + "INTERNET";
                    break;
                }
                case 13: {
                    string4 = string4 + "NOT_RESTRICTED";
                    break;
                }
                case 14: {
                    string4 = string4 + "TRUSTED";
                    break;
                }
                case 15: {
                    string4 = string4 + "NOT_VPN";
                    break;
                }
            }
            if (++n2 >= nArray2.length) continue;
            string4 = string4 + "&";
        }
        String string5 = this.mLinkUpBandwidthKbps > 0 ? " LinkUpBandwidth>=" + this.mLinkUpBandwidthKbps + "Kbps" : "";
        String string6 = this.mLinkDownBandwidthKbps > 0 ? " LinkDnBandwidth>=" + this.mLinkDownBandwidthKbps + "Kbps" : "";
        if (this.mNetworkSpecifier == null) {
            string2 = "";
            return "[" + string3 + string4 + string5 + string6 + string2 + "]";
        }
        string2 = " Specifier: <" + this.mNetworkSpecifier + ">";
        return "[" + string3 + string4 + string5 + string6 + string2 + "]";
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeLong(this.mNetworkCapabilities);
        parcel.writeLong(this.mTransportTypes);
        parcel.writeInt(this.mLinkUpBandwidthKbps);
        parcel.writeInt(this.mLinkDownBandwidthKbps);
        parcel.writeString(this.mNetworkSpecifier);
    }
}

