/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p;

import android.net.wifi.p2p.WifiP2pDevice;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WifiP2pGroup
implements Parcelable {
    public static final Parcelable.Creator<WifiP2pGroup> CREATOR;
    public static final int PERSISTENT_NET_ID = -2;
    public static final int TEMPORARY_NET_ID = -1;
    private static final Pattern groupStartedPattern;
    private List<WifiP2pDevice> mClients = new ArrayList<WifiP2pDevice>();
    private int mFrequency;
    private String mInterface;
    private boolean mIsGroupOwner;
    private int mNetId;
    private String mNetworkName;
    private WifiP2pDevice mOwner;
    private String mPassphrase;

    static {
        groupStartedPattern = Pattern.compile("ssid=\"(.+)\" freq=(\\d+) (?:psk=)?([0-9a-fA-F]{64})?(?:passphrase=)?(?:\"(.{0,63})\")? go_dev_addr=((?:[0-9a-f]{2}:){5}[0-9a-f]{2}) ?(\\[PERSISTENT\\])?");
        CREATOR = new Parcelable.Creator<WifiP2pGroup>(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public WifiP2pGroup createFromParcel(Parcel parcel) {
                WifiP2pGroup wifiP2pGroup = new WifiP2pGroup();
                wifiP2pGroup.setNetworkName(parcel.readString());
                wifiP2pGroup.setOwner((WifiP2pDevice)parcel.readParcelable(null));
                boolean bl = parcel.readByte() == 1;
                wifiP2pGroup.setIsGroupOwner(bl);
                int n = parcel.readInt();
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        wifiP2pGroup.setPassphrase(parcel.readString());
                        wifiP2pGroup.setInterface(parcel.readString());
                        wifiP2pGroup.setNetworkId(parcel.readInt());
                        wifiP2pGroup.setFrequency(parcel.readInt());
                        return wifiP2pGroup;
                    }
                    wifiP2pGroup.addClient((WifiP2pDevice)parcel.readParcelable(null));
                    ++n2;
                }
            }

            public WifiP2pGroup[] newArray(int n) {
                return new WifiP2pGroup[n];
            }
        };
    }

    public WifiP2pGroup() {
    }

    public WifiP2pGroup(WifiP2pGroup wifiP2pGroup) {
        if (wifiP2pGroup != null) {
            this.mNetworkName = wifiP2pGroup.getNetworkName();
            this.mOwner = new WifiP2pDevice(wifiP2pGroup.getOwner());
            this.mIsGroupOwner = wifiP2pGroup.mIsGroupOwner;
            for (WifiP2pDevice wifiP2pDevice : wifiP2pGroup.getClientList()) {
                this.mClients.add(wifiP2pDevice);
            }
            this.mPassphrase = wifiP2pGroup.getPassphrase();
            this.mInterface = wifiP2pGroup.getInterface();
            this.mNetId = wifiP2pGroup.getNetworkId();
            this.mFrequency = wifiP2pGroup.getFrequency();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public WifiP2pGroup(String string2) throws IllegalArgumentException {
        String[] stringArray = string2.split(" ");
        if (stringArray.length < 3) {
            throw new IllegalArgumentException("Malformed supplicant event");
        }
        if (stringArray[0].startsWith("P2P-GROUP")) {
            this.mInterface = stringArray[1];
            this.mIsGroupOwner = stringArray[2].equals("GO");
            Matcher matcher = groupStartedPattern.matcher(string2);
            if (!matcher.find()) return;
            this.mNetworkName = matcher.group(1);
            this.mFrequency = Integer.parseInt(matcher.group(2));
            this.mPassphrase = matcher.group(4);
            this.mOwner = new WifiP2pDevice(matcher.group(5));
            if (matcher.group(6) != null) {
                this.mNetId = -2;
                return;
            }
            this.mNetId = -1;
            return;
        } else {
            if (!stringArray[0].equals("P2P-INVITATION-RECEIVED")) {
                throw new IllegalArgumentException("Malformed supplicant event");
            }
            String string3 = null;
            this.mNetId = -2;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String[] stringArray2 = stringArray[i].split("=");
                if (stringArray2.length != 2) continue;
                if (stringArray2[0].equals("sa")) {
                    string3 = stringArray2[1];
                    WifiP2pDevice wifiP2pDevice = new WifiP2pDevice();
                    wifiP2pDevice.deviceAddress = stringArray2[1];
                    this.mClients.add(wifiP2pDevice);
                    continue;
                }
                if (stringArray2[0].equals("go_dev_addr")) {
                    this.mOwner = new WifiP2pDevice(stringArray2[1]);
                    continue;
                }
                if (!stringArray2[0].equals("persistent")) continue;
                this.mOwner = new WifiP2pDevice(string3);
                this.mNetId = Integer.parseInt(stringArray2[1]);
            }
        }
    }

    public void addClient(WifiP2pDevice wifiP2pDevice) {
        Iterator<WifiP2pDevice> iterator = this.mClients.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(wifiP2pDevice)) continue;
            return;
        }
        this.mClients.add(wifiP2pDevice);
    }

    public void addClient(String string2) {
        this.addClient(new WifiP2pDevice(string2));
    }

    public boolean contains(WifiP2pDevice wifiP2pDevice) {
        return this.mOwner.equals(wifiP2pDevice) || this.mClients.contains(wifiP2pDevice);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public Collection<WifiP2pDevice> getClientList() {
        return Collections.unmodifiableCollection(this.mClients);
    }

    public int getFrequency() {
        return this.mFrequency;
    }

    public String getInterface() {
        return this.mInterface;
    }

    public int getNetworkId() {
        return this.mNetId;
    }

    public String getNetworkName() {
        return this.mNetworkName;
    }

    public WifiP2pDevice getOwner() {
        return this.mOwner;
    }

    public String getPassphrase() {
        return this.mPassphrase;
    }

    public boolean isClientListEmpty() {
        return this.mClients.size() == 0;
    }

    public boolean isGroupOwner() {
        return this.mIsGroupOwner;
    }

    public boolean removeClient(WifiP2pDevice wifiP2pDevice) {
        return this.mClients.remove(wifiP2pDevice);
    }

    public boolean removeClient(String string2) {
        return this.mClients.remove(new WifiP2pDevice(string2));
    }

    public void setFrequency(int n) {
        this.mFrequency = n;
    }

    public void setInterface(String string2) {
        this.mInterface = string2;
    }

    public void setIsGroupOwner(boolean bl) {
        this.mIsGroupOwner = bl;
    }

    public void setNetworkId(int n) {
        this.mNetId = n;
    }

    public void setNetworkName(String string2) {
        this.mNetworkName = string2;
    }

    public void setOwner(WifiP2pDevice wifiP2pDevice) {
        this.mOwner = wifiP2pDevice;
    }

    public void setPassphrase(String string2) {
        this.mPassphrase = string2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("network: ").append(this.mNetworkName);
        stringBuffer.append("\n isGO: ").append(this.mIsGroupOwner);
        stringBuffer.append("\n GO: ").append(this.mOwner);
        for (WifiP2pDevice wifiP2pDevice : this.mClients) {
            stringBuffer.append("\n Client: ").append(wifiP2pDevice);
        }
        stringBuffer.append("\n interface: ").append(this.mInterface);
        stringBuffer.append("\n networkId: ").append(this.mNetId);
        stringBuffer.append("\n frequency: ").append(this.mFrequency);
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.mNetworkName);
        parcel.writeParcelable(this.mOwner, n);
        byte by = this.mIsGroupOwner ? (byte)1 : 0;
        parcel.writeByte(by);
        parcel.writeInt(this.mClients.size());
        Iterator<WifiP2pDevice> iterator = this.mClients.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                parcel.writeString(this.mPassphrase);
                parcel.writeString(this.mInterface);
                parcel.writeInt(this.mNetId);
                parcel.writeInt(this.mFrequency);
                return;
            }
            parcel.writeParcelable(iterator.next(), n);
        }
    }
}

