/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.Locale;

public class WifiP2pWfdInfo
implements Parcelable {
    private static final int COUPLED_SINK_SUPPORT_AT_SINK = 8;
    private static final int COUPLED_SINK_SUPPORT_AT_SOURCE = 4;
    private static final int CP_BIT = 256;
    public static final Parcelable.Creator<WifiP2pWfdInfo> CREATOR = new Parcelable.Creator<WifiP2pWfdInfo>(){

        @Override
        public WifiP2pWfdInfo createFromParcel(Parcel parcel) {
            WifiP2pWfdInfo wifiP2pWfdInfo = new WifiP2pWfdInfo();
            wifiP2pWfdInfo.readFromParcel(parcel);
            return wifiP2pWfdInfo;
        }

        public WifiP2pWfdInfo[] newArray(int n) {
            return new WifiP2pWfdInfo[n];
        }
    };
    private static final int DEVICE_TYPE = 3;
    public static final int PRIMARY_SINK = 1;
    public static final int SECONDARY_SINK = 2;
    private static final int SESSION_AVAILABLE = 48;
    private static final int SESSION_AVAILABLE_BIT1 = 16;
    private static final int SESSION_AVAILABLE_BIT2 = 32;
    public static final int SOURCE_OR_PRIMARY_SINK = 3;
    private static final String TAG = "WifiP2pWfdInfo";
    public static final int WFD_SOURCE;
    private int mCtrlPort;
    private int mDeviceInfo;
    private int mMaxThroughput;
    private boolean mWfdEnabled;

    public WifiP2pWfdInfo() {
    }

    public WifiP2pWfdInfo(int n, int n2, int n3) {
        this.mWfdEnabled = true;
        this.mDeviceInfo = n;
        this.mCtrlPort = n2;
        this.mMaxThroughput = n3;
    }

    public WifiP2pWfdInfo(WifiP2pWfdInfo wifiP2pWfdInfo) {
        if (wifiP2pWfdInfo != null) {
            this.mWfdEnabled = wifiP2pWfdInfo.mWfdEnabled;
            this.mDeviceInfo = wifiP2pWfdInfo.mDeviceInfo;
            this.mCtrlPort = wifiP2pWfdInfo.mCtrlPort;
            this.mMaxThroughput = wifiP2pWfdInfo.mMaxThroughput;
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getControlPort() {
        return this.mCtrlPort;
    }

    public String getDeviceInfoHex() {
        Locale locale = Locale.US;
        Object[] objectArray = new Object[]{6, this.mDeviceInfo, this.mCtrlPort, this.mMaxThroughput};
        return String.format(locale, "%04x%04x%04x%04x", objectArray);
    }

    public int getDeviceType() {
        return 3 & this.mDeviceInfo;
    }

    public int getMaxThroughput() {
        return this.mMaxThroughput;
    }

    public boolean isContentProtectionSupported() {
        return (0x100 & this.mDeviceInfo) != 0;
    }

    public boolean isCoupledSinkSupportedAtSink() {
        return (8 & this.mDeviceInfo) != 0;
    }

    public boolean isCoupledSinkSupportedAtSource() {
        return (8 & this.mDeviceInfo) != 0;
    }

    public boolean isSessionAvailable() {
        return (0x30 & this.mDeviceInfo) != 0;
    }

    public boolean isWfdEnabled() {
        return this.mWfdEnabled;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void readFromParcel(Parcel parcel) {
        int n = 1;
        if (parcel.readInt() != n) {
            n = 0;
        }
        this.mWfdEnabled = n;
        this.mDeviceInfo = parcel.readInt();
        this.mCtrlPort = parcel.readInt();
        this.mMaxThroughput = parcel.readInt();
    }

    public void setContentProtectionSupported(boolean bl) {
        if (bl) {
            this.mDeviceInfo = 0x100 | this.mDeviceInfo;
            return;
        }
        this.mDeviceInfo = 0xFFFFFEFF & this.mDeviceInfo;
    }

    public void setControlPort(int n) {
        this.mCtrlPort = n;
    }

    public void setCoupledSinkSupportAtSink(boolean bl) {
        if (bl) {
            this.mDeviceInfo = 8 | this.mDeviceInfo;
            return;
        }
        this.mDeviceInfo = 0xFFFFFFF7 & this.mDeviceInfo;
    }

    public void setCoupledSinkSupportAtSource(boolean bl) {
        if (bl) {
            this.mDeviceInfo = 8 | this.mDeviceInfo;
            return;
        }
        this.mDeviceInfo = 0xFFFFFFF7 & this.mDeviceInfo;
    }

    public boolean setDeviceType(int n) {
        if (n >= 0 && n <= 3) {
            this.mDeviceInfo = n | this.mDeviceInfo;
            return true;
        }
        return false;
    }

    public void setMaxThroughput(int n) {
        this.mMaxThroughput = n;
    }

    public void setSessionAvailable(boolean bl) {
        if (bl) {
            this.mDeviceInfo = 0x10 | this.mDeviceInfo;
            this.mDeviceInfo = 0xFFFFFFDF & this.mDeviceInfo;
            return;
        }
        this.mDeviceInfo = 0xFFFFFFCF & this.mDeviceInfo;
    }

    public void setWfdEnabled(boolean bl) {
        this.mWfdEnabled = bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WFD enabled: ").append(this.mWfdEnabled);
        stringBuffer.append("WFD DeviceInfo: ").append(this.mDeviceInfo);
        stringBuffer.append("\n WFD CtrlPort: ").append(this.mCtrlPort);
        stringBuffer.append("\n WFD MaxThroughput: ").append(this.mMaxThroughput);
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = this.mWfdEnabled ? 1 : 0;
        parcel.writeInt(n2);
        parcel.writeInt(this.mDeviceInfo);
        parcel.writeInt(this.mCtrlPort);
        parcel.writeInt(this.mMaxThroughput);
    }
}

