/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p.nsd;

import android.net.nsd.DnsSdTxtRecord;
import android.net.wifi.p2p.nsd.WifiP2pServiceInfo;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class WifiP2pDnsSdServiceInfo
extends WifiP2pServiceInfo {
    public static final int DNS_TYPE_PTR = 12;
    public static final int DNS_TYPE_TXT = 16;
    public static final int VERSION_1 = 1;
    private static final Map<String, String> sVmPacket = new HashMap<String, String>();

    static {
        sVmPacket.put("_tcp.local.", "c00c");
        sVmPacket.put("local.", "c011");
        sVmPacket.put("_udp.local.", "c01c");
    }

    private WifiP2pDnsSdServiceInfo(List<String> list) {
        super(list);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String compressDnsName(String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            String string3;
            if ((string3 = sVmPacket.get(string2)) != null) {
                stringBuffer.append(string3);
                return stringBuffer.toString();
            }
            int n = string2.indexOf(46);
            if (n == -1) {
                if (string2.length() > 0) {
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{string2.length()};
                    stringBuffer.append(String.format(locale, "%02x", objectArray));
                    stringBuffer.append(WifiP2pServiceInfo.bin2HexStr(string2.getBytes()));
                }
                stringBuffer.append("00");
                return stringBuffer.toString();
            }
            String string4 = string2.substring(0, n);
            string2 = string2.substring(n + 1);
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{string4.length()};
            stringBuffer.append(String.format(locale, "%02x", objectArray));
            stringBuffer.append(WifiP2pServiceInfo.bin2HexStr(string4.getBytes()));
        }
    }

    private static String createPtrServiceQuery(String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("bonjour ");
        stringBuffer.append(WifiP2pDnsSdServiceInfo.createRequest(string3 + ".local.", 12, 1));
        stringBuffer.append(" ");
        byte[] byArray = string2.getBytes();
        Locale locale = Locale.US;
        Object[] objectArray = new Object[]{byArray.length};
        stringBuffer.append(String.format(locale, "%02x", objectArray));
        stringBuffer.append(WifiP2pServiceInfo.bin2HexStr(byArray));
        stringBuffer.append("c027");
        return stringBuffer.toString();
    }

    static String createRequest(String string2, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n == 16) {
            string2 = string2.toLowerCase(Locale.ROOT);
        }
        stringBuffer.append(WifiP2pDnsSdServiceInfo.compressDnsName(string2));
        Locale locale = Locale.US;
        Object[] objectArray = new Object[]{n};
        stringBuffer.append(String.format(locale, "%04x", objectArray));
        Locale locale2 = Locale.US;
        Object[] objectArray2 = new Object[]{n2};
        stringBuffer.append(String.format(locale2, "%02x", objectArray2));
        return stringBuffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String createTxtServiceQuery(String string2, String string3, DnsSdTxtRecord dnsSdTxtRecord) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("bonjour ");
        stringBuffer.append(WifiP2pDnsSdServiceInfo.createRequest(string2 + "." + string3 + ".local.", 16, 1));
        stringBuffer.append(" ");
        byte[] byArray = dnsSdTxtRecord.getRawData();
        if (byArray.length == 0) {
            stringBuffer.append("00");
            return stringBuffer.toString();
        }
        stringBuffer.append(WifiP2pDnsSdServiceInfo.bin2HexStr(byArray));
        return stringBuffer.toString();
    }

    public static WifiP2pDnsSdServiceInfo newInstance(String string2, String string3, Map<String, String> map) {
        if (TextUtils.isEmpty(string2) || TextUtils.isEmpty(string3)) {
            throw new IllegalArgumentException("instance name or service type cannot be empty");
        }
        DnsSdTxtRecord dnsSdTxtRecord = new DnsSdTxtRecord();
        if (map != null) {
            for (String string4 : map.keySet()) {
                dnsSdTxtRecord.set(string4, map.get(string4));
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(WifiP2pDnsSdServiceInfo.createPtrServiceQuery(string2, string3));
        arrayList.add(WifiP2pDnsSdServiceInfo.createTxtServiceQuery(string2, string3, dnsSdTxtRecord));
        return new WifiP2pDnsSdServiceInfo(arrayList);
    }
}

