/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p.nsd;

import android.net.wifi.p2p.WifiP2pDevice;
import android.net.wifi.p2p.nsd.WifiP2pDnsSdServiceResponse;
import android.net.wifi.p2p.nsd.WifiP2pUpnpServiceResponse;
import android.os.Parcel;
import android.os.Parcelable;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class WifiP2pServiceResponse
implements Parcelable {
    public static final Parcelable.Creator<WifiP2pServiceResponse> CREATOR;
    private static int MAX_BUF_SIZE;
    protected byte[] mData;
    protected WifiP2pDevice mDevice;
    protected int mServiceType;
    protected int mStatus;
    protected int mTransId;

    static {
        MAX_BUF_SIZE = 1024;
        CREATOR = new Parcelable.Creator<WifiP2pServiceResponse>(){

            @Override
            public WifiP2pServiceResponse createFromParcel(Parcel parcel) {
                int n = parcel.readInt();
                int n2 = parcel.readInt();
                int n3 = parcel.readInt();
                WifiP2pDevice wifiP2pDevice = (WifiP2pDevice)parcel.readParcelable(null);
                int n4 = parcel.readInt();
                byte[] byArray = null;
                if (n4 > 0) {
                    byArray = new byte[n4];
                    parcel.readByteArray(byArray);
                }
                if (n == 1) {
                    return WifiP2pDnsSdServiceResponse.newInstance(n2, n3, wifiP2pDevice, byArray);
                }
                if (n == 2) {
                    return WifiP2pUpnpServiceResponse.newInstance(n2, n3, wifiP2pDevice, byArray);
                }
                return new WifiP2pServiceResponse(n, n2, n3, wifiP2pDevice, byArray);
            }

            public WifiP2pServiceResponse[] newArray(int n) {
                return new WifiP2pServiceResponse[n];
            }
        };
    }

    protected WifiP2pServiceResponse(int n, int n2, int n3, WifiP2pDevice wifiP2pDevice, byte[] byArray) {
        this.mServiceType = n;
        this.mStatus = n2;
        this.mTransId = n3;
        this.mDevice = wifiP2pDevice;
        this.mData = byArray;
    }

    private boolean equals(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object != null) {
            return object.equals(object2);
        }
        return false;
    }

    private static byte[] hexStr2Bin(String string2) {
        int n = string2.length() / 2;
        byte[] byArray = new byte[string2.length() / 2];
        for (int i = 0; i < n; ++i) {
            int n2 = i * 2;
            int n3 = 2 + i * 2;
            try {
                byArray[i] = (byte)Integer.parseInt(string2.substring(n2, n3), 16);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                byArray = null;
                break;
            }
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<WifiP2pServiceResponse> newInstance(String string2) {
        ArrayList<WifiP2pServiceResponse> arrayList = new ArrayList<WifiP2pServiceResponse>();
        String[] stringArray = string2.split(" ");
        if (stringArray.length != 4) {
            return null;
        }
        WifiP2pDevice wifiP2pDevice = new WifiP2pDevice();
        wifiP2pDevice.deviceAddress = stringArray[1];
        byte[] byArray = WifiP2pServiceResponse.hexStr2Bin(stringArray[3]);
        if (byArray == null) {
            return null;
        }
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        while (true) {
            int n;
            int n2;
            int n3;
            int n4;
            block10: {
                try {
                    while (dataInputStream.available() > 0) {
                        n4 = -3 + (dataInputStream.readUnsignedByte() + (dataInputStream.readUnsignedByte() << 8));
                        n3 = dataInputStream.readUnsignedByte();
                        n2 = dataInputStream.readUnsignedByte();
                        n = dataInputStream.readUnsignedByte();
                        if (n4 < 0) {
                            return null;
                        }
                        if (n4 == 0) {
                            if (n != 0) continue;
                            arrayList.add(new WifiP2pServiceResponse(n3, n, n2, wifiP2pDevice, null));
                            continue;
                        }
                        if (n4 > MAX_BUF_SIZE) {
                            dataInputStream.skip(n4);
                            continue;
                        }
                        break block10;
                    }
                    return arrayList;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    if (arrayList.size() > 0) return arrayList;
                    return null;
                }
            }
            byte[] byArray2 = new byte[n4];
            dataInputStream.readFully(byArray2);
            WifiP2pServiceResponse wifiP2pServiceResponse = n3 == 1 ? WifiP2pDnsSdServiceResponse.newInstance(n, n2, wifiP2pDevice, byArray2) : (n3 == 2 ? WifiP2pUpnpServiceResponse.newInstance(n, n2, wifiP2pDevice, byArray2) : new WifiP2pServiceResponse(n3, n, n2, wifiP2pDevice, byArray2));
            if (wifiP2pServiceResponse == null || wifiP2pServiceResponse.getStatus() != 0) continue;
            arrayList.add(wifiP2pServiceResponse);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block5: {
            block4: {
                if (object == this) break block4;
                if (!(object instanceof WifiP2pServiceResponse)) {
                    return false;
                }
                WifiP2pServiceResponse wifiP2pServiceResponse = (WifiP2pServiceResponse)object;
                if (wifiP2pServiceResponse.mServiceType != this.mServiceType || wifiP2pServiceResponse.mStatus != this.mStatus || !this.equals(wifiP2pServiceResponse.mDevice.deviceAddress, this.mDevice.deviceAddress) || !Arrays.equals(wifiP2pServiceResponse.mData, this.mData)) break block5;
            }
            return true;
        }
        return false;
    }

    public byte[] getRawData() {
        return this.mData;
    }

    public int getServiceType() {
        return this.mServiceType;
    }

    public WifiP2pDevice getSrcDevice() {
        return this.mDevice;
    }

    public int getStatus() {
        return this.mStatus;
    }

    public int getTransactionId() {
        return this.mTransId;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int hashCode() {
        int n = 31 * (31 * (31 * (527 + this.mServiceType) + this.mStatus) + this.mTransId);
        int n2 = this.mDevice.deviceAddress == null ? 0 : this.mDevice.deviceAddress.hashCode();
        int n3 = 31 * (n + n2);
        byte[] byArray = this.mData;
        int n4 = 0;
        if (byArray == null) {
            return n3 + n4;
        }
        n4 = this.mData.hashCode();
        return n3 + n4;
    }

    public void setSrcDevice(WifiP2pDevice wifiP2pDevice) {
        if (wifiP2pDevice == null) {
            return;
        }
        this.mDevice = wifiP2pDevice;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("serviceType:").append(this.mServiceType);
        stringBuffer.append(" status:").append(Status.toString(this.mStatus));
        stringBuffer.append(" srcAddr:").append(this.mDevice.deviceAddress);
        stringBuffer.append(" data:").append(this.mData);
        return stringBuffer.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mServiceType);
        parcel.writeInt(this.mStatus);
        parcel.writeInt(this.mTransId);
        parcel.writeParcelable(this.mDevice, n);
        if (this.mData == null || this.mData.length == 0) {
            parcel.writeInt(0);
            return;
        }
        parcel.writeInt(this.mData.length);
        parcel.writeByteArray(this.mData);
    }

    public static class Status {
        public static final int BAD_REQUEST = 3;
        public static final int REQUESTED_INFORMATION_NOT_AVAILABLE = 2;
        public static final int SERVICE_PROTOCOL_NOT_AVAILABLE = 1;
        public static final int SUCCESS;

        private Status() {
        }

        public static String toString(int n) {
            switch (n) {
                default: {
                    return "UNKNOWN";
                }
                case 0: {
                    return "SUCCESS";
                }
                case 1: {
                    return "SERVICE_PROTOCOL_NOT_AVAILABLE";
                }
                case 2: {
                    return "REQUESTED_INFORMATION_NOT_AVAILABLE";
                }
                case 3: 
            }
            return "BAD_REQUEST";
        }
    }
}

