/*
 * Decompiled with CFR 0.152.
 */
package android.nfc.tech;

import android.nfc.Tag;
import android.nfc.tech.BasicTagTechnology;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import java.io.IOException;

public final class NfcA
extends BasicTagTechnology {
    public static final String EXTRA_ATQA = "atqa";
    public static final String EXTRA_SAK = "sak";
    private static final String TAG = "NFC";
    private byte[] mAtqa;
    private short mSak;

    public NfcA(Tag tag) throws RemoteException {
        super(tag, 1);
        Bundle bundle = tag.getTechExtras(1);
        this.mSak = bundle.getShort(EXTRA_SAK);
        this.mAtqa = bundle.getByteArray(EXTRA_ATQA);
    }

    public static NfcA get(Tag tag) {
        if (!tag.hasTech(1)) {
            return null;
        }
        try {
            NfcA nfcA = new NfcA(tag);
            return nfcA;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public byte[] getAtqa() {
        return this.mAtqa;
    }

    public int getMaxTransceiveLength() {
        return this.getMaxTransceiveLengthInternal();
    }

    public short getSak() {
        return this.mSak;
    }

    public int getTimeout() {
        try {
            int n = this.mTag.getTagService().getTimeout(1);
            return n;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "NFC service dead", remoteException);
            return 0;
        }
    }

    public void setTimeout(int n) {
        try {
            if (this.mTag.getTagService().setTimeout(1, n) != 0) {
                throw new IllegalArgumentException("The supplied timeout is not valid");
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "NFC service dead", remoteException);
        }
    }

    public byte[] transceive(byte[] byArray) throws IOException {
        return this.transceive(byArray, true);
    }
}

