/*
 * Decompiled with CFR 0.152.
 */
package android.opengl;

import android.opengl.ETC1;
import android.opengl.GLES10;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ETC1Util {
    public static ETC1Texture compressTexture(Buffer buffer, int n, int n2, int n3, int n4) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(ETC1.getEncodedDataSize(n, n2)).order(ByteOrder.nativeOrder());
        ETC1.encodeImage(buffer, n, n2, n3, n4, byteBuffer);
        return new ETC1Texture(n, n2, byteBuffer);
    }

    public static ETC1Texture createTexture(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        if (inputStream.read(byArray, 0, 16) != 16) {
            throw new IOException("Unable to read PKM file header.");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(16).order(ByteOrder.nativeOrder());
        byteBuffer.put(byArray, 0, 16).position(0);
        if (!ETC1.isValid(byteBuffer)) {
            throw new IOException("Not a PKM file.");
        }
        int n2 = ETC1.getWidth(byteBuffer);
        int n3 = ETC1.getHeight(byteBuffer);
        int n4 = ETC1.getEncodedDataSize(n2, n3);
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n4).order(ByteOrder.nativeOrder());
        for (int i = 0; i < n4; i += n) {
            n = Math.min(byArray.length, n4 - i);
            if (inputStream.read(byArray, 0, n) != n) {
                throw new IOException("Unable to read PKM file data.");
            }
            byteBuffer2.put(byArray, 0, n);
        }
        byteBuffer2.position(0);
        return new ETC1Texture(n2, n3, byteBuffer2);
    }

    public static boolean isETC1Supported() {
        int[] nArray = new int[20];
        GLES10.glGetIntegerv(34466, nArray, 0);
        int n = nArray[0];
        if (n > nArray.length) {
            nArray = new int[n];
        }
        GLES10.glGetIntegerv(34467, nArray, 0);
        int n2 = 0;
        while (true) {
            block6: {
                boolean bl;
                block5: {
                    bl = false;
                    if (n2 >= n) break block5;
                    if (nArray[n2] != 36196) break block6;
                    bl = true;
                }
                return bl;
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void loadTexture(int n, int n2, int n3, int n4, int n5, ETC1Texture eTC1Texture) {
        if (n4 != 6407) {
            throw new IllegalArgumentException("fallbackFormat must be GL_RGB");
        }
        if (n5 != 33635 && n5 != 5121) {
            throw new IllegalArgumentException("Unsupported fallbackType");
        }
        int n6 = eTC1Texture.getWidth();
        int n7 = eTC1Texture.getHeight();
        ByteBuffer byteBuffer = eTC1Texture.getData();
        if (ETC1Util.isETC1Supported()) {
            GLES10.glCompressedTexImage2D(n, n2, 36196, n6, n7, n3, byteBuffer.remaining(), byteBuffer);
            return;
        }
        boolean bl = n5 != 5121;
        int n8 = bl ? 2 : 3;
        int n9 = n8 * n6;
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n9 * n7).order(ByteOrder.nativeOrder());
        ETC1.decodeImage(byteBuffer, byteBuffer2, n6, n7, n8, n9);
        GLES10.glTexImage2D(n, n2, n4, n6, n7, n3, n4, n5, byteBuffer2);
    }

    public static void loadTexture(int n, int n2, int n3, int n4, int n5, InputStream inputStream) throws IOException {
        ETC1Util.loadTexture(n, n2, n3, n4, n5, ETC1Util.createTexture(inputStream));
    }

    public static void writeTexture(ETC1Texture eTC1Texture, OutputStream outputStream) throws IOException {
        int n;
        int n2;
        byte[] byArray;
        ByteBuffer byteBuffer = eTC1Texture.getData();
        int n3 = byteBuffer.position();
        try {
            int n4 = eTC1Texture.getWidth();
            int n5 = eTC1Texture.getHeight();
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(16).order(ByteOrder.nativeOrder());
            ETC1.formatHeader(byteBuffer2, n4, n5);
            byArray = new byte[4096];
            byteBuffer2.get(byArray, 0, 16);
            outputStream.write(byArray, 0, 16);
            n2 = ETC1.getEncodedDataSize(n4, n5);
        }
        catch (Throwable throwable) {
            byteBuffer.position(n3);
            throw throwable;
        }
        for (int i = 0; i < n2; i += n) {
            n = Math.min(byArray.length, n2 - i);
            byteBuffer.get(byArray, 0, n);
            outputStream.write(byArray, 0, n);
            continue;
        }
        byteBuffer.position(n3);
        return;
    }

    public static class ETC1Texture {
        private ByteBuffer mData;
        private int mHeight;
        private int mWidth;

        public ETC1Texture(int n, int n2, ByteBuffer byteBuffer) {
            this.mWidth = n;
            this.mHeight = n2;
            this.mData = byteBuffer;
        }

        public ByteBuffer getData() {
            return this.mData;
        }

        public int getHeight() {
            return this.mHeight;
        }

        public int getWidth() {
            return this.mWidth;
        }
    }
}

