/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;

public abstract class CountDownTimer {
    private static final int MSG = 1;
    private boolean mCancelled = false;
    private final long mCountdownInterval;
    private Handler mHandler = new Handler(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void handleMessage(Message message) {
            CountDownTimer countDownTimer = CountDownTimer.this;
            synchronized (countDownTimer) {
                if (CountDownTimer.this.mCancelled) {
                    return;
                }
                long l = CountDownTimer.this.mStopTimeInFuture - SystemClock.elapsedRealtime();
                if (l <= 0L) {
                    CountDownTimer.this.onFinish();
                } else if (l < CountDownTimer.this.mCountdownInterval) {
                    this.sendMessageDelayed(this.obtainMessage(1), l);
                } else {
                    long l2;
                    long l3 = SystemClock.elapsedRealtime();
                    CountDownTimer.this.onTick(l);
                    for (l2 = l3 + CountDownTimer.this.mCountdownInterval - SystemClock.elapsedRealtime(); l2 < 0L; l2 += CountDownTimer.this.mCountdownInterval) {
                    }
                    this.sendMessageDelayed(this.obtainMessage(1), l2);
                }
                return;
            }
        }
    };
    private final long mMillisInFuture;
    private long mStopTimeInFuture;

    public CountDownTimer(long l, long l2) {
        this.mMillisInFuture = l;
        this.mCountdownInterval = l2;
    }

    public final void cancel() {
        synchronized (this) {
            this.mCancelled = true;
            this.mHandler.removeMessages(1);
            return;
        }
    }

    public abstract void onFinish();

    public abstract void onTick(long var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final CountDownTimer start() {
        synchronized (this) {
            block4: {
                this.mCancelled = false;
                if (this.mMillisInFuture > 0L) break block4;
                this.onFinish();
                return this;
            }
            this.mStopTimeInFuture = SystemClock.elapsedRealtime() + this.mMillisInFuture;
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1));
            return this;
        }
    }
}

