/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.content.Context;
import android.content.pm.UserInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.IUserManager;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.provider.Settings;
import android.util.Log;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class UserManager {
    public static final String DISALLOW_ADD_USER = "no_add_user";
    public static final String DISALLOW_ADJUST_VOLUME = "no_adjust_volume";
    public static final String DISALLOW_APPS_CONTROL = "no_control_apps";
    public static final String DISALLOW_CONFIG_BLUETOOTH = "no_config_bluetooth";
    public static final String DISALLOW_CONFIG_CELL_BROADCASTS = "no_config_cell_broadcasts";
    public static final String DISALLOW_CONFIG_CREDENTIALS = "no_config_credentials";
    public static final String DISALLOW_CONFIG_MOBILE_NETWORKS = "no_config_mobile_networks";
    public static final String DISALLOW_CONFIG_TETHERING = "no_config_tethering";
    public static final String DISALLOW_CONFIG_VPN = "no_config_vpn";
    public static final String DISALLOW_CONFIG_WIFI = "no_config_wifi";
    public static final String DISALLOW_CREATE_WINDOWS = "no_create_windows";
    public static final String DISALLOW_CROSS_PROFILE_COPY_PASTE = "no_cross_profile_copy_paste";
    public static final String DISALLOW_DEBUGGING_FEATURES = "no_debugging_features";
    public static final String DISALLOW_FACTORY_RESET = "no_factory_reset";
    public static final String DISALLOW_INSTALL_APPS = "no_install_apps";
    public static final String DISALLOW_INSTALL_UNKNOWN_SOURCES = "no_install_unknown_sources";
    public static final String DISALLOW_MODIFY_ACCOUNTS = "no_modify_accounts";
    public static final String DISALLOW_MOUNT_PHYSICAL_MEDIA = "no_physical_media";
    public static final String DISALLOW_OUTGOING_BEAM = "no_outgoing_beam";
    public static final String DISALLOW_OUTGOING_CALLS = "no_outgoing_calls";
    public static final String DISALLOW_REMOVE_USER = "no_remove_user";
    public static final String DISALLOW_SHARE_LOCATION = "no_share_location";
    public static final String DISALLOW_SMS = "no_sms";
    public static final String DISALLOW_UNINSTALL_APPS = "no_uninstall_apps";
    public static final String DISALLOW_UNMUTE_MICROPHONE = "no_unmute_microphone";
    public static final String DISALLOW_USB_FILE_TRANSFER = "no_usb_file_transfer";
    public static final String ENSURE_VERIFY_APPS = "ensure_verify_apps";
    public static final int PIN_VERIFICATION_FAILED_INCORRECT = -3;
    public static final int PIN_VERIFICATION_FAILED_NOT_SET = -2;
    public static final int PIN_VERIFICATION_SUCCESS = -1;
    private static final long RAM_1G = 0x40000000L;
    private static String TAG = "UserManager";
    private static UserManager sInstance = null;
    private final Context mContext;
    private final IUserManager mService;

    public UserManager(Context context, IUserManager iUserManager) {
        this.mService = iUserManager;
        this.mContext = context;
    }

    private static void addDefaultUserRestrictions(Bundle bundle) {
        bundle.putBoolean(DISALLOW_OUTGOING_CALLS, true);
        bundle.putBoolean(DISALLOW_SMS, true);
    }

    public static UserManager get(Context context) {
        synchronized (UserManager.class) {
            if (sInstance == null) {
                sInstance = (UserManager)context.getSystemService("user");
            }
            UserManager userManager = sInstance;
            return userManager;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getMaxSupportedUsers() {
        int n;
        int n2;
        block6: {
            if (Build.ID.startsWith("JVP")) {
                return 1;
            }
            if (ActivityManager.isLowRamDeviceStatic()) {
                return 0;
            }
            try {
                int n3;
                if (!UserManager.isSmallRam()) break block6;
                n2 = n3 = Resources.getSystem().getInteger(17694831);
            }
            catch (Resources.NotFoundException notFoundException) {
                n2 = Resources.getSystem().getInteger(17694830);
                return SystemProperties.getInt("fw.max_users", n2);
            }
            return SystemProperties.getInt("fw.max_users", n2);
        }
        n2 = n = Resources.getSystem().getInteger(17694830);
        return SystemProperties.getInt("fw.max_users", n2);
    }

    private static boolean isSmallRam() {
        return Process.getTotalMemory() <= 0x40000000L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean supportsMultipleUsers() {
        boolean bl;
        boolean bl2;
        block4: {
            try {
                boolean bl3;
                if (!UserManager.isSmallRam()) break block4;
                bl2 = bl3 = Resources.getSystem().getBoolean(17956958);
            }
            catch (Resources.NotFoundException notFoundException) {
                bl2 = Resources.getSystem().getBoolean(17956957);
                return UserManager.getMaxSupportedUsers() > 1 && SystemProperties.getBoolean("fw.show_multiuserui", bl2);
            }
            return UserManager.getMaxSupportedUsers() > 1 && SystemProperties.getBoolean("fw.show_multiuserui", bl2);
        }
        bl2 = bl = Resources.getSystem().getBoolean(17956957);
        return UserManager.getMaxSupportedUsers() > 1 && SystemProperties.getBoolean("fw.show_multiuserui", bl2);
    }

    public boolean canAddMoreUsers() {
        List<UserInfo> list = this.getUsers(true);
        int n = list.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (list.get(i).isGuest()) continue;
            ++n2;
        }
        return n2 < UserManager.getMaxSupportedUsers();
    }

    public boolean canAddSnapView() {
        List<UserInfo> list = this.getUsers(true);
        int n = list.size();
        int n2 = 0;
        while (true) {
            block4: {
                boolean bl;
                block3: {
                    bl = false;
                    if (n2 >= n) break block3;
                    if (!list.get(n2).isSnapView()) break block4;
                    bl = true;
                }
                return !bl;
            }
            ++n2;
        }
    }

    public int checkRestrictionsChallenge(String string2) {
        try {
            int n = this.mService.checkRestrictionsChallenge(string2);
            return n;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not check restrictions pin");
            return -3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public UserInfo createGuest(Context context, String string2) {
        UserInfo userInfo = this.createUser(string2, 4);
        if (userInfo == null) return userInfo;
        Settings.Secure.putStringForUser(context.getContentResolver(), "skip_first_use_hints", "1", userInfo.id);
        try {
            Bundle bundle = this.mService.getDefaultGuestRestrictions();
            bundle.putBoolean(DISALLOW_SMS, true);
            bundle.putBoolean(DISALLOW_INSTALL_UNKNOWN_SOURCES, true);
            this.mService.setUserRestrictions(bundle, userInfo.id);
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not update guest restrictions");
            return userInfo;
        }
        return userInfo;
    }

    public UserInfo createProfileForUser(String string2, int n, int n2) {
        try {
            UserInfo userInfo = this.mService.createProfileForUser(string2, n, n2);
            return userInfo;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not create a user", remoteException);
            return null;
        }
    }

    public UserInfo createSecondaryUser(String string2, int n) {
        UserInfo userInfo;
        block3: {
            try {
                userInfo = this.mService.createUser(string2, n);
                if (userInfo != null) break block3;
                return null;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Could not create a user", remoteException);
                return null;
            }
        }
        Bundle bundle = this.mService.getUserRestrictions(userInfo.id);
        UserManager.addDefaultUserRestrictions(bundle);
        this.mService.setUserRestrictions(bundle, userInfo.id);
        return userInfo;
    }

    public UserInfo createUser(String string2, int n) {
        try {
            UserInfo userInfo = this.mService.createUser(string2, n);
            return userInfo;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not create a user", remoteException);
            return null;
        }
    }

    public Bundle getApplicationRestrictions(String string2) {
        try {
            Bundle bundle = this.mService.getApplicationRestrictions(string2);
            return bundle;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not get application restrictions for package " + string2);
            return null;
        }
    }

    public Bundle getApplicationRestrictions(String string2, UserHandle userHandle) {
        try {
            Bundle bundle = this.mService.getApplicationRestrictionsForUser(string2, userHandle.getIdentifier());
            return bundle;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not get application restrictions for user " + userHandle.getIdentifier());
            return null;
        }
    }

    public Drawable getBadgedDrawableForUser(Drawable drawable2, UserHandle userHandle, Rect rect, int n) {
        return this.mContext.getPackageManager().getUserBadgedDrawableForDensity(drawable2, userHandle, rect, n);
    }

    public Drawable getBadgedIconForUser(Drawable drawable2, UserHandle userHandle) {
        return this.mContext.getPackageManager().getUserBadgedIcon(drawable2, userHandle);
    }

    public CharSequence getBadgedLabelForUser(CharSequence charSequence, UserHandle userHandle) {
        return this.mContext.getPackageManager().getUserBadgedLabel(charSequence, userHandle);
    }

    public Bundle getDefaultGuestRestrictions() {
        try {
            Bundle bundle = this.mService.getDefaultGuestRestrictions();
            return bundle;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not set guest restrictions");
            return new Bundle();
        }
    }

    public UserInfo getProfileParent(int n) {
        try {
            UserInfo userInfo = this.mService.getProfileParent(n);
            return userInfo;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not get profile parent", remoteException);
            return null;
        }
    }

    public List<UserInfo> getProfiles(int n) {
        try {
            List<UserInfo> list = this.mService.getProfiles(n, false);
            return list;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not get user list", remoteException);
            return null;
        }
    }

    public long getSerialNumberForUser(UserHandle userHandle) {
        return this.getUserSerialNumber(userHandle.getIdentifier());
    }

    public int getUserCount() {
        List<UserInfo> list = this.getUsers();
        if (list != null) {
            return list.size();
        }
        return 1;
    }

    public UserHandle getUserForSerialNumber(long l) {
        int n = this.getUserHandle((int)l);
        if (n >= 0) {
            return new UserHandle(n);
        }
        return null;
    }

    public int getUserHandle() {
        return UserHandle.myUserId();
    }

    public int getUserHandle(int n) {
        try {
            int n2 = this.mService.getUserHandle(n);
            return n2;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not get userHandle for user " + n);
            return -1;
        }
    }

    public Bitmap getUserIcon(int n) {
        try {
            Bitmap bitmap = this.mService.getUserIcon(n);
            return bitmap;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not get the user icon ", remoteException);
            return null;
        }
    }

    public UserInfo getUserInfo(int n) {
        try {
            UserInfo userInfo = this.mService.getUserInfo(n);
            return userInfo;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not get user info", remoteException);
            return null;
        }
    }

    public String getUserName() {
        try {
            String string2 = this.mService.getUserInfo((int)this.getUserHandle()).name;
            return string2;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not get user name", remoteException);
            return "";
        }
    }

    public List<UserHandle> getUserProfiles() {
        Iterator<UserInfo> iterator;
        ArrayList<UserHandle> arrayList = new ArrayList<UserHandle>();
        new ArrayList();
        try {
            List<UserInfo> list = this.mService.getProfiles(UserHandle.myUserId(), true);
            iterator = list.iterator();
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not get user list", remoteException);
            arrayList = null;
        }
        while (iterator.hasNext()) {
            arrayList.add(new UserHandle(iterator.next().id));
        }
        return arrayList;
    }

    public Bundle getUserRestrictions() {
        return this.getUserRestrictions(Process.myUserHandle());
    }

    public Bundle getUserRestrictions(UserHandle userHandle) {
        try {
            Bundle bundle = this.mService.getUserRestrictions(userHandle.getIdentifier());
            return bundle;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not get user restrictions", remoteException);
            return Bundle.EMPTY;
        }
    }

    public int getUserSerialNumber(int n) {
        try {
            int n2 = this.mService.getUserSerialNumber(n);
            return n2;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not get serial number for user " + n);
            return -1;
        }
    }

    public List<UserInfo> getUsers() {
        try {
            List<UserInfo> list = this.mService.getUsers(false);
            return list;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not get user list", remoteException);
            return null;
        }
    }

    public List<UserInfo> getUsers(boolean bl) {
        try {
            List<UserInfo> list = this.mService.getUsers(bl);
            return list;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not get user list", remoteException);
            return null;
        }
    }

    public boolean hasRestrictionsChallenge() {
        try {
            boolean bl = this.mService.hasRestrictionsChallenge();
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not change restrictions pin");
            return false;
        }
    }

    public boolean hasUserRestriction(String string2) {
        return this.hasUserRestriction(string2, Process.myUserHandle());
    }

    public boolean hasUserRestriction(String string2, UserHandle userHandle) {
        try {
            boolean bl = this.mService.hasUserRestriction(string2, userHandle.getIdentifier());
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not check user restrictions", remoteException);
            return false;
        }
    }

    public boolean isGuestUser() {
        UserInfo userInfo = this.getUserInfo(UserHandle.myUserId());
        if (userInfo != null) {
            return userInfo.isGuest();
        }
        return false;
    }

    public boolean isLinkedUser() {
        try {
            boolean bl = this.mService.isRestricted();
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not check if user is limited ", remoteException);
            return false;
        }
    }

    public boolean isManagedProfile() {
        UserInfo userInfo = this.getUserInfo(UserHandle.myUserId());
        if (userInfo != null) {
            return userInfo.isManagedProfile();
        }
        return false;
    }

    public boolean isUserAGoat() {
        return this.mContext.getPackageManager().isPackageAvailable("com.coffeestainstudios.goatsimulator");
    }

    public boolean isUserRunning(UserHandle userHandle) {
        try {
            boolean bl = ActivityManagerNative.getDefault().isUserRunning(userHandle.getIdentifier(), false);
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean isUserRunningOrStopping(UserHandle userHandle) {
        try {
            boolean bl = ActivityManagerNative.getDefault().isUserRunning(userHandle.getIdentifier(), true);
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isUserSwitcherEnabled() {
        block4: {
            block3: {
                List<UserInfo> list = this.getUsers(true);
                if (list == null) break block3;
                int n = 0;
                Iterator<UserInfo> iterator = list.iterator();
                while (iterator.hasNext()) {
                    if (!iterator.next().supportsSwitchTo()) continue;
                    ++n;
                }
                boolean bl = Settings.Global.getInt(this.mContext.getContentResolver(), "guest_user_enabled", 0) == 1;
                if (n > 1 || bl) break block4;
            }
            return false;
        }
        return true;
    }

    public boolean markGuestForDeletion(int n) {
        try {
            boolean bl = this.mService.markGuestForDeletion(n);
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not mark guest for deletion", remoteException);
            return false;
        }
    }

    public void removeRestrictions() {
        try {
            this.mService.removeRestrictions();
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not change restrictions pin");
            return;
        }
    }

    public boolean removeUser(int n) {
        try {
            boolean bl = this.mService.removeUser(n);
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not remove user ", remoteException);
            return false;
        }
    }

    public void setApplicationRestrictions(String string2, Bundle bundle, UserHandle userHandle) {
        try {
            this.mService.setApplicationRestrictions(string2, bundle, userHandle.getIdentifier());
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not set application restrictions for user " + userHandle.getIdentifier());
            return;
        }
    }

    public void setDefaultGuestRestrictions(Bundle bundle) {
        try {
            this.mService.setDefaultGuestRestrictions(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not set guest restrictions");
            return;
        }
    }

    public boolean setRestrictionsChallenge(String string2) {
        try {
            boolean bl = this.mService.setRestrictionsChallenge(string2);
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not change restrictions pin");
            return false;
        }
    }

    public void setUserDisabled(int n) {
        try {
            this.mService.setUserDisabled(n);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not disable the profile", remoteException);
            return;
        }
    }

    public void setUserEnabled(int n) {
        try {
            this.mService.setUserEnabled(n);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not enable the profile", remoteException);
            return;
        }
    }

    public void setUserIcon(int n, Bitmap bitmap) {
        try {
            this.mService.setUserIcon(n, bitmap);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not set the user icon ", remoteException);
            return;
        }
    }

    public void setUserName(int n, String string2) {
        try {
            this.mService.setUserName(n, string2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not set the user name ", remoteException);
            return;
        }
    }

    @Deprecated
    public void setUserRestriction(String string2, boolean bl) {
        Bundle bundle = this.getUserRestrictions();
        bundle.putBoolean(string2, bl);
        this.setUserRestrictions(bundle);
    }

    @Deprecated
    public void setUserRestriction(String string2, boolean bl, UserHandle userHandle) {
        Bundle bundle = this.getUserRestrictions(userHandle);
        bundle.putBoolean(string2, bl);
        this.setUserRestrictions(bundle, userHandle);
    }

    @Deprecated
    public void setUserRestrictions(Bundle bundle) {
        this.setUserRestrictions(bundle, Process.myUserHandle());
    }

    @Deprecated
    public void setUserRestrictions(Bundle bundle, UserHandle userHandle) {
        try {
            this.mService.setUserRestrictions(bundle, userHandle.getIdentifier());
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not set user restrictions", remoteException);
            return;
        }
    }
}

