/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import com.android.internal.R;

public class PreferenceFrameLayout
extends FrameLayout {
    private static final int DEFAULT_BORDER_BOTTOM;
    private static final int DEFAULT_BORDER_LEFT;
    private static final int DEFAULT_BORDER_RIGHT;
    private static final int DEFAULT_BORDER_TOP;
    private final int mBorderBottom;
    private final int mBorderLeft;
    private final int mBorderRight;
    private final int mBorderTop;
    private boolean mPaddingApplied;

    public PreferenceFrameLayout(Context context) {
        this(context, null);
    }

    public PreferenceFrameLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16844042);
    }

    public PreferenceFrameLayout(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public PreferenceFrameLayout(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.PreferenceFrameLayout, n, n2);
        float f = context.getResources().getDisplayMetrics().density;
        int n3 = (int)(0.5f + f * 0.0f);
        int n4 = (int)(0.5f + f * 0.0f);
        int n5 = (int)(0.5f + f * 0.0f);
        int n6 = (int)(0.5f + f * 0.0f);
        this.mBorderTop = typedArray.getDimensionPixelSize(0, n3);
        this.mBorderBottom = typedArray.getDimensionPixelSize(1, n4);
        this.mBorderLeft = typedArray.getDimensionPixelSize(2, n5);
        this.mBorderRight = typedArray.getDimensionPixelSize(3, n6);
        typedArray.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void addView(View view) {
        int n = this.getPaddingTop();
        int n2 = this.getPaddingBottom();
        int n3 = this.getPaddingLeft();
        int n4 = this.getPaddingRight();
        LayoutParams layoutParams = view.getLayoutParams() instanceof LayoutParams ? (LayoutParams)view.getLayoutParams() : null;
        if (layoutParams != null && layoutParams.removeBorders) {
            if (this.mPaddingApplied) {
                n -= this.mBorderTop;
                n2 -= this.mBorderBottom;
                n3 -= this.mBorderLeft;
                n4 -= this.mBorderRight;
                this.mPaddingApplied = false;
            }
        } else if (!this.mPaddingApplied) {
            n += this.mBorderTop;
            n2 += this.mBorderBottom;
            n3 += this.mBorderLeft;
            n4 += this.mBorderRight;
            this.mPaddingApplied = true;
        }
        int n5 = this.getPaddingTop();
        int n6 = this.getPaddingBottom();
        int n7 = this.getPaddingLeft();
        int n8 = this.getPaddingRight();
        if (n5 != n || n6 != n2 || n7 != n3 || n8 != n4) {
            this.setPadding(n3, n, n4, n2);
        }
        super.addView(view);
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    public static class LayoutParams
    extends FrameLayout.LayoutParams {
        public boolean removeBorders = false;

        public LayoutParams(int n, int n2) {
            super(n, n2);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.PreferenceFrameLayout_Layout);
            this.removeBorders = typedArray.getBoolean(0, false);
            typedArray.recycle();
        }
    }
}

