/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.media.RingtoneManager;
import android.net.Uri;
import android.preference.Preference;
import android.preference.PreferenceFragment;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.AttributeSet;
import com.android.internal.R;

public class RingtonePreference
extends Preference
implements PreferenceManager.OnActivityResultListener {
    private static final String TAG = "RingtonePreference";
    private int mRequestCode;
    private int mRingtoneType;
    private boolean mShowDefault;
    private boolean mShowSilent;

    public RingtonePreference(Context context) {
        this(context, null);
    }

    public RingtonePreference(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842899);
    }

    public RingtonePreference(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public RingtonePreference(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.RingtonePreference, n, n2);
        this.mRingtoneType = typedArray.getInt(0, 1);
        this.mShowDefault = typedArray.getBoolean(1, true);
        this.mShowSilent = typedArray.getBoolean(2, true);
        typedArray.recycle();
    }

    public int getRingtoneType() {
        return this.mRingtoneType;
    }

    public boolean getShowDefault() {
        return this.mShowDefault;
    }

    public boolean getShowSilent() {
        return this.mShowSilent;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onActivityResult(int n, int n2, Intent intent) {
        Uri uri;
        String string2;
        if (n != this.mRequestCode) {
            return false;
        }
        if (intent != null && this.callChangeListener(string2 = (uri = (Uri)intent.getParcelableExtra("android.intent.extra.ringtone.PICKED_URI")) != null ? uri.toString() : "")) {
            this.onSaveRingtone(uri);
        }
        return true;
    }

    @Override
    protected void onAttachedToHierarchy(PreferenceManager preferenceManager) {
        super.onAttachedToHierarchy(preferenceManager);
        preferenceManager.registerOnActivityResultListener(this);
        this.mRequestCode = preferenceManager.getNextRequestCode();
    }

    @Override
    protected void onClick() {
        Intent intent = new Intent("android.intent.action.RINGTONE_PICKER");
        this.onPrepareRingtonePickerIntent(intent);
        PreferenceFragment preferenceFragment = this.getPreferenceManager().getFragment();
        if (preferenceFragment != null) {
            preferenceFragment.startActivityForResult(intent, this.mRequestCode);
            return;
        }
        this.getPreferenceManager().getActivity().startActivityForResult(intent, this.mRequestCode);
    }

    @Override
    protected Object onGetDefaultValue(TypedArray typedArray, int n) {
        return typedArray.getString(n);
    }

    protected void onPrepareRingtonePickerIntent(Intent intent) {
        intent.putExtra("android.intent.extra.ringtone.EXISTING_URI", this.onRestoreRingtone());
        intent.putExtra("android.intent.extra.ringtone.SHOW_DEFAULT", this.mShowDefault);
        if (this.mShowDefault) {
            intent.putExtra("android.intent.extra.ringtone.DEFAULT_URI", RingtoneManager.getDefaultUri(this.getRingtoneType()));
        }
        intent.putExtra("android.intent.extra.ringtone.SHOW_SILENT", this.mShowSilent);
        intent.putExtra("android.intent.extra.ringtone.TYPE", this.mRingtoneType);
        intent.putExtra("android.intent.extra.ringtone.TITLE", this.getTitle());
    }

    protected Uri onRestoreRingtone() {
        String string2 = this.getPersistedString(null);
        boolean bl = TextUtils.isEmpty(string2);
        Uri uri = null;
        if (!bl) {
            uri = Uri.parse(string2);
        }
        return uri;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onSaveRingtone(Uri uri) {
        String string2 = uri != null ? uri.toString() : "";
        this.persistString(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onSetInitialValue(boolean bl, Object object) {
        String string2 = (String)object;
        if (bl || TextUtils.isEmpty(string2)) {
            return;
        }
        this.onSaveRingtone(Uri.parse(string2));
    }

    public void setRingtoneType(int n) {
        this.mRingtoneType = n;
    }

    public void setShowDefault(boolean bl) {
        this.mShowDefault = bl;
    }

    public void setShowSilent(boolean bl) {
        this.mShowSilent = bl;
    }
}

