/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.media.AudioManager;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.preference.VolumePreference;
import android.provider.Settings;
import android.util.Log;
import android.widget.SeekBar;

public class SeekBarVolumizer
implements SeekBar.OnSeekBarChangeListener,
Handler.Callback {
    private static final int CHECK_RINGTONE_PLAYBACK_DELAY_MS = 1000;
    private static final int MSG_INIT_SAMPLE = 3;
    private static final int MSG_SET_STREAM_VOLUME = 0;
    private static final int MSG_START_SAMPLE = 1;
    private static final int MSG_STOP_SAMPLE = 2;
    private static final String TAG = "SeekBarVolumizer";
    private final AudioManager mAudioManager;
    private final Callback mCallback;
    private final Context mContext;
    private final Uri mDefaultUri;
    private final Handler mHandler;
    private int mLastProgress = -1;
    private final int mMaxStreamVolume;
    private int mOriginalStreamVolume;
    private final Receiver mReceiver;
    private Ringtone mRingtone;
    private SeekBar mSeekBar;
    private final int mStreamType;
    private final H mUiHandler = new H();
    private int mVolumeBeforeMute = -1;
    private final Observer mVolumeObserver;

    /*
     * Enabled aggressive block sorting
     */
    public SeekBarVolumizer(Context context, int n, Uri uri, Callback callback) {
        this.mReceiver = new Receiver();
        this.mContext = context;
        this.mAudioManager = (AudioManager)context.getSystemService("audio");
        this.mStreamType = n;
        this.mMaxStreamVolume = this.mAudioManager.getStreamMaxVolume(this.mStreamType);
        HandlerThread handlerThread = new HandlerThread("SeekBarVolumizer.CallbackHandler");
        handlerThread.start();
        this.mHandler = new Handler(handlerThread.getLooper(), this);
        this.mCallback = callback;
        this.mOriginalStreamVolume = this.mAudioManager.getStreamVolume(this.mStreamType);
        this.mVolumeObserver = new Observer(this.mHandler);
        this.mContext.getContentResolver().registerContentObserver(Settings.System.getUriFor(Settings.System.VOLUME_SETTINGS[this.mStreamType]), false, this.mVolumeObserver);
        this.mReceiver.setListening(true);
        if (uri == null) {
            uri = this.mStreamType == 2 ? Settings.System.DEFAULT_RINGTONE_URI : (this.mStreamType == 5 ? Settings.System.DEFAULT_NOTIFICATION_URI : Settings.System.DEFAULT_ALARM_ALERT_URI);
        }
        this.mDefaultUri = uri;
        this.mHandler.sendEmptyMessage(3);
    }

    static /* synthetic */ int access$302(SeekBarVolumizer seekBarVolumizer, int n) {
        seekBarVolumizer.mLastProgress = n;
        return n;
    }

    private void onInitSample() {
        this.mRingtone = RingtoneManager.getRingtone(this.mContext, this.mDefaultUri);
        if (this.mRingtone != null) {
            this.mRingtone.setStreamType(this.mStreamType);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void onStartSample() {
        if (this.isSamplePlaying()) return;
        if (this.mCallback != null) {
            this.mCallback.onSampleStarting(this);
        }
        if (this.mRingtone == null) return;
        try {
            this.mRingtone.play();
            return;
        }
        catch (Throwable throwable) {
            Log.w(TAG, "Error playing ringtone, stream " + this.mStreamType, throwable);
            return;
        }
    }

    private void onStopSample() {
        if (this.mRingtone != null) {
            this.mRingtone.stop();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void postStartSample() {
        this.mHandler.removeMessages(1);
        Handler handler = this.mHandler;
        Message message = this.mHandler.obtainMessage(1);
        long l = this.isSamplePlaying() ? 1000L : 0L;
        handler.sendMessageDelayed(message, l);
    }

    public void changeVolumeBy(int n) {
        this.mSeekBar.incrementProgressBy(n);
        this.postSetVolume(this.mSeekBar.getProgress());
        this.postStartSample();
        this.mVolumeBeforeMute = -1;
    }

    public SeekBar getSeekBar() {
        return this.mSeekBar;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean handleMessage(Message message) {
        switch (message.what) {
            default: {
                Log.e(TAG, "invalid SeekBarVolumizer message: " + message.what);
                return true;
            }
            case 0: {
                this.mAudioManager.setStreamVolume(this.mStreamType, this.mLastProgress, 1024);
                return true;
            }
            case 1: {
                this.onStartSample();
                return true;
            }
            case 2: {
                this.onStopSample();
                return true;
            }
            case 3: 
        }
        this.onInitSample();
        return true;
    }

    public boolean isSamplePlaying() {
        return this.mRingtone != null && this.mRingtone.isPlaying();
    }

    public void muteVolume() {
        if (this.mVolumeBeforeMute != -1) {
            this.mSeekBar.setProgress(this.mVolumeBeforeMute);
            this.postSetVolume(this.mVolumeBeforeMute);
            this.postStartSample();
            this.mVolumeBeforeMute = -1;
            return;
        }
        this.mVolumeBeforeMute = this.mSeekBar.getProgress();
        this.mSeekBar.setProgress(0);
        this.postStopSample();
        this.postSetVolume(0);
    }

    @Override
    public void onProgressChanged(SeekBar seekBar, int n, boolean bl) {
        if (!bl) {
            return;
        }
        this.postSetVolume(n);
    }

    public void onRestoreInstanceState(VolumePreference.VolumeStore volumeStore) {
        if (volumeStore.volume != -1) {
            this.mOriginalStreamVolume = volumeStore.originalVolume;
            this.mLastProgress = volumeStore.volume;
            this.postSetVolume(this.mLastProgress);
        }
    }

    public void onSaveInstanceState(VolumePreference.VolumeStore volumeStore) {
        if (this.mLastProgress >= 0) {
            volumeStore.volume = this.mLastProgress;
            volumeStore.originalVolume = this.mOriginalStreamVolume;
        }
    }

    @Override
    public void onStartTrackingTouch(SeekBar seekBar) {
    }

    @Override
    public void onStopTrackingTouch(SeekBar seekBar) {
        this.postStartSample();
    }

    void postSetVolume(int n) {
        this.mLastProgress = n;
        this.mHandler.removeMessages(0);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(0));
    }

    void postStopSample() {
        this.mHandler.removeMessages(1);
        this.mHandler.removeMessages(2);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2));
    }

    public void revertVolume() {
        this.mAudioManager.setStreamVolume(this.mStreamType, this.mOriginalStreamVolume, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setSeekBar(SeekBar seekBar) {
        if (this.mSeekBar != null) {
            this.mSeekBar.setOnSeekBarChangeListener(null);
        }
        this.mSeekBar = seekBar;
        this.mSeekBar.setOnSeekBarChangeListener(null);
        this.mSeekBar.setMax(this.mMaxStreamVolume);
        SeekBar seekBar2 = this.mSeekBar;
        int n = this.mLastProgress > -1 ? this.mLastProgress : this.mOriginalStreamVolume;
        seekBar2.setProgress(n);
        this.mSeekBar.setOnSeekBarChangeListener(this);
        if (!this.mReceiver.getListening()) {
            this.mReceiver.setListening(true);
        }
    }

    public void startSample() {
        this.postStartSample();
    }

    public void stop() {
        this.postStopSample();
        this.mContext.getContentResolver().unregisterContentObserver(this.mVolumeObserver);
        this.mSeekBar.setOnSeekBarChangeListener(null);
        this.mReceiver.setListening(false);
    }

    public void stopSample() {
        this.postStopSample();
    }

    public static interface Callback {
        public void onRingerModeChanged();

        public void onSampleStarting(SeekBarVolumizer var1);
    }

    private final class H
    extends Handler {
        private static final int UPDATE_SLIDER = 1;

        private H() {
        }

        @Override
        public void handleMessage(Message message) {
            if (message.what == 1 && SeekBarVolumizer.this.mSeekBar != null) {
                SeekBarVolumizer.this.mSeekBar.setProgress(message.arg1);
                SeekBarVolumizer.access$302(SeekBarVolumizer.this, SeekBarVolumizer.this.mSeekBar.getProgress());
            }
        }

        public void postUpdateSlider(int n) {
            this.obtainMessage(1, n, 0).sendToTarget();
        }
    }

    private final class Observer
    extends ContentObserver {
        public Observer(Handler handler) {
            super(handler);
        }

        @Override
        public void onChange(boolean bl) {
            super.onChange(bl);
            if (SeekBarVolumizer.this.mSeekBar != null && SeekBarVolumizer.this.mAudioManager != null) {
                int n = SeekBarVolumizer.this.mAudioManager.getStreamVolume(SeekBarVolumizer.this.mStreamType);
                SeekBarVolumizer.this.mUiHandler.postUpdateSlider(n);
            }
        }
    }

    private final class Receiver
    extends BroadcastReceiver {
        private boolean mListening;

        private Receiver() {
        }

        public boolean getListening() {
            return this.mListening;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            if ("android.media.VOLUME_CHANGED_ACTION".equals(intent.getAction())) {
                int n = intent.getIntExtra("android.media.EXTRA_VOLUME_STREAM_TYPE", -1);
                int n2 = intent.getIntExtra("android.media.EXTRA_VOLUME_STREAM_VALUE", -1);
                if (SeekBarVolumizer.this.mSeekBar == null || n != SeekBarVolumizer.this.mStreamType || n2 == -1) return;
                SeekBarVolumizer.this.mUiHandler.postUpdateSlider(n2);
                return;
            }
            if (!"android.media.RINGER_MODE_CHANGED".equals(intent.getAction())) return;
            SeekBarVolumizer.this.mCallback.onRingerModeChanged();
        }

        public void setListening(boolean bl) {
            if (this.mListening == bl) {
                return;
            }
            this.mListening = bl;
            if (bl) {
                IntentFilter intentFilter = new IntentFilter("android.media.VOLUME_CHANGED_ACTION");
                IntentFilter intentFilter2 = new IntentFilter("android.media.RINGER_MODE_CHANGED");
                SeekBarVolumizer.this.mContext.registerReceiver(this, intentFilter);
                SeekBarVolumizer.this.mContext.registerReceiver(this, intentFilter2);
                return;
            }
            SeekBarVolumizer.this.mContext.unregisterReceiver(this);
        }
    }
}

