/*
 * Decompiled with CFR 0.152.
 */
package android.printservice;

import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.print.PrintDocumentInfo;
import android.print.PrintJobId;
import android.printservice.IPrintServiceClient;
import android.printservice.PrintService;
import android.util.Log;
import java.io.IOException;

public final class PrintDocument {
    private static final String LOG_TAG = "PrintDocument";
    private final PrintDocumentInfo mInfo;
    private final PrintJobId mPrintJobId;
    private final IPrintServiceClient mPrintServiceClient;

    PrintDocument(PrintJobId printJobId, IPrintServiceClient iPrintServiceClient, PrintDocumentInfo printDocumentInfo) {
        this.mPrintJobId = printJobId;
        this.mPrintServiceClient = iPrintServiceClient;
        this.mInfo = printDocumentInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ParcelFileDescriptor getData() {
        PrintService.throwIfNotCalledOnMainThread();
        ParcelFileDescriptor parcelFileDescriptor = null;
        try {
            ParcelFileDescriptor[] parcelFileDescriptorArray = ParcelFileDescriptor.createPipe();
            ParcelFileDescriptor parcelFileDescriptor2 = parcelFileDescriptorArray[0];
            parcelFileDescriptor = parcelFileDescriptorArray[1];
            this.mPrintServiceClient.writePrintJobData(parcelFileDescriptor, this.mPrintJobId);
            return parcelFileDescriptor2;
        }
        catch (IOException iOException) {
            Log.e(LOG_TAG, "Error calling getting print job data!", iOException);
            return null;
        }
        catch (RemoteException remoteException) {
            Log.e(LOG_TAG, "Error calling getting print job data!", remoteException);
            return null;
        }
        finally {
            if (parcelFileDescriptor == null) return null;
            parcelFileDescriptor.close();
            return null;
        }
    }

    public PrintDocumentInfo getInfo() {
        PrintService.throwIfNotCalledOnMainThread();
        return this.mInfo;
    }
}

