/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.FieldPacker;
import android.renderscript.Float4;
import android.renderscript.Program;
import android.renderscript.ProgramFragment;
import android.renderscript.RenderScript;
import android.renderscript.Type;

public class ProgramFragmentFixedFunction
extends ProgramFragment {
    ProgramFragmentFixedFunction(long l, RenderScript renderScript) {
        super(l, renderScript);
    }

    public static class Builder {
        public static final int MAX_TEXTURE = 2;
        int mNumTextures;
        boolean mPointSpriteEnable;
        RenderScript mRS;
        String mShader;
        Slot[] mSlots;
        boolean mVaryingColorEnable;

        public Builder(RenderScript renderScript) {
            this.mRS = renderScript;
            this.mSlots = new Slot[2];
            this.mPointSpriteEnable = false;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void buildShaderString() {
            this.mShader = "//rs_shader_internal\n";
            this.mShader = this.mShader + "varying lowp vec4 varColor;\n";
            this.mShader = this.mShader + "varying vec2 varTex0;\n";
            this.mShader = this.mShader + "void main() {\n";
            this.mShader = this.mVaryingColorEnable ? this.mShader + "  lowp vec4 col = varColor;\n" : this.mShader + "  lowp vec4 col = UNI_Color;\n";
            if (this.mNumTextures != 0) {
                this.mShader = this.mPointSpriteEnable ? this.mShader + "  vec2 t0 = gl_PointCoord;\n" : this.mShader + "  vec2 t0 = varTex0.xy;\n";
            }
            int n = 0;
            while (true) {
                if (n >= this.mNumTextures) {
                    this.mShader = this.mShader + "  gl_FragColor = col;\n";
                    this.mShader = this.mShader + "}\n";
                    return;
                }
                block0 : switch (this.mSlots[n].env) {
                    case REPLACE: {
                        switch (1.$SwitchMap$android$renderscript$ProgramFragmentFixedFunction$Builder$Format[this.mSlots[n].format.ordinal()]) {
                            default: {
                                break block0;
                            }
                            case 1: {
                                this.mShader = this.mShader + "  col.a = texture2D(UNI_Tex0, t0).a;\n";
                                break block0;
                            }
                            case 2: {
                                this.mShader = this.mShader + "  col.rgba = texture2D(UNI_Tex0, t0).rgba;\n";
                                break block0;
                            }
                            case 3: {
                                this.mShader = this.mShader + "  col.rgb = texture2D(UNI_Tex0, t0).rgb;\n";
                                break block0;
                            }
                            case 4: 
                        }
                        this.mShader = this.mShader + "  col.rgba = texture2D(UNI_Tex0, t0).rgba;\n";
                        break;
                    }
                    case MODULATE: {
                        switch (1.$SwitchMap$android$renderscript$ProgramFragmentFixedFunction$Builder$Format[this.mSlots[n].format.ordinal()]) {
                            default: {
                                break block0;
                            }
                            case 1: {
                                this.mShader = this.mShader + "  col.a *= texture2D(UNI_Tex0, t0).a;\n";
                                break block0;
                            }
                            case 2: {
                                this.mShader = this.mShader + "  col.rgba *= texture2D(UNI_Tex0, t0).rgba;\n";
                                break block0;
                            }
                            case 3: {
                                this.mShader = this.mShader + "  col.rgb *= texture2D(UNI_Tex0, t0).rgb;\n";
                                break block0;
                            }
                            case 4: 
                        }
                        this.mShader = this.mShader + "  col.rgba *= texture2D(UNI_Tex0, t0).rgba;\n";
                        break;
                    }
                    case DECAL: {
                        this.mShader = this.mShader + "  col = texture2D(UNI_Tex0, t0);\n";
                        break;
                    }
                }
                ++n;
            }
        }

        public ProgramFragmentFixedFunction create() {
            InternalBuilder internalBuilder = new InternalBuilder(this.mRS);
            this.mNumTextures = 0;
            for (int i = 0; i < 2; ++i) {
                if (this.mSlots[i] == null) continue;
                this.mNumTextures = 1 + this.mNumTextures;
            }
            this.buildShaderString();
            internalBuilder.setShader(this.mShader);
            boolean bl = this.mVaryingColorEnable;
            Type type = null;
            if (!bl) {
                Element.Builder builder = new Element.Builder(this.mRS);
                builder.add(Element.F32_4(this.mRS), "Color");
                Type.Builder builder2 = new Type.Builder(this.mRS, builder.create());
                builder2.setX(1);
                type = builder2.create();
                internalBuilder.addConstant(type);
            }
            for (int i = 0; i < this.mNumTextures; ++i) {
                internalBuilder.addTexture(Program.TextureType.TEXTURE_2D);
            }
            ProgramFragmentFixedFunction programFragmentFixedFunction = internalBuilder.create();
            programFragmentFixedFunction.mTextureCount = 2;
            if (!this.mVaryingColorEnable) {
                Allocation allocation = Allocation.createTyped(this.mRS, type);
                FieldPacker fieldPacker = new FieldPacker(16);
                fieldPacker.addF32(new Float4(1.0f, 1.0f, 1.0f, 1.0f));
                allocation.setFromFieldPacker(0, fieldPacker);
                programFragmentFixedFunction.bindConstants(allocation, 0);
            }
            return programFragmentFixedFunction;
        }

        public Builder setPointSpriteTexCoordinateReplacement(boolean bl) {
            this.mPointSpriteEnable = bl;
            return this;
        }

        public Builder setTexture(EnvMode envMode, Format format, int n) throws IllegalArgumentException {
            if (n < 0 || n >= 2) {
                throw new IllegalArgumentException("MAX_TEXTURE exceeded.");
            }
            this.mSlots[n] = new Slot(envMode, format);
            return this;
        }

        public Builder setVaryingColor(boolean bl) {
            this.mVaryingColorEnable = bl;
            return this;
        }

        public static final class EnvMode
        extends Enum<EnvMode> {
            private static final /* synthetic */ EnvMode[] $VALUES;
            public static final /* enum */ EnvMode DECAL;
            public static final /* enum */ EnvMode MODULATE;
            public static final /* enum */ EnvMode REPLACE;
            int mID;

            static {
                REPLACE = new EnvMode(1);
                MODULATE = new EnvMode(2);
                DECAL = new EnvMode(3);
                EnvMode[] envModeArray = new EnvMode[]{REPLACE, MODULATE, DECAL};
                $VALUES = envModeArray;
            }

            private EnvMode(int n2) {
                this.mID = n2;
            }

            public static EnvMode valueOf(String string2) {
                return Enum.valueOf(EnvMode.class, string2);
            }

            public static EnvMode[] values() {
                return (EnvMode[])$VALUES.clone();
            }
        }

        public static final class Format
        extends Enum<Format> {
            private static final /* synthetic */ Format[] $VALUES;
            public static final /* enum */ Format ALPHA = new Format(1);
            public static final /* enum */ Format LUMINANCE_ALPHA = new Format(2);
            public static final /* enum */ Format RGB = new Format(3);
            public static final /* enum */ Format RGBA = new Format(4);
            int mID;

            static {
                Format[] formatArray = new Format[]{ALPHA, LUMINANCE_ALPHA, RGB, RGBA};
                $VALUES = formatArray;
            }

            private Format(int n2) {
                this.mID = n2;
            }

            public static Format valueOf(String string2) {
                return Enum.valueOf(Format.class, string2);
            }

            public static Format[] values() {
                return (Format[])$VALUES.clone();
            }
        }

        private class Slot {
            EnvMode env;
            Format format;

            Slot(EnvMode envMode, Format format) {
                this.env = envMode;
                this.format = format;
            }
        }
    }

    static class InternalBuilder
    extends Program.BaseProgramBuilder {
        public InternalBuilder(RenderScript renderScript) {
            super(renderScript);
        }

        public ProgramFragmentFixedFunction create() {
            this.mRS.validate();
            long[] lArray = new long[2 * (this.mInputCount + this.mOutputCount + this.mConstantCount + this.mTextureCount)];
            String[] stringArray = new String[this.mTextureCount];
            int n = 0;
            for (int i = 0; i < this.mInputCount; ++i) {
                int n2 = n + 1;
                lArray[n] = Program.ProgramParam.INPUT.mID;
                n = n2 + 1;
                lArray[n2] = this.mInputs[i].getID(this.mRS);
            }
            for (int i = 0; i < this.mOutputCount; ++i) {
                int n3 = n + 1;
                lArray[n] = Program.ProgramParam.OUTPUT.mID;
                n = n3 + 1;
                lArray[n3] = this.mOutputs[i].getID(this.mRS);
            }
            for (int i = 0; i < this.mConstantCount; ++i) {
                int n4 = n + 1;
                lArray[n] = Program.ProgramParam.CONSTANT.mID;
                n = n4 + 1;
                lArray[n4] = this.mConstants[i].getID(this.mRS);
            }
            for (int i = 0; i < this.mTextureCount; ++i) {
                int n5 = n + 1;
                lArray[n] = Program.ProgramParam.TEXTURE_TYPE.mID;
                n = n5 + 1;
                lArray[n5] = this.mTextureTypes[i].mID;
                stringArray[i] = this.mTextureNames[i];
            }
            ProgramFragmentFixedFunction programFragmentFixedFunction = new ProgramFragmentFixedFunction(this.mRS.nProgramFragmentCreate(this.mShader, stringArray, lArray), this.mRS);
            this.initProgram(programFragmentFixedFunction);
            return programFragmentFixedFunction;
        }
    }
}

