/*
 * Decompiled with CFR 0.152.
 */
package android.sax;

import android.sax.BadXmlException;
import android.sax.Children;
import android.sax.ElementListener;
import android.sax.EndElementListener;
import android.sax.EndTextElementListener;
import android.sax.StartElementListener;
import android.sax.TextElementListener;
import java.util.ArrayList;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

public class Element {
    Children children;
    final int depth;
    EndElementListener endElementListener;
    EndTextElementListener endTextElementListener;
    final String localName;
    final Element parent;
    ArrayList<Element> requiredChilden;
    StartElementListener startElementListener;
    final String uri;
    boolean visited;

    Element(Element element, String string2, String string3, int n) {
        this.parent = element;
        this.uri = string2;
        this.localName = string3;
        this.depth = n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String toString(String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder().append("'");
        if (string2.equals("")) {
            return stringBuilder.append(string3).append("'").toString();
        }
        string3 = string2 + ":" + string3;
        return stringBuilder.append(string3).append("'").toString();
    }

    void checkRequiredChildren(Locator locator) throws SAXParseException {
        ArrayList<Element> arrayList = this.requiredChilden;
        if (arrayList != null) {
            for (int i = -1 + arrayList.size(); i >= 0; --i) {
                Element element = arrayList.get(i);
                if (element.visited) continue;
                throw new BadXmlException("Element named " + this + " is missing required" + " child element named " + element + ".", locator);
            }
        }
    }

    public Element getChild(String string2) {
        return this.getChild("", string2);
    }

    public Element getChild(String string2, String string3) {
        if (this.endTextElementListener != null) {
            throw new IllegalStateException("This element already has an end text element listener. It cannot have children.");
        }
        if (this.children == null) {
            this.children = new Children();
        }
        return this.children.getOrCreate(this, string2, string3);
    }

    public Element requireChild(String string2) {
        return this.requireChild("", string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Element requireChild(String string2, String string3) {
        Element element = this.getChild(string2, string3);
        if (this.requiredChilden == null) {
            this.requiredChilden = new ArrayList();
            this.requiredChilden.add(element);
            return element;
        } else {
            if (this.requiredChilden.contains(element)) return element;
            this.requiredChilden.add(element);
            return element;
        }
    }

    void resetRequiredChildren() {
        ArrayList<Element> arrayList = this.requiredChilden;
        if (arrayList != null) {
            for (int i = -1 + arrayList.size(); i >= 0; --i) {
                arrayList.get((int)i).visited = false;
            }
        }
    }

    public void setElementListener(ElementListener elementListener) {
        this.setStartElementListener(elementListener);
        this.setEndElementListener(elementListener);
    }

    public void setEndElementListener(EndElementListener endElementListener) {
        if (this.endElementListener != null) {
            throw new IllegalStateException("End element listener has already been set.");
        }
        this.endElementListener = endElementListener;
    }

    public void setEndTextElementListener(EndTextElementListener endTextElementListener) {
        if (this.endTextElementListener != null) {
            throw new IllegalStateException("End text element listener has already been set.");
        }
        if (this.children != null) {
            throw new IllegalStateException("This element already has children. It cannot have an end text element listener.");
        }
        this.endTextElementListener = endTextElementListener;
    }

    public void setStartElementListener(StartElementListener startElementListener) {
        if (this.startElementListener != null) {
            throw new IllegalStateException("Start element listener has already been set.");
        }
        this.startElementListener = startElementListener;
    }

    public void setTextElementListener(TextElementListener textElementListener) {
        this.setStartElementListener(textElementListener);
        this.setEndTextElementListener(textElementListener);
    }

    public String toString() {
        return Element.toString(this.uri, this.localName);
    }
}

