/*
 * Decompiled with CFR 0.152.
 */
package android.security;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.Looper;
import android.os.Process;
import android.os.RemoteException;
import android.os.UserHandle;
import android.security.IKeyChainAliasCallback;
import android.security.IKeyChainService;
import android.security.KeyChainAliasCallback;
import android.security.KeyChainException;
import android.security.KeyStore;
import com.android.org.conscrypt.OpenSSLEngine;
import com.android.org.conscrypt.TrustedCertificateStore;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.security.InvalidKeyException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.LinkedBlockingQueue;

public final class KeyChain {
    public static final String ACCOUNT_TYPE = "com.android.keychain";
    private static final String ACTION_CHOOSER = "com.android.keychain.CHOOSER";
    private static final String ACTION_INSTALL = "android.credentials.INSTALL";
    public static final String ACTION_STORAGE_CHANGED = "android.security.STORAGE_CHANGED";
    private static final String CERT_INSTALLER_PACKAGE = "com.android.certinstaller";
    public static final String EXTRA_ALIAS = "alias";
    public static final String EXTRA_CERTIFICATE = "CERT";
    public static final String EXTRA_HOST = "host";
    public static final String EXTRA_NAME = "name";
    public static final String EXTRA_PKCS12 = "PKCS12";
    public static final String EXTRA_PORT = "port";
    public static final String EXTRA_RESPONSE = "response";
    public static final String EXTRA_SENDER = "sender";
    private static final String KEYCHAIN_PACKAGE = "com.android.keychain";
    private static final String TAG = "KeyChain";

    public static KeyChainConnection bind(Context context) throws InterruptedException {
        return KeyChain.bindAsUser(context, Process.myUserHandle());
    }

    public static KeyChainConnection bindAsUser(Context context, UserHandle userHandle) throws InterruptedException {
        if (context == null) {
            throw new NullPointerException("context == null");
        }
        KeyChain.ensureNotOnMainThread(context);
        final LinkedBlockingQueue linkedBlockingQueue = new LinkedBlockingQueue(1);
        ServiceConnection serviceConnection = new ServiceConnection(){
            volatile boolean mConnectedAtLeastOnce = false;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                if (this.mConnectedAtLeastOnce) return;
                this.mConnectedAtLeastOnce = true;
                try {
                    linkedBlockingQueue.put(IKeyChainService.Stub.asInterface(iBinder));
                    return;
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }

            @Override
            public void onServiceDisconnected(ComponentName componentName) {
            }
        };
        Intent intent = new Intent(IKeyChainService.class.getName());
        intent.setComponent(intent.resolveSystemService(context.getPackageManager(), 0));
        if (!context.bindServiceAsUser(intent, serviceConnection, 1, userHandle)) {
            throw new AssertionError((Object)"could not bind to KeyChainService");
        }
        return new KeyChainConnection(context, serviceConnection, (IKeyChainService)linkedBlockingQueue.take());
    }

    public static void choosePrivateKeyAlias(Activity activity, KeyChainAliasCallback keyChainAliasCallback, String[] stringArray, Principal[] principalArray, String string2, int n, String string3) {
        if (activity == null) {
            throw new NullPointerException("activity == null");
        }
        if (keyChainAliasCallback == null) {
            throw new NullPointerException("response == null");
        }
        Intent intent = new Intent(ACTION_CHOOSER);
        intent.setPackage("com.android.keychain");
        intent.putExtra(EXTRA_RESPONSE, new AliasResponse(keyChainAliasCallback));
        intent.putExtra(EXTRA_HOST, string2);
        intent.putExtra(EXTRA_PORT, n);
        intent.putExtra(EXTRA_ALIAS, string3);
        intent.putExtra(EXTRA_SENDER, PendingIntent.getActivity(activity, 0, new Intent(), 0));
        activity.startActivity(intent);
    }

    public static Intent createInstallIntent() {
        Intent intent = new Intent(ACTION_INSTALL);
        intent.setClassName(CERT_INSTALLER_PACKAGE, "com.android.certinstaller.CertInstallerMain");
        return intent;
    }

    private static void ensureNotOnMainThread(Context context) {
        Looper looper = Looper.myLooper();
        if (looper != null && looper == context.getMainLooper()) {
            throw new IllegalStateException("calling this from your main thread can lead to deadlock");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X509Certificate[] getCertificateChain(Context context, String string2) throws KeyChainException, InterruptedException {
        byte[] byArray;
        KeyChainConnection keyChainConnection;
        block10: {
            if (string2 == null) {
                throw new NullPointerException("alias == null");
            }
            keyChainConnection = KeyChain.bind(context);
            try {
                byArray = keyChainConnection.getService().getCertificate(string2);
                if (byArray != null) break block10;
            }
            catch (CertificateException certificateException) {
                throw new KeyChainException(certificateException);
            }
            catch (RemoteException remoteException) {
                throw new KeyChainException(remoteException);
            }
            catch (RuntimeException runtimeException) {
                throw new KeyChainException(runtimeException);
            }
            keyChainConnection.close();
            return null;
        }
        try {
            List list = new TrustedCertificateStore().getCertificateChain(KeyChain.toCertificate(byArray));
            X509Certificate[] x509CertificateArray = list.toArray(new X509Certificate[list.size()]);
            return x509CertificateArray;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            keyChainConnection.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PrivateKey getPrivateKey(Context context, String string2) throws KeyChainException, InterruptedException {
        String string3;
        if (string2 == null) {
            throw new NullPointerException("alias == null");
        }
        KeyChainConnection keyChainConnection = KeyChain.bind(context);
        try {
            string3 = keyChainConnection.getService().requestPrivateKey(string2);
            if (string3 == null) {
                throw new KeyChainException("keystore had a problem");
            }
        }
        catch (RemoteException remoteException) {
            throw new KeyChainException(remoteException);
        }
        catch (RuntimeException runtimeException) {
            throw new KeyChainException(runtimeException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new KeyChainException(invalidKeyException);
        }
        finally {
            keyChainConnection.close();
        }
        PrivateKey privateKey = OpenSSLEngine.getInstance((String)"keystore").getPrivateKeyById(string3);
        return privateKey;
    }

    public static boolean isBoundKeyAlgorithm(String string2) {
        if (!KeyChain.isKeyAlgorithmSupported(string2)) {
            return false;
        }
        return KeyStore.getInstance().isHardwareBacked(string2);
    }

    public static boolean isKeyAlgorithmSupported(String string2) {
        String string3 = string2.toUpperCase(Locale.US);
        return "DSA".equals(string3) || "EC".equals(string3) || "RSA".equals(string3);
    }

    public static X509Certificate toCertificate(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("bytes == null");
        }
        try {
            X509Certificate x509Certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(byArray));
            return x509Certificate;
        }
        catch (CertificateException certificateException) {
            throw new AssertionError((Object)certificateException);
        }
    }

    private static class AliasResponse
    extends IKeyChainAliasCallback.Stub {
        private final KeyChainAliasCallback keyChainAliasResponse;

        private AliasResponse(KeyChainAliasCallback keyChainAliasCallback) {
            this.keyChainAliasResponse = keyChainAliasCallback;
        }

        @Override
        public void alias(String string2) {
            this.keyChainAliasResponse.alias(string2);
        }
    }

    public static final class KeyChainConnection
    implements Closeable {
        private final Context context;
        private final IKeyChainService service;
        private final ServiceConnection serviceConnection;

        private KeyChainConnection(Context context, ServiceConnection serviceConnection, IKeyChainService iKeyChainService) {
            this.context = context;
            this.serviceConnection = serviceConnection;
            this.service = iKeyChainService;
        }

        @Override
        public void close() {
            this.context.unbindService(this.serviceConnection);
        }

        public IKeyChainService getService() {
            return this.service;
        }
    }
}

