/*
 * Decompiled with CFR 0.152.
 */
package android.service.media;

import android.app.Service;
import android.content.Intent;
import android.content.pm.ParceledListSlice;
import android.media.browse.MediaBrowser;
import android.media.session.MediaSession;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.service.media.IMediaBrowserService;
import android.service.media.IMediaBrowserServiceCallbacks;
import android.util.ArrayMap;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.List;

public abstract class MediaBrowserService
extends Service {
    private static final boolean DBG = false;
    public static final String SERVICE_INTERFACE = "android.media.browse.MediaBrowserService";
    private static final String TAG = "MediaBrowserService";
    private ServiceBinder mBinder;
    private final ArrayMap<IBinder, ConnectionRecord> mConnections = new ArrayMap();
    private final Handler mHandler = new Handler();
    MediaSession.Token mSession;

    private void addSubscription(String string2, ConnectionRecord connectionRecord) {
        if (connectionRecord.subscriptions.add(string2)) {
            this.performLoadChildren(string2, connectionRecord);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isValidPackage(String string2, int n) {
        if (string2 != null) {
            String[] stringArray = this.getPackageManager().getPackagesForUid(n);
            int n2 = stringArray.length;
            for (int i = 0; i < n2; ++i) {
                if (!stringArray[i].equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    private void performLoadChildren(final String string2, final ConnectionRecord connectionRecord) {
        Result<List<MediaBrowser.MediaItem>> result = new Result<List<MediaBrowser.MediaItem>>((Object)string2){

            @Override
            void onResultSent(List<MediaBrowser.MediaItem> list) {
                if (list == null) {
                    throw new IllegalStateException("onLoadChildren sent null list for id " + string2);
                }
                if (MediaBrowserService.this.mConnections.get(connectionRecord.callbacks.asBinder()) != connectionRecord) {
                    return;
                }
                ParceledListSlice<MediaBrowser.MediaItem> parceledListSlice = new ParceledListSlice<MediaBrowser.MediaItem>(list);
                try {
                    connectionRecord.callbacks.onLoadChildren(string2, parceledListSlice);
                    return;
                }
                catch (RemoteException remoteException) {
                    Log.w(MediaBrowserService.TAG, "Calling onLoadChildren() failed for id=" + string2 + " package=" + connectionRecord.pkg);
                    return;
                }
            }
        };
        this.onLoadChildren(string2, result);
        if (!result.isDone()) {
            throw new IllegalStateException("onLoadChildren must call detach() or sendResult() before returning for package=" + connectionRecord.pkg + " id=" + string2);
        }
    }

    @Override
    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
    }

    public MediaSession.Token getSessionToken() {
        return this.mSession;
    }

    public void notifyChildrenChanged(final String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("parentId cannot be null in notifyChildrenChanged");
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                for (IBinder iBinder : MediaBrowserService.this.mConnections.keySet()) {
                    ConnectionRecord connectionRecord = (ConnectionRecord)MediaBrowserService.this.mConnections.get(iBinder);
                    if (!connectionRecord.subscriptions.contains(string2)) continue;
                    MediaBrowserService.this.performLoadChildren(string2, connectionRecord);
                }
            }
        });
    }

    @Override
    public IBinder onBind(Intent intent) {
        if (SERVICE_INTERFACE.equals(intent.getAction())) {
            return this.mBinder;
        }
        return null;
    }

    @Override
    public void onCreate() {
        super.onCreate();
        this.mBinder = new ServiceBinder();
    }

    public abstract BrowserRoot onGetRoot(String var1, int var2, Bundle var3);

    public abstract void onLoadChildren(String var1, Result<List<MediaBrowser.MediaItem>> var2);

    public void setSessionToken(MediaSession.Token token) {
        if (token == null) {
            throw new IllegalStateException(this.getClass().getName() + ".onCreateSession() set invalid MediaSession.Token");
        }
        this.mSession = token;
    }

    public static final class BrowserRoot {
        private final Bundle mExtras;
        private final String mRootId;

        public BrowserRoot(String string2, Bundle bundle) {
            if (string2 == null) {
                throw new IllegalArgumentException("The root id in BrowserRoot cannot be null. Use null for BrowserRoot instead.");
            }
            this.mRootId = string2;
            this.mExtras = bundle;
        }

        public Bundle getExtras() {
            return this.mExtras;
        }

        public String getRootId() {
            return this.mRootId;
        }
    }

    private class ConnectionRecord {
        IMediaBrowserServiceCallbacks callbacks;
        String pkg;
        BrowserRoot root;
        Bundle rootHints;
        HashSet<String> subscriptions = new HashSet();

        private ConnectionRecord() {
        }
    }

    public class Result<T> {
        private Object mDebug;
        private boolean mDetachCalled;
        private boolean mSendResultCalled;

        Result(Object object) {
            this.mDebug = object;
        }

        public void detach() {
            if (this.mDetachCalled) {
                throw new IllegalStateException("detach() called when detach() had already been called for: " + this.mDebug);
            }
            if (this.mSendResultCalled) {
                throw new IllegalStateException("detach() called when sendResult() had already been called for: " + this.mDebug);
            }
            this.mDetachCalled = true;
        }

        boolean isDone() {
            return this.mDetachCalled || this.mSendResultCalled;
        }

        void onResultSent(T t) {
        }

        public void sendResult(T t) {
            if (this.mSendResultCalled) {
                throw new IllegalStateException("sendResult() called twice for: " + this.mDebug);
            }
            this.mSendResultCalled = true;
            this.onResultSent(t);
        }
    }

    private class ServiceBinder
    extends IMediaBrowserService.Stub {
        private ServiceBinder() {
        }

        @Override
        public void addSubscription(final String string2, final IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks) {
            MediaBrowserService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    IBinder iBinder = iMediaBrowserServiceCallbacks.asBinder();
                    ConnectionRecord connectionRecord = (ConnectionRecord)MediaBrowserService.this.mConnections.get(iBinder);
                    if (connectionRecord == null) {
                        Log.w(MediaBrowserService.TAG, "addSubscription for callback that isn't registered id=" + string2);
                        return;
                    }
                    MediaBrowserService.this.addSubscription(string2, connectionRecord);
                }
            });
        }

        @Override
        public void connect(final String string2, final Bundle bundle, final IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks) {
            final int n = Binder.getCallingUid();
            if (!MediaBrowserService.this.isValidPackage(string2, n)) {
                throw new IllegalArgumentException("Package/uid mismatch: uid=" + n + " package=" + string2);
            }
            MediaBrowserService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    IBinder iBinder = iMediaBrowserServiceCallbacks.asBinder();
                    MediaBrowserService.this.mConnections.remove(iBinder);
                    ConnectionRecord connectionRecord = new ConnectionRecord();
                    connectionRecord.pkg = string2;
                    connectionRecord.rootHints = bundle;
                    connectionRecord.callbacks = iMediaBrowserServiceCallbacks;
                    connectionRecord.root = MediaBrowserService.this.onGetRoot(string2, n, bundle);
                    if (connectionRecord.root == null) {
                        Log.i(MediaBrowserService.TAG, "No root for client " + string2 + " from service " + this.getClass().getName());
                        try {
                            iMediaBrowserServiceCallbacks.onConnectFailed();
                            return;
                        }
                        catch (RemoteException remoteException) {
                            Log.w(MediaBrowserService.TAG, "Calling onConnectFailed() failed. Ignoring. pkg=" + string2);
                            return;
                        }
                    }
                    try {
                        MediaBrowserService.this.mConnections.put(iBinder, connectionRecord);
                        iMediaBrowserServiceCallbacks.onConnect(connectionRecord.root.getRootId(), MediaBrowserService.this.mSession, connectionRecord.root.getExtras());
                        return;
                    }
                    catch (RemoteException remoteException) {
                        Log.w(MediaBrowserService.TAG, "Calling onConnect() failed. Dropping client. pkg=" + string2);
                        MediaBrowserService.this.mConnections.remove(iBinder);
                        return;
                    }
                }
            });
        }

        @Override
        public void disconnect(final IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks) {
            MediaBrowserService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    IBinder iBinder = iMediaBrowserServiceCallbacks.asBinder();
                    if ((ConnectionRecord)MediaBrowserService.this.mConnections.remove(iBinder) != null) {
                        // empty if block
                    }
                }
            });
        }

        @Override
        public void removeSubscription(final String string2, final IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks) {
            MediaBrowserService.this.mHandler.post(new Runnable(){

                /*
                 * Enabled aggressive block sorting
                 */
                @Override
                public void run() {
                    IBinder iBinder = iMediaBrowserServiceCallbacks.asBinder();
                    ConnectionRecord connectionRecord = (ConnectionRecord)MediaBrowserService.this.mConnections.get(iBinder);
                    if (connectionRecord == null) {
                        Log.w(MediaBrowserService.TAG, "removeSubscription for callback that isn't registered id=" + string2);
                        return;
                    } else {
                        if (connectionRecord.subscriptions.remove(string2)) return;
                        Log.w(MediaBrowserService.TAG, "removeSubscription called for " + string2 + " which is not subscribed");
                        return;
                    }
                }
            });
        }
    }
}

