/*
 * Decompiled with CFR 0.152.
 */
package android.service.notification;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.service.notification.IStatusBarNotificationHolder;
import android.service.notification.NotificationRankingUpdate;

public interface INotificationListener
extends IInterface {
    public void onInterruptionFilterChanged(int var1) throws RemoteException;

    public void onListenerConnected(NotificationRankingUpdate var1) throws RemoteException;

    public void onListenerHintsChanged(int var1) throws RemoteException;

    public void onNotificationPosted(IStatusBarNotificationHolder var1, NotificationRankingUpdate var2) throws RemoteException;

    public void onNotificationRankingUpdate(NotificationRankingUpdate var1) throws RemoteException;

    public void onNotificationRemoved(IStatusBarNotificationHolder var1, NotificationRankingUpdate var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INotificationListener {
        private static final String DESCRIPTOR = "android.service.notification.INotificationListener";
        static final int TRANSACTION_onInterruptionFilterChanged = 6;
        static final int TRANSACTION_onListenerConnected = 1;
        static final int TRANSACTION_onListenerHintsChanged = 5;
        static final int TRANSACTION_onNotificationPosted = 2;
        static final int TRANSACTION_onNotificationRankingUpdate = 4;
        static final int TRANSACTION_onNotificationRemoved = 3;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static INotificationListener asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof INotificationListener) {
                return (INotificationListener)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    NotificationRankingUpdate notificationRankingUpdate = parcel.readInt() != 0 ? NotificationRankingUpdate.CREATOR.createFromParcel(parcel) : null;
                    this.onListenerConnected(notificationRankingUpdate);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IStatusBarNotificationHolder iStatusBarNotificationHolder = IStatusBarNotificationHolder.Stub.asInterface(parcel.readStrongBinder());
                    NotificationRankingUpdate notificationRankingUpdate = parcel.readInt() != 0 ? NotificationRankingUpdate.CREATOR.createFromParcel(parcel) : null;
                    this.onNotificationPosted(iStatusBarNotificationHolder, notificationRankingUpdate);
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IStatusBarNotificationHolder iStatusBarNotificationHolder = IStatusBarNotificationHolder.Stub.asInterface(parcel.readStrongBinder());
                    NotificationRankingUpdate notificationRankingUpdate = parcel.readInt() != 0 ? NotificationRankingUpdate.CREATOR.createFromParcel(parcel) : null;
                    this.onNotificationRemoved(iStatusBarNotificationHolder, notificationRankingUpdate);
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    NotificationRankingUpdate notificationRankingUpdate = parcel.readInt() != 0 ? NotificationRankingUpdate.CREATOR.createFromParcel(parcel) : null;
                    this.onNotificationRankingUpdate(notificationRankingUpdate);
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.onListenerHintsChanged(parcel.readInt());
                    return true;
                }
                case 6: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            this.onInterruptionFilterChanged(parcel.readInt());
            return true;
        }

        private static class Proxy
        implements INotificationListener {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public void onInterruptionFilterChanged(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(6, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onListenerConnected(NotificationRankingUpdate notificationRankingUpdate) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (notificationRankingUpdate != null) {
                        parcel.writeInt(1);
                        notificationRankingUpdate.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(1, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void onListenerHintsChanged(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(5, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onNotificationPosted(IStatusBarNotificationHolder iStatusBarNotificationHolder, NotificationRankingUpdate notificationRankingUpdate) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = null;
                    if (iStatusBarNotificationHolder != null) {
                        iBinder = iStatusBarNotificationHolder.asBinder();
                    }
                    parcel.writeStrongBinder(iBinder);
                    if (notificationRankingUpdate != null) {
                        parcel.writeInt(1);
                        notificationRankingUpdate.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(2, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onNotificationRankingUpdate(NotificationRankingUpdate notificationRankingUpdate) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (notificationRankingUpdate != null) {
                        parcel.writeInt(1);
                        notificationRankingUpdate.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(4, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onNotificationRemoved(IStatusBarNotificationHolder iStatusBarNotificationHolder, NotificationRankingUpdate notificationRankingUpdate) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = null;
                    if (iStatusBarNotificationHolder != null) {
                        iBinder = iStatusBarNotificationHolder.asBinder();
                    }
                    parcel.writeStrongBinder(iBinder);
                    if (notificationRankingUpdate != null) {
                        parcel.writeInt(1);
                        notificationRankingUpdate.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(3, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }
        }
    }
}

