/*
 * Decompiled with CFR 0.152.
 */
package android.service.notification;

import android.app.INotificationManager;
import android.app.Notification;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.service.notification.INotificationListener;
import android.service.notification.IStatusBarNotificationHolder;
import android.service.notification.NotificationRankingUpdate;
import android.service.notification.StatusBarNotification;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import java.util.Collections;
import java.util.List;

public abstract class NotificationListenerService
extends Service {
    public static final int HINT_HOST_DISABLE_EFFECTS = 1;
    public static final int INTERRUPTION_FILTER_ALL = 1;
    public static final int INTERRUPTION_FILTER_NONE = 3;
    public static final int INTERRUPTION_FILTER_PRIORITY = 2;
    public static final String SERVICE_INTERFACE = "android.service.notification.NotificationListenerService";
    public static final int TRIM_FULL = 0;
    public static final int TRIM_LIGHT = 1;
    private final String TAG = NotificationListenerService.class.getSimpleName() + "[" + this.getClass().getSimpleName() + "]";
    private int mCurrentUser;
    private INotificationManager mNoMan;
    private RankingMap mRankingMap;
    private Context mSystemContext;
    private INotificationListenerWrapper mWrapper = null;

    private void applyUpdate(NotificationRankingUpdate notificationRankingUpdate) {
        this.mRankingMap = new RankingMap(notificationRankingUpdate);
    }

    private Context getContext() {
        if (context.mSystemContext != null) {
            Context context = context.mSystemContext;
        }
        return context;
    }

    private final INotificationManager getNotificationInterface() {
        if (this.mNoMan == null) {
            this.mNoMan = INotificationManager.Stub.asInterface(ServiceManager.getService("notification"));
        }
        return this.mNoMan;
    }

    private boolean isBound() {
        if (this.mWrapper == null) {
            Log.w(this.TAG, "Notification listener service not yet bound.");
            return false;
        }
        return true;
    }

    public final void cancelAllNotifications() {
        this.cancelNotifications(null);
    }

    public final void cancelNotification(String string2) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().cancelNotificationsFromListener(this.mWrapper, new String[]{string2});
            return;
        }
        catch (RemoteException remoteException) {
            Log.v(this.TAG, "Unable to contact notification manager", remoteException);
            return;
        }
    }

    public final void cancelNotification(String string2, String string3, int n) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().cancelNotificationFromListener(this.mWrapper, string2, string3, n);
            return;
        }
        catch (RemoteException remoteException) {
            Log.v(this.TAG, "Unable to contact notification manager", remoteException);
            return;
        }
    }

    public final void cancelNotifications(String[] stringArray) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().cancelNotificationsFromListener(this.mWrapper, stringArray);
            return;
        }
        catch (RemoteException remoteException) {
            Log.v(this.TAG, "Unable to contact notification manager", remoteException);
            return;
        }
    }

    public StatusBarNotification[] getActiveNotifications() {
        return this.getActiveNotifications(null, 0);
    }

    public StatusBarNotification[] getActiveNotifications(int n) {
        return this.getActiveNotifications(null, n);
    }

    public StatusBarNotification[] getActiveNotifications(String[] stringArray) {
        return this.getActiveNotifications(stringArray, 0);
    }

    public StatusBarNotification[] getActiveNotifications(String[] stringArray, int n) {
        if (!this.isBound()) {
            return null;
        }
        List<StatusBarNotification> list = this.getNotificationInterface().getActiveNotificationsFromListener(this.mWrapper, stringArray, n).getList();
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            Notification notification = ((StatusBarNotification)list.get(i)).getNotification();
            Notification.Builder.rebuild(this.getContext(), notification);
            continue;
        }
        try {
            StatusBarNotification[] statusBarNotificationArray = list.toArray(new StatusBarNotification[n2]);
            return statusBarNotificationArray;
        }
        catch (RemoteException remoteException) {
            Log.v(this.TAG, "Unable to contact notification manager", remoteException);
            return null;
        }
    }

    public final int getCurrentInterruptionFilter() {
        if (!this.isBound()) {
            return 0;
        }
        try {
            int n = this.getNotificationInterface().getInterruptionFilterFromListener(this.mWrapper);
            return n;
        }
        catch (RemoteException remoteException) {
            Log.v(this.TAG, "Unable to contact notification manager", remoteException);
            return 0;
        }
    }

    public final int getCurrentListenerHints() {
        if (!this.isBound()) {
            return 0;
        }
        try {
            int n = this.getNotificationInterface().getHintsFromListener(this.mWrapper);
            return n;
        }
        catch (RemoteException remoteException) {
            Log.v(this.TAG, "Unable to contact notification manager", remoteException);
            return 0;
        }
    }

    public RankingMap getCurrentRanking() {
        return this.mRankingMap;
    }

    @Override
    public IBinder onBind(Intent intent) {
        if (this.mWrapper == null) {
            this.mWrapper = new INotificationListenerWrapper();
        }
        return this.mWrapper;
    }

    public void onInterruptionFilterChanged(int n) {
    }

    public void onListenerConnected() {
    }

    public void onListenerHintsChanged(int n) {
    }

    public void onNotificationPosted(StatusBarNotification statusBarNotification) {
    }

    public void onNotificationPosted(StatusBarNotification statusBarNotification, RankingMap rankingMap) {
        this.onNotificationPosted(statusBarNotification);
    }

    public void onNotificationRankingUpdate(RankingMap rankingMap) {
    }

    public void onNotificationRemoved(StatusBarNotification statusBarNotification) {
    }

    public void onNotificationRemoved(StatusBarNotification statusBarNotification, RankingMap rankingMap) {
        this.onNotificationRemoved(statusBarNotification);
    }

    public void registerAsSystemService(Context context, ComponentName componentName, int n) throws RemoteException {
        this.mSystemContext = context;
        if (this.mWrapper == null) {
            this.mWrapper = new INotificationListenerWrapper();
        }
        this.getNotificationInterface().registerListener(this.mWrapper, componentName, n);
        this.mCurrentUser = n;
    }

    public final void requestInterruptionFilter(int n) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().requestInterruptionFilterFromListener(this.mWrapper, n);
            return;
        }
        catch (RemoteException remoteException) {
            Log.v(this.TAG, "Unable to contact notification manager", remoteException);
            return;
        }
    }

    public final void requestListenerHints(int n) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().requestHintsFromListener(this.mWrapper, n);
            return;
        }
        catch (RemoteException remoteException) {
            Log.v(this.TAG, "Unable to contact notification manager", remoteException);
            return;
        }
    }

    public final void setOnNotificationPostedTrim(int n) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().setOnNotificationPostedTrimFromListener(this.mWrapper, n);
            return;
        }
        catch (RemoteException remoteException) {
            Log.v(this.TAG, "Unable to contact notification manager", remoteException);
            return;
        }
    }

    public void unregisterAsSystemService() throws RemoteException {
        if (this.mWrapper != null) {
            this.getNotificationInterface().unregisterListener(this.mWrapper, this.mCurrentUser);
        }
    }

    private class INotificationListenerWrapper
    extends INotificationListener.Stub {
        private INotificationListenerWrapper() {
        }

        @Override
        public void onInterruptionFilterChanged(int n) throws RemoteException {
            try {
                NotificationListenerService.this.onInterruptionFilterChanged(n);
                return;
            }
            catch (Throwable throwable) {
                Log.w(NotificationListenerService.this.TAG, "Error running onInterruptionFilterChanged", throwable);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onListenerConnected(NotificationRankingUpdate notificationRankingUpdate) {
            INotificationListenerWrapper iNotificationListenerWrapper = NotificationListenerService.this.mWrapper;
            synchronized (iNotificationListenerWrapper) {
                NotificationListenerService.this.applyUpdate(notificationRankingUpdate);
                try {
                    NotificationListenerService.this.onListenerConnected();
                }
                catch (Throwable throwable) {
                    Log.w(NotificationListenerService.this.TAG, "Error running onListenerConnected", throwable);
                }
                return;
            }
        }

        @Override
        public void onListenerHintsChanged(int n) throws RemoteException {
            try {
                NotificationListenerService.this.onListenerHintsChanged(n);
                return;
            }
            catch (Throwable throwable) {
                Log.w(NotificationListenerService.this.TAG, "Error running onListenerHintsChanged", throwable);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onNotificationPosted(IStatusBarNotificationHolder iStatusBarNotificationHolder, NotificationRankingUpdate notificationRankingUpdate) {
            StatusBarNotification statusBarNotification;
            try {
                statusBarNotification = iStatusBarNotificationHolder.get();
            }
            catch (RemoteException remoteException) {
                Log.w(NotificationListenerService.this.TAG, "onNotificationPosted: Error receiving StatusBarNotification", remoteException);
                return;
            }
            Notification.Builder.rebuild(NotificationListenerService.this.getContext(), statusBarNotification.getNotification());
            INotificationListenerWrapper iNotificationListenerWrapper = NotificationListenerService.this.mWrapper;
            synchronized (iNotificationListenerWrapper) {
                NotificationListenerService.this.applyUpdate(notificationRankingUpdate);
                try {
                    NotificationListenerService.this.onNotificationPosted(statusBarNotification, NotificationListenerService.this.mRankingMap);
                }
                catch (Throwable throwable) {
                    Log.w(NotificationListenerService.this.TAG, "Error running onNotificationPosted", throwable);
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onNotificationRankingUpdate(NotificationRankingUpdate notificationRankingUpdate) throws RemoteException {
            INotificationListenerWrapper iNotificationListenerWrapper = NotificationListenerService.this.mWrapper;
            synchronized (iNotificationListenerWrapper) {
                NotificationListenerService.this.applyUpdate(notificationRankingUpdate);
                try {
                    NotificationListenerService.this.onNotificationRankingUpdate(NotificationListenerService.this.mRankingMap);
                }
                catch (Throwable throwable) {
                    Log.w(NotificationListenerService.this.TAG, "Error running onNotificationRankingUpdate", throwable);
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onNotificationRemoved(IStatusBarNotificationHolder iStatusBarNotificationHolder, NotificationRankingUpdate notificationRankingUpdate) {
            StatusBarNotification statusBarNotification;
            try {
                statusBarNotification = iStatusBarNotificationHolder.get();
            }
            catch (RemoteException remoteException) {
                Log.w(NotificationListenerService.this.TAG, "onNotificationRemoved: Error receiving StatusBarNotification", remoteException);
                return;
            }
            INotificationListenerWrapper iNotificationListenerWrapper = NotificationListenerService.this.mWrapper;
            synchronized (iNotificationListenerWrapper) {
                NotificationListenerService.this.applyUpdate(notificationRankingUpdate);
                try {
                    NotificationListenerService.this.onNotificationRemoved(statusBarNotification, NotificationListenerService.this.mRankingMap);
                }
                catch (Throwable throwable) {
                    Log.w(NotificationListenerService.this.TAG, "Error running onNotificationRemoved", throwable);
                }
                return;
            }
        }
    }

    public static class Ranking {
        public static final int VISIBILITY_NO_OVERRIDE = -1000;
        private boolean mIsAmbient;
        private String mKey;
        private boolean mMatchesInterruptionFilter;
        private int mRank = -1;
        private int mVisibilityOverride;

        private void populate(String string2, int n, boolean bl, boolean bl2, int n2) {
            this.mKey = string2;
            this.mRank = n;
            this.mIsAmbient = bl;
            this.mMatchesInterruptionFilter = bl2;
            this.mVisibilityOverride = n2;
        }

        public String getKey() {
            return this.mKey;
        }

        public int getRank() {
            return this.mRank;
        }

        public int getVisibilityOverride() {
            return this.mVisibilityOverride;
        }

        public boolean isAmbient() {
            return this.mIsAmbient;
        }

        public boolean matchesInterruptionFilter() {
            return this.mMatchesInterruptionFilter;
        }
    }

    public static class RankingMap
    implements Parcelable {
        public static final Parcelable.Creator<RankingMap> CREATOR = new Parcelable.Creator<RankingMap>(){

            @Override
            public RankingMap createFromParcel(Parcel parcel) {
                return new RankingMap((NotificationRankingUpdate)parcel.readParcelable(null));
            }

            public RankingMap[] newArray(int n) {
                return new RankingMap[n];
            }
        };
        private ArraySet<Object> mIntercepted;
        private final NotificationRankingUpdate mRankingUpdate;
        private ArrayMap<String, Integer> mRanks;
        private ArrayMap<String, Integer> mVisibilityOverrides;

        private RankingMap(NotificationRankingUpdate notificationRankingUpdate) {
            this.mRankingUpdate = notificationRankingUpdate;
        }

        private void buildInterceptedSetLocked() {
            String[] stringArray = this.mRankingUpdate.getInterceptedKeys();
            this.mIntercepted = new ArraySet(stringArray.length);
            Collections.addAll(this.mIntercepted, stringArray);
        }

        private void buildRanksLocked() {
            String[] stringArray = this.mRankingUpdate.getOrderedKeys();
            this.mRanks = new ArrayMap(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                this.mRanks.put(string2, i);
            }
        }

        private void buildVisibilityOverridesLocked() {
            Bundle bundle = this.mRankingUpdate.getVisibilityOverrides();
            this.mVisibilityOverrides = new ArrayMap(bundle.size());
            for (String string2 : bundle.keySet()) {
                this.mVisibilityOverrides.put(string2, bundle.getInt(string2));
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private int getRank(String string2) {
            synchronized (this) {
                if (this.mRanks == null) {
                    this.buildRanksLocked();
                }
            }
            Integer n = this.mRanks.get(string2);
            if (n != null) {
                return n;
            }
            return -1;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private int getVisibilityOverride(String string2) {
            synchronized (this) {
                if (this.mVisibilityOverrides == null) {
                    this.buildVisibilityOverridesLocked();
                }
            }
            Integer n = this.mVisibilityOverrides.get(string2);
            if (n == null) {
                return -1000;
            }
            return n;
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean isAmbient(String string2) {
            int n;
            int n2 = this.mRankingUpdate.getFirstAmbientIndex();
            return n2 >= 0 && (n = this.getRank(string2)) >= 0 && n >= n2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean isIntercepted(String string2) {
            synchronized (this) {
                if (this.mIntercepted == null) {
                    this.buildInterceptedSetLocked();
                }
                return this.mIntercepted.contains(string2);
            }
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public String[] getOrderedKeys() {
            return this.mRankingUpdate.getOrderedKeys();
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean getRanking(String string2, Ranking ranking) {
            int n = this.getRank(string2);
            boolean bl = this.isAmbient(string2);
            boolean bl2 = !this.isIntercepted(string2);
            ranking.populate(string2, n, bl, bl2, this.getVisibilityOverride(string2));
            return n >= 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeParcelable(this.mRankingUpdate, n);
        }
    }
}

