/*
 * Decompiled with CFR 0.152.
 */
package android.speech.srec;

import java.io.IOException;
import java.io.InputStream;

public final class UlawEncoderInputStream
extends InputStream {
    private static final int MAX_ULAW = 8192;
    private static final int SCALE_BITS = 16;
    private static final String TAG = "UlawEncoderInputStream";
    private final byte[] mBuf = new byte[1024];
    private int mBufCount = 0;
    private InputStream mIn;
    private int mMax = 0;
    private final byte[] mOneByte = new byte[1];

    public UlawEncoderInputStream(InputStream inputStream, int n) {
        this.mIn = inputStream;
        this.mMax = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void encode(byte[] byArray, int n, byte[] byArray2, int n2, int n3, int n4) {
        if (n4 <= 0) {
            n4 = 8192;
        }
        int n5 = 0x20000000 / n4;
        int n6 = 0;
        int n7 = n2;
        int n8 = n;
        while (n6 < n3) {
            int n9 = n8 + 1;
            int n10 = 0xFF & byArray[n8];
            n8 = n9 + 1;
            int n11 = n5 * (n10 + (byArray[n9] << 8)) >> 16;
            int n12 = n11 >= 0 ? (n11 <= 0 ? 255 : (n11 <= 30 ? 240 + (30 - n11 >> 1) : (n11 <= 94 ? 224 + (94 - n11 >> 2) : (n11 <= 222 ? 208 + (222 - n11 >> 3) : (n11 <= 478 ? 192 + (478 - n11 >> 4) : (n11 <= 990 ? 176 + (990 - n11 >> 5) : (n11 <= 2014 ? 160 + (2014 - n11 >> 6) : (n11 <= 4062 ? 144 + (4062 - n11 >> 7) : (n11 <= 8158 ? 128 + (8158 - n11 >> 8) : 128))))))))) : (-1 <= n11 ? 127 : (-31 <= n11 ? 112 + (n11 + 31 >> 1) : (-95 <= n11 ? 96 + (n11 + 95 >> 2) : (-223 <= n11 ? 80 + (n11 + 223 >> 3) : (-479 <= n11 ? 64 + (n11 + 479 >> 4) : (-991 <= n11 ? 48 + (n11 + 991 >> 5) : (-2015 <= n11 ? 32 + (n11 + 2015 >> 6) : (-4063 <= n11 ? 16 + (n11 + 4063 >> 7) : (-8159 <= n11 ? 0 + (n11 + 8159 >> 8) : 0)))))))));
            int n13 = n7 + 1;
            byArray2[n7] = (byte)n12;
            ++n6;
            n7 = n13;
        }
        return;
    }

    public static int maxAbsPcm(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = n;
        for (int i = 0; i < n2; ++i) {
            int n5 = n4 + 1;
            int n6 = 0xFF & byArray[n4];
            n4 = n5 + 1;
            int n7 = n6 + (byArray[n5] << 8);
            if (n7 < 0) {
                n7 = -n7;
            }
            if (n7 <= n3) continue;
            n3 = n7;
        }
        return n3;
    }

    @Override
    public int available() throws IOException {
        return (this.mIn.available() + this.mBufCount) / 2;
    }

    @Override
    public void close() throws IOException {
        if (this.mIn != null) {
            InputStream inputStream = this.mIn;
            this.mIn = null;
            inputStream.close();
        }
    }

    @Override
    public int read() throws IOException {
        if (this.read(this.mOneByte, 0, 1) == -1) {
            return -1;
        }
        return 0xFF & this.mOneByte[0];
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int read(byte[] var1_1, int var2_2, int var3_3) throws IOException {
        block2: {
            if (this.mIn != null) ** GOTO lbl4
            throw new IllegalStateException("not open");
lbl-1000:
            // 1 sources

            {
                this.mBufCount = var6_4 + this.mBufCount;
lbl4:
                // 2 sources

                if (this.mBufCount >= 2) break block2;
                ** while ((var6_4 = this.mIn.read((byte[])this.mBuf, (int)this.mBufCount, (int)Math.min((int)(var3_3 * 2), (int)(this.mBuf.length - this.mBufCount)))) != -1)
            }
lbl6:
            // 1 sources

            return -1;
        }
        var4_5 = Math.min(this.mBufCount / 2, var3_3);
        UlawEncoderInputStream.encode(this.mBuf, 0, var1_1, var2_2, var4_5, this.mMax);
        this.mBufCount -= var4_5 * 2;
        for (var5_6 = 0; var5_6 < this.mBufCount; ++var5_6) {
            this.mBuf[var5_6] = this.mBuf[var5_6 + var4_5 * 2];
        }
        return var4_5;
    }
}

