/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.net.Uri;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.telecom.DisconnectCause;
import android.telecom.PhoneAccountHandle;
import android.telecom.PhoneCapabilities;
import android.telecom.StatusHints;
import com.android.internal.telecom.IVideoProvider;
import java.util.ArrayList;
import java.util.List;

public final class ParcelableConnection
implements Parcelable {
    public static final Parcelable.Creator<ParcelableConnection> CREATOR = new Parcelable.Creator<ParcelableConnection>(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public ParcelableConnection createFromParcel(Parcel parcel) {
            ClassLoader classLoader = ParcelableConnection.class.getClassLoader();
            PhoneAccountHandle phoneAccountHandle = (PhoneAccountHandle)parcel.readParcelable(classLoader);
            int n = parcel.readInt();
            int n2 = parcel.readInt();
            Uri uri = (Uri)parcel.readParcelable(classLoader);
            int n3 = parcel.readInt();
            String string2 = parcel.readString();
            int n4 = parcel.readInt();
            IVideoProvider iVideoProvider = IVideoProvider.Stub.asInterface(parcel.readStrongBinder());
            int n5 = parcel.readInt();
            boolean bl = parcel.readByte() == 1;
            boolean bl2 = parcel.readByte() == 1;
            StatusHints statusHints = (StatusHints)parcel.readParcelable(classLoader);
            DisconnectCause disconnectCause = (DisconnectCause)parcel.readParcelable(classLoader);
            ArrayList<String> arrayList = new ArrayList<String>();
            parcel.readStringList(arrayList);
            return new ParcelableConnection(phoneAccountHandle, n, n2, uri, n3, string2, n4, iVideoProvider, n5, bl, bl2, statusHints, disconnectCause, arrayList, parcel.readInt());
        }

        public ParcelableConnection[] newArray(int n) {
            return new ParcelableConnection[n];
        }
    };
    private final Uri mAddress;
    private final int mAddressPresentation;
    private final int mCallSubstate;
    private final String mCallerDisplayName;
    private final int mCallerDisplayNamePresentation;
    private final int mCapabilities;
    private final List<String> mConferenceableConnectionIds;
    private final DisconnectCause mDisconnectCause;
    private final boolean mIsVoipAudioMode;
    private final PhoneAccountHandle mPhoneAccount;
    private final boolean mRingbackRequested;
    private final int mState;
    private final StatusHints mStatusHints;
    private final IVideoProvider mVideoProvider;
    private final int mVideoState;

    public ParcelableConnection(PhoneAccountHandle phoneAccountHandle, int n, int n2, Uri uri, int n3, String string2, int n4, IVideoProvider iVideoProvider, int n5, boolean bl, boolean bl2, StatusHints statusHints, DisconnectCause disconnectCause, List<String> list, int n6) {
        this.mPhoneAccount = phoneAccountHandle;
        this.mState = n;
        this.mCapabilities = n2;
        this.mAddress = uri;
        this.mAddressPresentation = n3;
        this.mCallerDisplayName = string2;
        this.mCallerDisplayNamePresentation = n4;
        this.mVideoProvider = iVideoProvider;
        this.mVideoState = n5;
        this.mRingbackRequested = bl;
        this.mIsVoipAudioMode = bl2;
        this.mStatusHints = statusHints;
        this.mDisconnectCause = disconnectCause;
        this.mConferenceableConnectionIds = list;
        this.mCallSubstate = n6;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getCallSubstate() {
        return this.mCallSubstate;
    }

    public String getCallerDisplayName() {
        return this.mCallerDisplayName;
    }

    public int getCallerDisplayNamePresentation() {
        return this.mCallerDisplayNamePresentation;
    }

    public int getCapabilities() {
        return this.mCapabilities;
    }

    public final List<String> getConferenceableConnectionIds() {
        return this.mConferenceableConnectionIds;
    }

    public final DisconnectCause getDisconnectCause() {
        return this.mDisconnectCause;
    }

    public Uri getHandle() {
        return this.mAddress;
    }

    public int getHandlePresentation() {
        return this.mAddressPresentation;
    }

    public boolean getIsVoipAudioMode() {
        return this.mIsVoipAudioMode;
    }

    public PhoneAccountHandle getPhoneAccount() {
        return this.mPhoneAccount;
    }

    public int getState() {
        return this.mState;
    }

    public final StatusHints getStatusHints() {
        return this.mStatusHints;
    }

    public IVideoProvider getVideoProvider() {
        return this.mVideoProvider;
    }

    public int getVideoState() {
        return this.mVideoState;
    }

    public boolean isRingbackRequested() {
        return this.mRingbackRequested;
    }

    public String toString() {
        return "ParcelableConnection [act:" + this.mPhoneAccount + ", state:" + this.mState + ", capabilities:" + PhoneCapabilities.toString(this.mCapabilities);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        boolean bl = true;
        parcel.writeParcelable(this.mPhoneAccount, 0);
        parcel.writeInt(this.mState);
        parcel.writeInt(this.mCapabilities);
        parcel.writeParcelable(this.mAddress, 0);
        parcel.writeInt(this.mAddressPresentation);
        parcel.writeString(this.mCallerDisplayName);
        parcel.writeInt(this.mCallerDisplayNamePresentation);
        IBinder iBinder = this.mVideoProvider != null ? this.mVideoProvider.asBinder() : null;
        parcel.writeStrongBinder(iBinder);
        parcel.writeInt(this.mVideoState);
        boolean bl2 = this.mRingbackRequested ? bl : false;
        parcel.writeByte((byte)(bl2 ? 1 : 0));
        if (!this.mIsVoipAudioMode) {
            bl = false;
        }
        parcel.writeByte((byte)(bl ? 1 : 0));
        parcel.writeParcelable(this.mStatusHints, 0);
        parcel.writeParcelable(this.mDisconnectCause, 0);
        parcel.writeStringList(this.mConferenceableConnectionIds);
        parcel.writeInt(this.mCallSubstate);
    }
}

