/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.graphics.Paint;
import android.text.AndroidBidi;
import android.text.Spanned;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.MetricAffectingSpan;
import android.text.style.ReplacementSpan;
import com.android.internal.util.ArrayUtils;

class MeasuredText {
    private static final boolean localLOGV;
    private static final MeasuredText[] sCached;
    private static final Object[] sLock;
    char[] mChars;
    int mDir;
    boolean mEasy;
    int mLen;
    byte[] mLevels;
    private int mPos;
    CharSequence mText;
    int mTextStart;
    float[] mWidths;
    private TextPaint mWorkPaint = new TextPaint();

    static {
        sLock = new Object[0];
        sCached = new MeasuredText[3];
    }

    private MeasuredText() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static MeasuredText obtain() {
        Object[] objectArray = sLock;
        synchronized (objectArray) {
            int n = sCached.length;
            do {
                if (--n >= 0) continue;
                return new MeasuredText();
            } while (sCached[n] == null);
            MeasuredText measuredText = sCached[n];
            MeasuredText.sCached[n] = null;
            return measuredText;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static MeasuredText recycle(MeasuredText measuredText) {
        measuredText.mText = null;
        if (measuredText.mLen >= 1000) {
            return null;
        }
        Object[] objectArray = sLock;
        synchronized (objectArray) {
            int n = 0;
            while (true) {
                block8: {
                    block7: {
                        if (n >= sCached.length) break block7;
                        if (sCached[n] != null) break block8;
                        MeasuredText.sCached[n] = measuredText;
                        measuredText.mText = null;
                    }
                    return null;
                }
                ++n;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    float addStyleRun(TextPaint textPaint, int n, Paint.FontMetricsInt fontMetricsInt) {
        if (fontMetricsInt != null) {
            textPaint.getFontMetricsInt(fontMetricsInt);
        }
        int n2 = this.mPos;
        this.mPos = n2 + n;
        if (this.mEasy) {
            boolean bl = this.mDir != 1;
            return textPaint.getTextRunAdvances(this.mChars, n2, n, n2, n, bl, this.mWidths, n2);
        }
        float f = 0.0f;
        byte by = this.mLevels[n2];
        int n3 = n2;
        int n4 = n2 + 1;
        int n5 = n2 + n;
        while (true) {
            if (n4 == n5 || this.mLevels[n4] != by) {
                boolean bl = (by & 1) != 0;
                char[] cArray = this.mChars;
                int n6 = n4 - n3;
                int n7 = n4 - n3;
                float[] fArray = this.mWidths;
                f += textPaint.getTextRunAdvances(cArray, n3, n6, n3, n7, bl, fArray, n3);
                if (n4 == n5) return f;
                n3 = n4;
                by = this.mLevels[n4];
            }
            ++n4;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    float addStyleRun(TextPaint textPaint, MetricAffectingSpan[] metricAffectingSpanArray, int n, Paint.FontMetricsInt fontMetricsInt) {
        float f;
        TextPaint textPaint2 = this.mWorkPaint;
        textPaint2.set(textPaint);
        textPaint2.baselineShift = 0;
        ReplacementSpan replacementSpan = null;
        for (int i = 0; i < metricAffectingSpanArray.length; ++i) {
            MetricAffectingSpan metricAffectingSpan = metricAffectingSpanArray[i];
            if (metricAffectingSpan instanceof ReplacementSpan) {
                replacementSpan = (ReplacementSpan)metricAffectingSpan;
                continue;
            }
            metricAffectingSpan.updateMeasureState(textPaint2);
        }
        if (replacementSpan == null) {
            f = this.addStyleRun(textPaint2, n, fontMetricsInt);
        } else {
            f = replacementSpan.getSize(textPaint2, this.mText, this.mTextStart + this.mPos, n + (this.mTextStart + this.mPos), fontMetricsInt);
            float[] fArray = this.mWidths;
            fArray[this.mPos] = f;
            int n2 = n + this.mPos;
            for (int i = 1 + this.mPos; i < n2; ++i) {
                fArray[i] = 0.0f;
            }
            this.mPos = n + this.mPos;
        }
        if (fontMetricsInt != null) {
            if (textPaint2.baselineShift >= 0) {
                fontMetricsInt.descent += textPaint2.baselineShift;
                fontMetricsInt.bottom += textPaint2.baselineShift;
                return f;
            }
            fontMetricsInt.ascent += textPaint2.baselineShift;
            fontMetricsInt.top += textPaint2.baselineShift;
        }
        return f;
    }

    int breakText(int n, boolean bl, float f) {
        float[] fArray = this.mWidths;
        if (bl) {
            int n2 = 0;
            while (true) {
                if (n2 >= n || (f -= fArray[n2]) < 0.0f) {
                    while (n2 > 0 && this.mChars[n2 - 1] == ' ') {
                        --n2;
                    }
                    break;
                }
                ++n2;
            }
            return n2;
        }
        int n3 = n - 1;
        while (true) {
            if (n3 < 0 || (f -= fArray[n3]) < 0.0f) {
                while (n3 < n - 1 && this.mChars[n3 + 1] == ' ') {
                    ++n3;
                }
                break;
            }
            --n3;
        }
        return -1 + (n - n3);
    }

    float measure(int n, int n2) {
        float f = 0.0f;
        float[] fArray = this.mWidths;
        for (int i = n; i < n2; ++i) {
            f += fArray[i];
        }
        return f;
    }

    /*
     * Enabled aggressive block sorting
     */
    void setPara(CharSequence charSequence, int n, int n2, TextDirectionHeuristic textDirectionHeuristic) {
        int n3;
        this.mText = charSequence;
        this.mTextStart = n;
        this.mLen = n3 = n2 - n;
        this.mPos = 0;
        if (this.mWidths == null || this.mWidths.length < n3) {
            this.mWidths = ArrayUtils.newUnpaddedFloatArray(n3);
        }
        if (this.mChars == null || this.mChars.length < n3) {
            this.mChars = ArrayUtils.newUnpaddedCharArray(n3);
        }
        TextUtils.getChars(charSequence, n, n2, this.mChars, 0);
        if (charSequence instanceof Spanned) {
            Spanned spanned = (Spanned)charSequence;
            ReplacementSpan[] replacementSpanArray = spanned.getSpans(n, n2, ReplacementSpan.class);
            for (int i = 0; i < replacementSpanArray.length; ++i) {
                int n4 = spanned.getSpanStart(replacementSpanArray[i]) - n;
                int n5 = spanned.getSpanEnd(replacementSpanArray[i]) - n;
                if (n4 < 0) {
                    n4 = 0;
                }
                if (n5 > n3) {
                    n5 = n3;
                }
                for (int j = n4; j < n5; ++j) {
                    this.mChars[j] = 65532;
                }
            }
        }
        if ((textDirectionHeuristic == TextDirectionHeuristics.LTR || textDirectionHeuristic == TextDirectionHeuristics.FIRSTSTRONG_LTR || textDirectionHeuristic == TextDirectionHeuristics.ANYRTL_LTR) && TextUtils.doesNotNeedBidi(this.mChars, 0, n3)) {
            this.mDir = 1;
            this.mEasy = true;
            return;
        }
        if (this.mLevels == null || this.mLevels.length < n3) {
            this.mLevels = ArrayUtils.newUnpaddedByteArray(n3);
        }
        int n6 = textDirectionHeuristic == TextDirectionHeuristics.LTR ? 1 : (textDirectionHeuristic == TextDirectionHeuristics.RTL ? -1 : (textDirectionHeuristic == TextDirectionHeuristics.FIRSTSTRONG_LTR ? 2 : (textDirectionHeuristic == TextDirectionHeuristics.FIRSTSTRONG_RTL ? -2 : (textDirectionHeuristic.isRtl(this.mChars, 0, n3) ? -1 : 1))));
        this.mDir = AndroidBidi.bidi(n6, this.mChars, this.mLevels, n3, false);
        this.mEasy = false;
    }

    void setPos(int n) {
        this.mPos = n - this.mTextStart;
    }
}

