/*
 * Decompiled with CFR 0.152.
 */
package android.text.util;

import android.telephony.PhoneNumberUtils;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.method.LinkMovementMethod;
import android.text.method.MovementMethod;
import android.text.style.URLSpan;
import android.text.util.LinkSpec;
import android.util.Patterns;
import android.webkit.WebView;
import android.widget.TextView;
import com.android.i18n.phonenumbers.PhoneNumberMatch;
import com.android.i18n.phonenumbers.PhoneNumberUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Linkify {
    public static final int ALL = 15;
    public static final int EMAIL_ADDRESSES = 2;
    public static final int MAP_ADDRESSES = 8;
    public static final int PHONE_NUMBERS = 4;
    private static final int PHONE_NUMBER_MINIMUM_DIGITS = 5;
    public static final int WEB_URLS = 1;
    public static final MatchFilter sPhoneNumberMatchFilter;
    public static final TransformFilter sPhoneNumberTransformFilter;
    public static final MatchFilter sUrlMatchFilter;

    static {
        sUrlMatchFilter = new MatchFilter(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public final boolean acceptMatch(CharSequence charSequence, int n, int n2) {
                return n == 0 || charSequence.charAt(n - 1) != '@';
            }
        };
        sPhoneNumberMatchFilter = new MatchFilter(){

            @Override
            public final boolean acceptMatch(CharSequence charSequence, int n, int n2) {
                int n3 = 0;
                for (int i = n; i < n2; ++i) {
                    if (!Character.isDigit(charSequence.charAt(i)) || ++n3 < 5) continue;
                    return true;
                }
                return false;
            }
        };
        sPhoneNumberTransformFilter = new TransformFilter(){

            @Override
            public final String transformUrl(Matcher matcher, String string2) {
                return Patterns.digitsAndPlusOnly(matcher);
            }
        };
    }

    private static final void addLinkMovementMethod(TextView textView) {
        MovementMethod movementMethod = textView.getMovementMethod();
        if ((movementMethod == null || !(movementMethod instanceof LinkMovementMethod)) && textView.getLinksClickable()) {
            textView.setMovementMethod(LinkMovementMethod.getInstance());
        }
    }

    public static final void addLinks(TextView textView, Pattern pattern, String string2) {
        Linkify.addLinks(textView, pattern, string2, null, null);
    }

    public static final void addLinks(TextView textView, Pattern pattern, String string2, MatchFilter matchFilter, TransformFilter transformFilter) {
        SpannableString spannableString = SpannableString.valueOf(textView.getText());
        if (Linkify.addLinks(spannableString, pattern, string2, matchFilter, transformFilter)) {
            textView.setText(spannableString);
            Linkify.addLinkMovementMethod(textView);
        }
    }

    public static final boolean addLinks(Spannable spannable, int n) {
        if (n == 0) {
            return false;
        }
        URLSpan[] uRLSpanArray = spannable.getSpans(0, spannable.length(), URLSpan.class);
        for (int i = -1 + uRLSpanArray.length; i >= 0; --i) {
            spannable.removeSpan(uRLSpanArray[i]);
        }
        ArrayList<LinkSpec> arrayList = new ArrayList<LinkSpec>();
        if ((n & 1) != 0) {
            Linkify.gatherLinks(arrayList, spannable, Patterns.WEB_URL, new String[]{"http://", "https://", "rtsp://"}, sUrlMatchFilter, null);
        }
        if ((n & 2) != 0) {
            Linkify.gatherLinks(arrayList, spannable, Patterns.EMAIL_ADDRESS, new String[]{"mailto:"}, null, null);
        }
        if ((n & 4) != 0) {
            Linkify.gatherTelLinks(arrayList, spannable);
        }
        if ((n & 8) != 0) {
            Linkify.gatherMapLinks(arrayList, spannable);
        }
        Linkify.pruneOverlaps(arrayList);
        if (arrayList.size() == 0) {
            return false;
        }
        for (LinkSpec linkSpec : arrayList) {
            Linkify.applyLink(linkSpec.url, linkSpec.start, linkSpec.end, spannable);
        }
        return true;
    }

    public static final boolean addLinks(Spannable spannable, Pattern pattern, String string2) {
        return Linkify.addLinks(spannable, pattern, string2, null, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final boolean addLinks(Spannable spannable, Pattern pattern, String string2, MatchFilter matchFilter, TransformFilter transformFilter) {
        boolean bl = false;
        String string3 = string2 == null ? "" : string2.toLowerCase(Locale.ROOT);
        Matcher matcher = pattern.matcher(spannable);
        while (matcher.find()) {
            int n = matcher.start();
            int n2 = matcher.end();
            boolean bl2 = true;
            if (matchFilter != null) {
                bl2 = matchFilter.acceptMatch(spannable, n, n2);
            }
            if (!bl2) continue;
            Linkify.applyLink(Linkify.makeUrl(matcher.group(0), new String[]{string3}, matcher, transformFilter), n, n2, spannable);
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final boolean addLinks(TextView textView, int n) {
        if (n == 0) return false;
        CharSequence charSequence = textView.getText();
        if (charSequence instanceof Spannable) {
            if (!Linkify.addLinks((Spannable)charSequence, n)) return false;
            Linkify.addLinkMovementMethod(textView);
            return true;
        }
        SpannableString spannableString = SpannableString.valueOf(charSequence);
        if (!Linkify.addLinks(spannableString, n)) {
            return false;
        }
        Linkify.addLinkMovementMethod(textView);
        textView.setText(spannableString);
        return true;
    }

    private static final void applyLink(String string2, int n, int n2, Spannable spannable) {
        spannable.setSpan(new URLSpan(string2), n, n2, 33);
    }

    private static final void gatherLinks(ArrayList<LinkSpec> arrayList, Spannable spannable, Pattern pattern, String[] stringArray, MatchFilter matchFilter, TransformFilter transformFilter) {
        Matcher matcher = pattern.matcher(spannable);
        while (matcher.find()) {
            int n = matcher.start();
            int n2 = matcher.end();
            if (matchFilter != null && !matchFilter.acceptMatch(spannable, n, n2)) continue;
            LinkSpec linkSpec = new LinkSpec();
            linkSpec.url = Linkify.makeUrl(matcher.group(0), stringArray, matcher, transformFilter);
            linkSpec.start = n;
            linkSpec.end = n2;
            arrayList.add(linkSpec);
        }
    }

    private static final void gatherMapLinks(ArrayList<LinkSpec> arrayList, Spannable spannable) {
        String string2 = spannable.toString();
        int n = 0;
        while (true) {
            String string3;
            int n2;
            String string4;
            block8: {
                try {
                    string4 = WebView.findAddress(string2);
                    if (string4 == null) break;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    return;
                }
                n2 = string2.indexOf(string4);
                if (n2 >= 0) break block8;
                return;
            }
            LinkSpec linkSpec = new LinkSpec();
            int n3 = n2 + string4.length();
            linkSpec.start = n + n2;
            linkSpec.end = n + n3;
            string2 = string3 = string2.substring(n3);
            n += n3;
            try {
                String string5 = URLEncoder.encode(string4, "UTF-8");
                linkSpec.url = "geo:0,0?q=" + string5;
                arrayList.add(linkSpec);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
            continue;
            break;
        }
    }

    private static final void gatherTelLinks(ArrayList<LinkSpec> arrayList, Spannable spannable) {
        for (PhoneNumberMatch phoneNumberMatch : PhoneNumberUtil.getInstance().findNumbers((CharSequence)spannable.toString(), Locale.getDefault().getCountry(), PhoneNumberUtil.Leniency.POSSIBLE, Long.MAX_VALUE)) {
            LinkSpec linkSpec = new LinkSpec();
            linkSpec.url = "tel:" + PhoneNumberUtils.normalizeNumber(phoneNumberMatch.rawString());
            linkSpec.start = phoneNumberMatch.start();
            linkSpec.end = phoneNumberMatch.end();
            arrayList.add(linkSpec);
        }
    }

    private static final String makeUrl(String string2, String[] stringArray, Matcher matcher, TransformFilter transformFilter) {
        if (transformFilter != null) {
            string2 = transformFilter.transformUrl(matcher, string2);
        }
        int n = 0;
        while (true) {
            block8: {
                boolean bl;
                block7: {
                    int n2 = stringArray.length;
                    bl = false;
                    if (n >= n2) break block7;
                    String string3 = stringArray[n];
                    int n3 = stringArray[n].length();
                    if (!string2.regionMatches(true, 0, string3, 0, n3)) break block8;
                    bl = true;
                    String string4 = stringArray[n];
                    int n4 = stringArray[n].length();
                    if (!string2.regionMatches(false, 0, string4, 0, n4)) {
                        string2 = stringArray[n] + string2.substring(stringArray[n].length());
                    }
                }
                if (!bl) {
                    string2 = stringArray[0] + string2;
                }
                return string2;
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final void pruneOverlaps(ArrayList<LinkSpec> arrayList) {
        Collections.sort(arrayList, new Comparator<LinkSpec>(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public final int compare(LinkSpec linkSpec, LinkSpec linkSpec2) {
                block6: {
                    block5: {
                        if (linkSpec.start < linkSpec2.start) break block5;
                        if (linkSpec.start > linkSpec2.start) {
                            return 1;
                        }
                        if (linkSpec.end < linkSpec2.end) {
                            return 1;
                        }
                        if (linkSpec.end <= linkSpec2.end) break block6;
                    }
                    return -1;
                }
                return 0;
            }

            @Override
            public final boolean equals(Object object) {
                return false;
            }
        });
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n - 1) {
            LinkSpec linkSpec = arrayList.get(n2);
            LinkSpec linkSpec2 = arrayList.get(n2 + 1);
            int n3 = -1;
            if (linkSpec.start <= linkSpec2.start && linkSpec.end > linkSpec2.start) {
                if (linkSpec2.end <= linkSpec.end) {
                    n3 = n2 + 1;
                } else if (linkSpec.end - linkSpec.start > linkSpec2.end - linkSpec2.start) {
                    n3 = n2 + 1;
                } else if (linkSpec.end - linkSpec.start < linkSpec2.end - linkSpec2.start) {
                    n3 = n2;
                }
                if (n3 != -1) {
                    arrayList.remove(n3);
                    --n;
                    continue;
                }
            }
            ++n2;
        }
        return;
    }

    public static interface MatchFilter {
        public boolean acceptMatch(CharSequence var1, int var2, int var3);
    }

    public static interface TransformFilter {
        public String transformUrl(Matcher var1, String var2);
    }
}

