/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.RectEvaluator;
import android.animation.TypeEvaluator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.transition.Transition;
import android.transition.TransitionUtils;
import android.transition.TransitionValues;
import android.util.AttributeSet;
import android.util.IntProperty;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import java.util.Map;

public class ChangeBounds
extends Transition {
    private static final Property<Drawable, PointF> DRAWABLE_ORIGIN_PROPERTY;
    private static final String LOG_TAG = "ChangeBounds";
    private static final String PROPNAME_BOUNDS = "android:changeBounds:bounds";
    private static final String PROPNAME_PARENT = "android:changeBounds:parent";
    private static final String PROPNAME_WINDOW_X = "android:changeBounds:windowX";
    private static final String PROPNAME_WINDOW_Y = "android:changeBounds:windowY";
    private static RectEvaluator sRectEvaluator;
    private static final String[] sTransitionProperties;
    boolean mReparent = false;
    boolean mResizeClip = false;
    int[] tempLocation = new int[2];

    static {
        sTransitionProperties = new String[]{PROPNAME_BOUNDS, PROPNAME_PARENT, PROPNAME_WINDOW_X, PROPNAME_WINDOW_Y};
        DRAWABLE_ORIGIN_PROPERTY = new Property<Drawable, PointF>(PointF.class, "boundsOrigin"){
            private Rect mBounds = new Rect();

            @Override
            public PointF get(Drawable drawable2) {
                drawable2.copyBounds(this.mBounds);
                return new PointF(this.mBounds.left, this.mBounds.top);
            }

            @Override
            public void set(Drawable drawable2, PointF pointF) {
                drawable2.copyBounds(this.mBounds);
                this.mBounds.offsetTo(Math.round(pointF.x), Math.round(pointF.y));
                drawable2.setBounds(this.mBounds);
            }
        };
        sRectEvaluator = new RectEvaluator();
    }

    public ChangeBounds() {
    }

    public ChangeBounds(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    private void captureValues(TransitionValues transitionValues) {
        View view = transitionValues.view;
        if (view.isLaidOut() || view.getWidth() != 0 || view.getHeight() != 0) {
            transitionValues.values.put(PROPNAME_BOUNDS, new Rect(view.getLeft(), view.getTop(), view.getRight(), view.getBottom()));
            transitionValues.values.put(PROPNAME_PARENT, transitionValues.view.getParent());
            if (this.mReparent) {
                transitionValues.view.getLocationInWindow(this.tempLocation);
                transitionValues.values.put(PROPNAME_WINDOW_X, this.tempLocation[0]);
                transitionValues.values.put(PROPNAME_WINDOW_Y, this.tempLocation[1]);
            }
        }
    }

    private boolean parentMatches(View view, View view2) {
        TransitionValues transitionValues;
        block3: {
            block4: {
                boolean bl;
                block2: {
                    bl = true;
                    if (!this.mReparent) break block2;
                    transitionValues = this.getMatchedTransitionValues(view, true);
                    if (transitionValues != null) break block3;
                    if (view != view2) break block4;
                    bl = true;
                }
                return bl;
            }
            return false;
        }
        return view2 == transitionValues.view;
    }

    @Override
    public void captureEndValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    @Override
    public void captureStartValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Animator createAnimator(final ViewGroup viewGroup, TransitionValues transitionValues, TransitionValues transitionValues2) {
        View view;
        block31: {
            ObjectAnimator objectAnimator;
            ObjectAnimator objectAnimator2;
            block46: {
                int n;
                int n2;
                int n3;
                int n4;
                block45: {
                    int n5;
                    int n6;
                    block44: {
                        float f;
                        float f2;
                        block43: {
                            int n7;
                            int n8;
                            int n9;
                            int n10;
                            block36: {
                                Animator animator2;
                                block38: {
                                    ObjectAnimator objectAnimator3;
                                    ObjectAnimator objectAnimator4;
                                    block42: {
                                        int n11;
                                        int n12;
                                        int n13;
                                        int n14;
                                        block41: {
                                            block40: {
                                                block39: {
                                                    block37: {
                                                        int n15;
                                                        block33: {
                                                            block35: {
                                                                block34: {
                                                                    block32: {
                                                                        if (transitionValues == null) return null;
                                                                        if (transitionValues2 == null) {
                                                                            return null;
                                                                        }
                                                                        Map<String, Object> map = transitionValues.values;
                                                                        Map<String, Object> map2 = transitionValues2.values;
                                                                        ViewGroup viewGroup2 = (ViewGroup)map.get(PROPNAME_PARENT);
                                                                        ViewGroup viewGroup3 = (ViewGroup)map2.get(PROPNAME_PARENT);
                                                                        if (viewGroup2 == null) return null;
                                                                        if (viewGroup3 == null) {
                                                                            return null;
                                                                        }
                                                                        view = transitionValues2.view;
                                                                        if (!this.parentMatches(viewGroup2, viewGroup3)) break block31;
                                                                        Rect rect = (Rect)transitionValues.values.get(PROPNAME_BOUNDS);
                                                                        Rect rect2 = (Rect)transitionValues2.values.get(PROPNAME_BOUNDS);
                                                                        n10 = rect.left;
                                                                        n9 = rect2.left;
                                                                        n8 = rect.top;
                                                                        n7 = rect2.top;
                                                                        n14 = rect.right;
                                                                        n13 = rect2.right;
                                                                        n12 = rect.bottom;
                                                                        n11 = rect2.bottom;
                                                                        n4 = n14 - n10;
                                                                        n3 = n12 - n8;
                                                                        n2 = n13 - n9;
                                                                        n = n11 - n7;
                                                                        if (n4 != 0 && n3 != 0) break block32;
                                                                        n15 = 0;
                                                                        if (n2 == 0) break block33;
                                                                        n15 = 0;
                                                                        if (n == 0) break block33;
                                                                    }
                                                                    if (n10 != n9) break block34;
                                                                    n15 = 0;
                                                                    if (n8 == n7) break block35;
                                                                }
                                                                n15 = 0 + 1;
                                                            }
                                                            if (n14 != n13 || n12 != n11) {
                                                                ++n15;
                                                            }
                                                        }
                                                        if (n15 <= 0) return null;
                                                        if (this.mResizeClip) break block36;
                                                        if (n4 != n2 || n3 != n) break block37;
                                                        view.offsetLeftAndRight(n10 - view.getLeft());
                                                        view.offsetTopAndBottom(n8 - view.getTop());
                                                        Path path = this.getPathMotion().getPath(0.0f, 0.0f, n9 - n10, n7 - n8);
                                                        animator2 = ObjectAnimator.ofInt(view, new HorizontalOffsetProperty(), new VerticalOffsetProperty(), path);
                                                        break block38;
                                                    }
                                                    if (n10 != n9) {
                                                        view.setLeft(n10);
                                                    }
                                                    if (n8 != n7) {
                                                        view.setTop(n8);
                                                    }
                                                    if (n14 != n13) {
                                                        view.setRight(n14);
                                                    }
                                                    if (n12 != n11) {
                                                        view.setBottom(n12);
                                                    }
                                                    if (n10 != n9) break block39;
                                                    objectAnimator4 = null;
                                                    if (n8 == n7) break block40;
                                                }
                                                objectAnimator4 = ObjectAnimator.ofInt((Object)view, "left", "top", this.getPathMotion().getPath(n10, n8, n9, n7));
                                            }
                                            if (n14 != n13) break block41;
                                            objectAnimator3 = null;
                                            if (n12 == n11) break block42;
                                        }
                                        objectAnimator3 = ObjectAnimator.ofInt((Object)view, "right", "bottom", this.getPathMotion().getPath(n14, n12, n13, n11));
                                    }
                                    animator2 = TransitionUtils.mergeAnimators(objectAnimator4, objectAnimator3);
                                }
                                if (!(view.getParent() instanceof ViewGroup)) return animator2;
                                final ViewGroup viewGroup4 = (ViewGroup)view.getParent();
                                viewGroup4.suppressLayout(true);
                                Transition.TransitionListenerAdapter transitionListenerAdapter = new Transition.TransitionListenerAdapter(){
                                    boolean mCanceled = false;

                                    @Override
                                    public void onTransitionCancel(Transition transition2) {
                                        viewGroup4.suppressLayout(false);
                                        this.mCanceled = true;
                                    }

                                    @Override
                                    public void onTransitionEnd(Transition transition2) {
                                        if (!this.mCanceled) {
                                            viewGroup4.suppressLayout(false);
                                        }
                                    }

                                    @Override
                                    public void onTransitionPause(Transition transition2) {
                                        viewGroup4.suppressLayout(false);
                                    }

                                    @Override
                                    public void onTransitionResume(Transition transition2) {
                                        viewGroup4.suppressLayout(true);
                                    }
                                };
                                this.addListener(transitionListenerAdapter);
                                return animator2;
                            }
                            if (n4 != n2) {
                                view.setRight(n9 + Math.max(n4, n2));
                            }
                            if (n3 != n) {
                                view.setBottom(n7 + Math.max(n3, n));
                            }
                            if (n10 != n9) {
                                view.setTranslationX(n10 - n9);
                            }
                            if (n8 != n7) {
                                view.setTranslationY(n8 - n7);
                            }
                            f2 = n9 - n10;
                            f = n7 - n8;
                            n6 = n2 - n4;
                            n5 = n - n3;
                            float f3 = f2 - 0.0f;
                            float f4 = f3 == 0.0f ? 0 : (f3 > 0.0f ? 1 : -1);
                            int n16 = 0;
                            if (f4 != false) {
                                n16 = 0 + 1;
                            }
                            if (f != 0.0f) {
                                ++n16;
                            }
                            if (n6 != 0 || n5 != 0) {
                                int cfr_ignored_2 = n16 + 1;
                            }
                            if (f2 != 0.0f) break block43;
                            float f5 = f - 0.0f;
                            float f6 = f5 == 0.0f ? 0 : (f5 > 0.0f ? 1 : -1);
                            objectAnimator2 = null;
                            if (f6 == false) break block44;
                        }
                        Path path = this.getPathMotion().getPath(0.0f, 0.0f, f2, f);
                        objectAnimator2 = ObjectAnimator.ofFloat(view, View.TRANSLATION_X, View.TRANSLATION_Y, path);
                    }
                    if (n6 != 0) break block45;
                    objectAnimator = null;
                    if (n5 == 0) break block46;
                }
                Rect rect = new Rect(0, 0, n4, n3);
                Rect rect3 = new Rect(0, 0, n2, n);
                objectAnimator = ObjectAnimator.ofObject((Object)view, "clipBounds", (TypeEvaluator)sRectEvaluator, rect, rect3);
            }
            Animator animator3 = TransitionUtils.mergeAnimators(objectAnimator2, objectAnimator);
            if (view.getParent() instanceof ViewGroup) {
                final ViewGroup viewGroup5 = (ViewGroup)view.getParent();
                viewGroup5.suppressLayout(true);
                Transition.TransitionListenerAdapter transitionListenerAdapter = new Transition.TransitionListenerAdapter(){
                    boolean mCanceled = false;

                    @Override
                    public void onTransitionCancel(Transition transition2) {
                        viewGroup5.suppressLayout(false);
                        this.mCanceled = true;
                    }

                    @Override
                    public void onTransitionEnd(Transition transition2) {
                        if (!this.mCanceled) {
                            viewGroup5.suppressLayout(false);
                        }
                    }

                    @Override
                    public void onTransitionPause(Transition transition2) {
                        viewGroup5.suppressLayout(false);
                    }

                    @Override
                    public void onTransitionResume(Transition transition2) {
                        viewGroup5.suppressLayout(true);
                    }
                };
                this.addListener(transitionListenerAdapter);
            }
            animator3.addListener(new AnimatorListenerAdapter(){

                @Override
                public void onAnimationEnd(Animator animator2) {
                    view.setClipBounds(null);
                }
            });
            return animator3;
        }
        int n = (Integer)transitionValues.values.get(PROPNAME_WINDOW_X);
        int n17 = (Integer)transitionValues.values.get(PROPNAME_WINDOW_Y);
        int n18 = (Integer)transitionValues2.values.get(PROPNAME_WINDOW_X);
        int n19 = (Integer)transitionValues2.values.get(PROPNAME_WINDOW_Y);
        if (n == n18) {
            if (n17 == n19) return null;
        }
        viewGroup.getLocationInWindow(this.tempLocation);
        Bitmap bitmap = Bitmap.createBitmap(view.getWidth(), view.getHeight(), Bitmap.Config.ARGB_8888);
        view.draw(new Canvas(bitmap));
        final BitmapDrawable bitmapDrawable = new BitmapDrawable(bitmap);
        final float f = view.getTransitionAlpha();
        view.setTransitionAlpha(0.0f);
        viewGroup.getOverlay().add(bitmapDrawable);
        Path path = this.getPathMotion().getPath(n - this.tempLocation[0], n17 - this.tempLocation[1], n18 - this.tempLocation[0], n19 - this.tempLocation[1]);
        ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder(bitmapDrawable, PropertyValuesHolder.ofObject(DRAWABLE_ORIGIN_PROPERTY, null, path));
        objectAnimator.addListener(new AnimatorListenerAdapter(){

            @Override
            public void onAnimationEnd(Animator animator2) {
                viewGroup.getOverlay().remove(bitmapDrawable);
                view.setTransitionAlpha(f);
            }
        });
        return objectAnimator;
    }

    @Override
    public String[] getTransitionProperties() {
        return sTransitionProperties;
    }

    public void setReparent(boolean bl) {
        this.mReparent = bl;
    }

    public void setResizeClip(boolean bl) {
        this.mResizeClip = bl;
    }

    private static class HorizontalOffsetProperty
    extends OffsetProperty {
        public HorizontalOffsetProperty() {
            super("offsetLeftAndRight");
        }

        @Override
        protected void offsetBy(View view, int n) {
            view.offsetLeftAndRight(n);
        }
    }

    private static abstract class OffsetProperty
    extends IntProperty<View> {
        int mPreviousValue;

        public OffsetProperty(String string2) {
            super(string2);
        }

        @Override
        public Integer get(View view) {
            return null;
        }

        protected abstract void offsetBy(View var1, int var2);

        @Override
        public void setValue(View view, int n) {
            this.offsetBy(view, n - this.mPreviousValue);
            this.mPreviousValue = n;
        }
    }

    private static class VerticalOffsetProperty
    extends OffsetProperty {
        public VerticalOffsetProperty() {
            super("offsetTopAndBottom");
        }

        @Override
        protected void offsetBy(View view, int n) {
            view.offsetTopAndBottom(n);
        }
    }
}

