/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import java.io.IOException;

public class ExceptionUtils {
    private static final String PREFIX_IO = "\u2603";

    public static String getCompleteMessage(String string2, Throwable throwable) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string2 != null) {
            stringBuilder.append(string2).append(": ");
        }
        stringBuilder.append(throwable.getMessage());
        while ((throwable = throwable.getCause()) != null) {
            stringBuilder.append(": ").append(throwable.getMessage());
        }
        return stringBuilder.toString();
    }

    public static String getCompleteMessage(Throwable throwable) {
        return ExceptionUtils.getCompleteMessage(null, throwable);
    }

    public static void maybeUnwrapIOException(RuntimeException runtimeException) throws IOException {
        if (runtimeException instanceof IllegalStateException && runtimeException.getMessage().startsWith(PREFIX_IO)) {
            throw new IOException(runtimeException.getMessage().substring(PREFIX_IO.length()));
        }
    }

    public static RuntimeException wrap(IOException iOException) {
        throw new IllegalStateException(PREFIX_IO + iOException.getMessage());
    }
}

