/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.net.SntpClient;
import android.os.SystemClock;
import android.provider.Settings;
import android.util.TrustedTime;

public class NtpTrustedTime
implements TrustedTime {
    private static final boolean LOGD = false;
    private static final String TAG = "NtpTrustedTime";
    private static NtpTrustedTime sSingleton;
    private long mCachedNtpCertainty;
    private long mCachedNtpElapsedRealtime;
    private long mCachedNtpTime;
    private boolean mHasCache;
    private final String mServer;
    private final long mTimeout;

    private NtpTrustedTime(String string2, long l) {
        this.mServer = string2;
        this.mTimeout = l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NtpTrustedTime getInstance(Context context) {
        synchronized (NtpTrustedTime.class) {
            if (sSingleton != null) return sSingleton;
            Resources resources = context.getResources();
            ContentResolver contentResolver = context.getContentResolver();
            String string2 = resources.getString(17039416);
            long l = resources.getInteger(17694821);
            String string3 = Settings.Global.getString(contentResolver, "ntp_server");
            long l2 = Settings.Global.getLong(contentResolver, "ntp_timeout", l);
            String string4 = string3 != null ? string3 : string2;
            sSingleton = new NtpTrustedTime(string4, l2);
            return sSingleton;
        }
    }

    @Override
    public long currentTimeMillis() {
        if (!this.mHasCache) {
            throw new IllegalStateException("Missing authoritative time source");
        }
        return this.mCachedNtpTime + this.getCacheAge();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean forceRefresh() {
        SntpClient sntpClient;
        if (this.mServer == null || !(sntpClient = new SntpClient()).requestTime(this.mServer, (int)this.mTimeout)) {
            return false;
        }
        this.mHasCache = true;
        this.mCachedNtpTime = sntpClient.getNtpTime();
        this.mCachedNtpElapsedRealtime = sntpClient.getNtpTimeReference();
        this.mCachedNtpCertainty = sntpClient.getRoundTripTime() / 2L;
        return true;
    }

    @Override
    public long getCacheAge() {
        if (this.mHasCache) {
            return SystemClock.elapsedRealtime() - this.mCachedNtpElapsedRealtime;
        }
        return Long.MAX_VALUE;
    }

    @Override
    public long getCacheCertainty() {
        if (this.mHasCache) {
            return this.mCachedNtpCertainty;
        }
        return Long.MAX_VALUE;
    }

    public long getCachedNtpTime() {
        return this.mCachedNtpTime;
    }

    public long getCachedNtpTimeReference() {
        return this.mCachedNtpElapsedRealtime;
    }

    @Override
    public boolean hasCache() {
        return this.mHasCache;
    }
}

