/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.CanvasProperty;
import android.graphics.Paint;
import android.util.SparseIntArray;
import android.view.Choreographer;
import android.view.GLES20RecordingCanvas;
import android.view.RenderNode;
import android.view.View;
import com.android.internal.util.VirtualRefBasePtr;
import com.android.internal.view.animation.FallbackLUTInterpolator;
import com.android.internal.view.animation.HasNativeInterpolator;
import com.android.internal.view.animation.NativeInterpolatorFactory;
import java.util.ArrayList;

public class RenderNodeAnimator
extends Animator {
    public static final int ALPHA = 11;
    public static final int LAST_VALUE = 11;
    public static final int PAINT_ALPHA = 1;
    public static final int PAINT_STROKE_WIDTH = 0;
    public static final int ROTATION = 5;
    public static final int ROTATION_X = 6;
    public static final int ROTATION_Y = 7;
    public static final int SCALE_X = 3;
    public static final int SCALE_Y = 4;
    private static final int STATE_DELAYED = 1;
    private static final int STATE_FINISHED = 3;
    private static final int STATE_PREPARE = 0;
    private static final int STATE_RUNNING = 2;
    public static final int TRANSLATION_X = 0;
    public static final int TRANSLATION_Y = 1;
    public static final int TRANSLATION_Z = 2;
    public static final int X = 8;
    public static final int Y = 9;
    public static final int Z = 10;
    private static ThreadLocal<DelayedAnimationHelper> sAnimationHelper;
    private static final SparseIntArray sViewPropertyAnimatorMap;
    private float mFinalValue;
    private TimeInterpolator mInterpolator;
    private VirtualRefBasePtr mNativePtr;
    private int mRenderProperty = -1;
    private long mStartDelay = 0L;
    private long mStartTime;
    private int mState = 0;
    private RenderNode mTarget;
    private final boolean mUiThreadHandlesDelay;
    private long mUnscaledDuration = 300L;
    private long mUnscaledStartDelay = 0L;
    private View mViewTarget;

    static {
        sViewPropertyAnimatorMap = new SparseIntArray(15){
            {
                this.put(1, 0);
                this.put(2, 1);
                this.put(4, 2);
                this.put(8, 3);
                this.put(16, 4);
                this.put(32, 5);
                this.put(64, 6);
                this.put(128, 7);
                this.put(256, 8);
                this.put(512, 9);
                this.put(1024, 10);
                this.put(2048, 11);
            }
        };
        sAnimationHelper = new ThreadLocal();
    }

    public RenderNodeAnimator(int n, float f) {
        this.mRenderProperty = n;
        this.mFinalValue = f;
        this.mUiThreadHandlesDelay = true;
        this.init(RenderNodeAnimator.nCreateAnimator(n, f));
    }

    public RenderNodeAnimator(int n, int n2, float f, float f2) {
        this.init(RenderNodeAnimator.nCreateRevealAnimator(n, n2, f, f2));
        this.mUiThreadHandlesDelay = true;
    }

    public RenderNodeAnimator(CanvasProperty<Float> canvasProperty, float f) {
        this.init(RenderNodeAnimator.nCreateCanvasPropertyFloatAnimator(canvasProperty.getNativeContainer(), f));
        this.mUiThreadHandlesDelay = false;
    }

    public RenderNodeAnimator(CanvasProperty<Paint> canvasProperty, int n, float f) {
        this.init(RenderNodeAnimator.nCreateCanvasPropertyPaintAnimator(canvasProperty.getNativeContainer(), n, f));
        this.mUiThreadHandlesDelay = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void applyInterpolator() {
        long l;
        if (this.mInterpolator == null) {
            return;
        }
        if (RenderNodeAnimator.isNativeInterpolator(this.mInterpolator)) {
            l = ((NativeInterpolatorFactory)((Object)this.mInterpolator)).createNativeInterpolator();
        } else {
            long l2 = RenderNodeAnimator.nGetDuration(this.mNativePtr.get());
            l = FallbackLUTInterpolator.createNativeInterpolator(this.mInterpolator, l2);
        }
        RenderNodeAnimator.nSetInterpolator(this.mNativePtr.get(), l);
    }

    private static void callOnFinished(RenderNodeAnimator renderNodeAnimator) {
        renderNodeAnimator.onFinished();
    }

    private void checkMutable() {
        if (this.mState != 0) {
            throw new IllegalStateException("Animator has already started, cannot change it now!");
        }
    }

    private ArrayList<Animator.AnimatorListener> cloneListeners() {
        ArrayList arrayList = this.getListeners();
        if (arrayList != null) {
            arrayList = (ArrayList)arrayList.clone();
        }
        return arrayList;
    }

    private void doStart() {
        this.mState = 2;
        RenderNodeAnimator.nStart(this.mNativePtr.get(), this);
        if (this.mRenderProperty == 11) {
            this.mViewTarget.mTransformationInfo.mAlpha = this.mFinalValue;
        }
        this.notifyStartListeners();
        if (this.mViewTarget != null) {
            this.mViewTarget.invalidateViewProperty(true, false);
        }
    }

    private static DelayedAnimationHelper getHelper() {
        DelayedAnimationHelper delayedAnimationHelper = sAnimationHelper.get();
        if (delayedAnimationHelper == null) {
            delayedAnimationHelper = new DelayedAnimationHelper();
            sAnimationHelper.set(delayedAnimationHelper);
        }
        return delayedAnimationHelper;
    }

    private void init(long l) {
        this.mNativePtr = new VirtualRefBasePtr(l);
    }

    static boolean isNativeInterpolator(TimeInterpolator timeInterpolator) {
        return timeInterpolator.getClass().isAnnotationPresent(HasNativeInterpolator.class);
    }

    public static int mapViewPropertyToRenderProperty(int n) {
        return sViewPropertyAnimatorMap.get(n);
    }

    private static native long nCreateAnimator(int var0, float var1);

    private static native long nCreateCanvasPropertyFloatAnimator(long var0, float var2);

    private static native long nCreateCanvasPropertyPaintAnimator(long var0, int var2, float var3);

    private static native long nCreateRevealAnimator(int var0, int var1, float var2, float var3);

    private static native void nEnd(long var0);

    private static native long nGetDuration(long var0);

    private static native void nSetAllowRunningAsync(long var0, boolean var2);

    private static native void nSetDuration(long var0, long var2);

    private static native void nSetInterpolator(long var0, long var2);

    private static native void nSetStartDelay(long var0, long var2);

    private static native void nSetStartValue(long var0, float var2);

    private static native void nStart(long var0, RenderNodeAnimator var2);

    /*
     * Enabled aggressive block sorting
     */
    private void notifyStartListeners() {
        ArrayList<Animator.AnimatorListener> arrayList = this.cloneListeners();
        if (arrayList == null) {
            return;
        }
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            arrayList.get(n2).onAnimationStart(this);
            ++n2;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean processDelayed(long l) {
        if (this.mStartTime == 0L) {
            this.mStartTime = l;
            return false;
        } else {
            if (l - this.mStartTime < this.mStartDelay) return false;
            this.doStart();
            return true;
        }
    }

    private void setTarget(RenderNode renderNode) {
        if (this.mTarget != null) {
            throw new IllegalStateException("Target already set!");
        }
        this.mTarget = renderNode;
        this.mTarget.addAnimator(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void cancel() {
        if (this.mState != 3) {
            if (this.mState == 1) {
                RenderNodeAnimator.getHelper().removeDelayedAnimation(this);
                this.notifyStartListeners();
            }
            RenderNodeAnimator.nEnd(this.mNativePtr.get());
            ArrayList<Animator.AnimatorListener> arrayList = this.cloneListeners();
            int n = arrayList == null ? 0 : arrayList.size();
            for (int i = 0; i < n; ++i) {
                arrayList.get(i).onAnimationCancel(this);
            }
            if (this.mViewTarget != null) {
                this.mViewTarget.invalidateViewProperty(true, false);
            }
        }
    }

    @Override
    public Animator clone() {
        throw new IllegalStateException("Cannot clone this animator");
    }

    @Override
    public void end() {
        if (this.mState != 3) {
            RenderNodeAnimator.nEnd(this.mNativePtr.get());
        }
    }

    @Override
    public long getDuration() {
        return this.mUnscaledDuration;
    }

    @Override
    public TimeInterpolator getInterpolator() {
        return this.mInterpolator;
    }

    long getNativeAnimator() {
        return this.mNativePtr.get();
    }

    @Override
    public long getStartDelay() {
        return this.mUnscaledStartDelay;
    }

    @Override
    public boolean isRunning() {
        return this.mState == 1 || this.mState == 2;
    }

    @Override
    public boolean isStarted() {
        return this.mState != 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onFinished() {
        if (this.mState == 1) {
            RenderNodeAnimator.getHelper().removeDelayedAnimation(this);
            this.notifyStartListeners();
        }
        this.mState = 3;
        ArrayList<Animator.AnimatorListener> arrayList = this.cloneListeners();
        int n = arrayList == null ? 0 : arrayList.size();
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                this.mNativePtr.release();
                this.mNativePtr = null;
                return;
            }
            arrayList.get(n2).onAnimationEnd(this);
            ++n2;
        }
    }

    @Override
    public void pause() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resume() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAllowRunningAsynchronously(boolean bl) {
        this.checkMutable();
        RenderNodeAnimator.nSetAllowRunningAsync(this.mNativePtr.get(), bl);
    }

    @Override
    public RenderNodeAnimator setDuration(long l) {
        this.checkMutable();
        if (l < 0L) {
            throw new IllegalArgumentException("duration must be positive; " + l);
        }
        this.mUnscaledDuration = l;
        RenderNodeAnimator.nSetDuration(this.mNativePtr.get(), (long)((float)l * ValueAnimator.getDurationScale()));
        return this;
    }

    @Override
    public void setInterpolator(TimeInterpolator timeInterpolator) {
        this.checkMutable();
        this.mInterpolator = timeInterpolator;
    }

    @Override
    public void setStartDelay(long l) {
        this.checkMutable();
        if (l < 0L) {
            throw new IllegalArgumentException("startDelay must be positive; " + l);
        }
        this.mUnscaledStartDelay = l;
        this.mStartDelay = (long)(ValueAnimator.getDurationScale() * (float)l);
    }

    public void setStartValue(float f) {
        this.checkMutable();
        RenderNodeAnimator.nSetStartValue(this.mNativePtr.get(), f);
    }

    public void setTarget(Canvas canvas) {
        if (!(canvas instanceof GLES20RecordingCanvas)) {
            throw new IllegalArgumentException("Not a GLES20RecordingCanvas");
        }
        this.setTarget(((GLES20RecordingCanvas)canvas).mNode);
    }

    public void setTarget(View view) {
        this.mViewTarget = view;
        this.setTarget(this.mViewTarget.mRenderNode);
    }

    @Override
    public void start() {
        if (this.mTarget == null) {
            throw new IllegalStateException("Missing target!");
        }
        if (this.mState != 0) {
            throw new IllegalStateException("Already started!");
        }
        this.mState = 1;
        this.applyInterpolator();
        if (this.mStartDelay <= 0L || !this.mUiThreadHandlesDelay) {
            RenderNodeAnimator.nSetStartDelay(this.mNativePtr.get(), this.mStartDelay);
            this.doStart();
            return;
        }
        RenderNodeAnimator.getHelper().addDelayedAnimation(this);
    }

    private static class DelayedAnimationHelper
    implements Runnable {
        private boolean mCallbackScheduled;
        private final Choreographer mChoreographer;
        private ArrayList<RenderNodeAnimator> mDelayedAnims = new ArrayList();

        public DelayedAnimationHelper() {
            this.mChoreographer = Choreographer.getInstance();
        }

        private void scheduleCallback() {
            if (!this.mCallbackScheduled) {
                this.mCallbackScheduled = true;
                this.mChoreographer.postCallback(1, this, null);
            }
        }

        public void addDelayedAnimation(RenderNodeAnimator renderNodeAnimator) {
            this.mDelayedAnims.add(renderNodeAnimator);
            this.scheduleCallback();
        }

        public void removeDelayedAnimation(RenderNodeAnimator renderNodeAnimator) {
            this.mDelayedAnims.remove(renderNodeAnimator);
        }

        @Override
        public void run() {
            long l = this.mChoreographer.getFrameTime();
            this.mCallbackScheduled = false;
            int n = 0;
            for (int i = 0; i < this.mDelayedAnims.size(); ++i) {
                RenderNodeAnimator renderNodeAnimator = this.mDelayedAnims.get(i);
                if (renderNodeAnimator.processDelayed(l)) continue;
                if (n != i) {
                    this.mDelayedAnims.set(n, renderNodeAnimator);
                }
                ++n;
            }
            while (this.mDelayedAnims.size() > n) {
                this.mDelayedAnims.remove(-1 + this.mDelayedAnims.size());
            }
            if (this.mDelayedAnims.size() > 0) {
                this.scheduleCallback();
            }
        }
    }
}

