/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.view.IWindowFocusObserver;
import android.view.IWindowId;
import java.util.HashMap;

public class WindowId
implements Parcelable {
    public static final Parcelable.Creator<WindowId> CREATOR = new Parcelable.Creator<WindowId>(){

        @Override
        public WindowId createFromParcel(Parcel parcel) {
            IBinder iBinder = parcel.readStrongBinder();
            if (iBinder != null) {
                return new WindowId(iBinder);
            }
            return null;
        }

        public WindowId[] newArray(int n) {
            return new WindowId[n];
        }
    };
    private final IWindowId mToken;

    public WindowId(IBinder iBinder) {
        this.mToken = IWindowId.Stub.asInterface(iBinder);
    }

    public WindowId(IWindowId iWindowId) {
        this.mToken = iWindowId;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object object) {
        if (object instanceof WindowId) {
            return this.mToken.asBinder().equals(((WindowId)object).mToken.asBinder());
        }
        return false;
    }

    public IWindowId getTarget() {
        return this.mToken;
    }

    public int hashCode() {
        return this.mToken.asBinder().hashCode();
    }

    public boolean isFocused() {
        try {
            boolean bl = this.mToken.isFocused();
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerFocusObserver(FocusObserver focusObserver) {
        HashMap<IBinder, WindowId> hashMap = focusObserver.mRegistrations;
        synchronized (hashMap) {
            if (focusObserver.mRegistrations.containsKey(this.mToken.asBinder())) {
                throw new IllegalStateException("Focus observer already registered with input token");
            }
            focusObserver.mRegistrations.put(this.mToken.asBinder(), this);
            try {
                this.mToken.registerFocusObserver(focusObserver.mIObserver);
            }
            catch (RemoteException remoteException) {}
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("IntentSender{");
        stringBuilder.append(Integer.toHexString(System.identityHashCode(this)));
        stringBuilder.append(": ");
        IBinder iBinder = this.mToken != null ? this.mToken.asBinder() : null;
        stringBuilder.append(iBinder);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unregisterFocusObserver(FocusObserver focusObserver) {
        HashMap<IBinder, WindowId> hashMap = focusObserver.mRegistrations;
        synchronized (hashMap) {
            if (focusObserver.mRegistrations.remove(this.mToken.asBinder()) == null) {
                throw new IllegalStateException("Focus observer not registered with input token");
            }
            try {
                this.mToken.unregisterFocusObserver(focusObserver.mIObserver);
            }
            catch (RemoteException remoteException) {}
            return;
        }
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeStrongBinder(this.mToken.asBinder());
    }

    public static abstract class FocusObserver {
        final Handler mHandler;
        final IWindowFocusObserver.Stub mIObserver = new IWindowFocusObserver.Stub(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void focusGained(IBinder iBinder) {
                HashMap<IBinder, WindowId> hashMap = FocusObserver.this.mRegistrations;
                // MONITORENTER : hashMap
                WindowId windowId = FocusObserver.this.mRegistrations.get(iBinder);
                // MONITOREXIT : hashMap
                if (FocusObserver.this.mHandler != null) {
                    FocusObserver.this.mHandler.sendMessage(FocusObserver.this.mHandler.obtainMessage(1, windowId));
                    return;
                }
                FocusObserver.this.onFocusGained(windowId);
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void focusLost(IBinder iBinder) {
                HashMap<IBinder, WindowId> hashMap = FocusObserver.this.mRegistrations;
                // MONITORENTER : hashMap
                WindowId windowId = FocusObserver.this.mRegistrations.get(iBinder);
                // MONITOREXIT : hashMap
                if (FocusObserver.this.mHandler != null) {
                    FocusObserver.this.mHandler.sendMessage(FocusObserver.this.mHandler.obtainMessage(2, windowId));
                    return;
                }
                FocusObserver.this.onFocusLost(windowId);
            }
        };
        final HashMap<IBinder, WindowId> mRegistrations = new HashMap();

        public FocusObserver() {
            this.mHandler = new H();
        }

        public abstract void onFocusGained(WindowId var1);

        public abstract void onFocusLost(WindowId var1);

        class H
        extends Handler {
            H() {
            }

            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    default: {
                        super.handleMessage(message);
                        return;
                    }
                    case 1: {
                        FocusObserver.this.onFocusGained((WindowId)message.obj);
                        return;
                    }
                    case 2: 
                }
                FocusObserver.this.onFocusLost((WindowId)message.obj);
            }
        }
    }
}

