/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Insets;
import android.graphics.Rect;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewManager;

public interface WindowManager
extends ViewManager {
    public Display getDefaultDisplay();

    public void removeViewImmediate(View var1);

    public static class BadTokenException
    extends RuntimeException {
        public BadTokenException() {
        }

        public BadTokenException(String string2) {
            super(string2);
        }
    }

    public static class InvalidDisplayException
    extends RuntimeException {
        public InvalidDisplayException() {
        }

        public InvalidDisplayException(String string2) {
            super(string2);
        }
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams
    implements Parcelable {
        public static final int ALPHA_CHANGED = 128;
        public static final int ANIMATION_CHANGED = 16;
        public static final float BRIGHTNESS_OVERRIDE_FULL = 1.0f;
        public static final float BRIGHTNESS_OVERRIDE_NONE = -1.0f;
        public static final float BRIGHTNESS_OVERRIDE_OFF = 0.0f;
        public static final int BUTTON_BRIGHTNESS_CHANGED = 8192;
        public static final Parcelable.Creator<LayoutParams> CREATOR = new Parcelable.Creator<LayoutParams>(){

            @Override
            public LayoutParams createFromParcel(Parcel parcel) {
                return new LayoutParams(parcel);
            }

            public LayoutParams[] newArray(int n) {
                return new LayoutParams[n];
            }
        };
        public static final int DIM_AMOUNT_CHANGED = 32;
        public static final int EVERYTHING_CHANGED = -1;
        public static final int FIRST_APPLICATION_WINDOW = 1;
        public static final int FIRST_SUB_WINDOW = 1000;
        public static final int FIRST_SYSTEM_WINDOW = 2000;
        public static final int FLAGS_CHANGED = 4;
        public static final int FLAG_ALLOW_LOCK_WHILE_SCREEN_ON = 1;
        public static final int FLAG_ALT_FOCUSABLE_IM = 131072;
        @Deprecated
        public static final int FLAG_BLUR_BEHIND = 4;
        public static final int FLAG_DIM_BEHIND = 2;
        public static final int FLAG_DISMISS_KEYGUARD = 0x400000;
        @Deprecated
        public static final int FLAG_DITHER = 4096;
        public static final int FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS = Integer.MIN_VALUE;
        public static final int FLAG_FORCE_NOT_FULLSCREEN = 2048;
        public static final int FLAG_FULLSCREEN = 1024;
        public static final int FLAG_HARDWARE_ACCELERATED = 0x1000000;
        public static final int FLAG_IGNORE_CHEEK_PRESSES = 32768;
        public static final int FLAG_KEEP_SCREEN_ON = 128;
        public static final int FLAG_LAYOUT_INSET_DECOR = 65536;
        public static final int FLAG_LAYOUT_IN_OVERSCAN = 0x2000000;
        public static final int FLAG_LAYOUT_IN_SCREEN = 256;
        public static final int FLAG_LAYOUT_NO_LIMITS = 512;
        public static final int FLAG_LOCAL_FOCUS_MODE = 0x10000000;
        public static final int FLAG_NEEDS_MENU_KEY = 0x40000000;
        public static final int FLAG_NOT_FOCUSABLE = 8;
        public static final int FLAG_NOT_TOUCHABLE = 16;
        public static final int FLAG_NOT_TOUCH_MODAL = 32;
        public static final int FLAG_SCALED = 16384;
        public static final int FLAG_SECURE = 8192;
        public static final int FLAG_SHOW_WALLPAPER = 0x100000;
        public static final int FLAG_SHOW_WHEN_LOCKED = 524288;
        public static final int FLAG_SLIPPERY = 0x20000000;
        public static final int FLAG_SPLIT_TOUCH = 0x800000;
        @Deprecated
        public static final int FLAG_TOUCHABLE_WHEN_WAKING = 64;
        public static final int FLAG_TRANSLUCENT_NAVIGATION = 0x8000000;
        public static final int FLAG_TRANSLUCENT_STATUS = 0x4000000;
        public static final int FLAG_TURN_SCREEN_ON = 0x200000;
        public static final int FLAG_WATCH_OUTSIDE_TOUCH = 262144;
        public static final int FORMAT_CHANGED = 8;
        public static final int INPUT_FEATURES_CHANGED = 65536;
        public static final int INPUT_FEATURE_DISABLE_POINTER_GESTURES = 1;
        public static final int INPUT_FEATURE_DISABLE_USER_ACTIVITY = 4;
        public static final int INPUT_FEATURE_NO_INPUT_CHANNEL = 2;
        public static final int LAST_APPLICATION_WINDOW = 99;
        public static final int LAST_SUB_WINDOW = 1999;
        public static final int LAST_SYSTEM_WINDOW = 2999;
        public static final int LAYOUT_CHANGED = 1;
        public static final int MEMORY_TYPE_CHANGED = 256;
        @Deprecated
        public static final int MEMORY_TYPE_GPU = 2;
        @Deprecated
        public static final int MEMORY_TYPE_HARDWARE = 1;
        @Deprecated
        public static final int MEMORY_TYPE_NORMAL = 0;
        @Deprecated
        public static final int MEMORY_TYPE_PUSH_BUFFERS = 3;
        public static final int PREFERRED_REFRESH_RATE_CHANGED = 0x200000;
        public static final int PRIVATE_FLAGS_CHANGED = 131072;
        public static final int PRIVATE_FLAG_COMPATIBLE_WINDOW = 128;
        public static final int PRIVATE_FLAG_FAKE_HARDWARE_ACCELERATED = 1;
        public static final int PRIVATE_FLAG_FORCE_HARDWARE_ACCELERATED = 2;
        public static final int PRIVATE_FLAG_INHERIT_TRANSLUCENT_DECOR = 512;
        public static final int PRIVATE_FLAG_KEYGUARD = 1024;
        public static final int PRIVATE_FLAG_NO_MOVE_ANIMATION = 64;
        public static final int PRIVATE_FLAG_SET_NEEDS_MENU_KEY = 8;
        public static final int PRIVATE_FLAG_SHOW_FOR_ALL_USERS = 16;
        public static final int PRIVATE_FLAG_SYSTEM_ERROR = 256;
        public static final int PRIVATE_FLAG_WANTS_OFFSET_NOTIFICATIONS = 4;
        public static final int ROTATION_ANIMATION_CHANGED = 4096;
        public static final int ROTATION_ANIMATION_CROSSFADE = 1;
        public static final int ROTATION_ANIMATION_JUMPCUT = 2;
        public static final int ROTATION_ANIMATION_ROTATE = 0;
        public static final int SCREEN_BRIGHTNESS_CHANGED = 2048;
        public static final int SCREEN_ORIENTATION_CHANGED = 1024;
        public static final int SOFT_INPUT_ADJUST_NOTHING = 48;
        public static final int SOFT_INPUT_ADJUST_PAN = 32;
        public static final int SOFT_INPUT_ADJUST_RESIZE = 16;
        public static final int SOFT_INPUT_ADJUST_UNSPECIFIED = 0;
        public static final int SOFT_INPUT_IS_FORWARD_NAVIGATION = 256;
        public static final int SOFT_INPUT_MASK_ADJUST = 240;
        public static final int SOFT_INPUT_MASK_STATE = 15;
        public static final int SOFT_INPUT_MODE_CHANGED = 512;
        public static final int SOFT_INPUT_STATE_ALWAYS_HIDDEN = 3;
        public static final int SOFT_INPUT_STATE_ALWAYS_VISIBLE = 5;
        public static final int SOFT_INPUT_STATE_HIDDEN = 2;
        public static final int SOFT_INPUT_STATE_UNCHANGED = 1;
        public static final int SOFT_INPUT_STATE_UNSPECIFIED = 0;
        public static final int SOFT_INPUT_STATE_VISIBLE = 4;
        public static final int SURFACE_INSETS_CHANGED = 0x100000;
        public static final int SYSTEM_UI_LISTENER_CHANGED = 32768;
        public static final int SYSTEM_UI_VISIBILITY_CHANGED = 16384;
        public static final int TITLE_CHANGED = 64;
        public static final int TRANSLUCENT_FLAGS_CHANGED = 524288;
        public static final int TYPE_APPLICATION = 2;
        public static final int TYPE_APPLICATION_ATTACHED_DIALOG = 1003;
        public static final int TYPE_APPLICATION_MEDIA = 1001;
        public static final int TYPE_APPLICATION_MEDIA_OVERLAY = 1004;
        public static final int TYPE_APPLICATION_PANEL = 1000;
        public static final int TYPE_APPLICATION_STARTING = 3;
        public static final int TYPE_APPLICATION_SUB_PANEL = 1002;
        public static final int TYPE_BASE_APPLICATION = 1;
        public static final int TYPE_BOOT_PROGRESS = 2021;
        public static final int TYPE_CHANGED = 2;
        public static final int TYPE_DISPLAY_OVERLAY = 2026;
        public static final int TYPE_DRAG = 2016;
        public static final int TYPE_DREAM = 2023;
        public static final int TYPE_HIDDEN_NAV_CONSUMER = 2022;
        public static final int TYPE_INPUT_METHOD = 2011;
        public static final int TYPE_INPUT_METHOD_DIALOG = 2012;
        public static final int TYPE_KEYGUARD = 2004;
        public static final int TYPE_KEYGUARD_DIALOG = 2009;
        public static final int TYPE_KEYGUARD_SCRIM = 2029;
        public static final int TYPE_MAGNIFICATION_OVERLAY = 2027;
        public static final int TYPE_NAVIGATION_BAR = 2019;
        public static final int TYPE_NAVIGATION_BAR_PANEL = 2024;
        public static final int TYPE_PHONE = 2002;
        public static final int TYPE_POINTER = 2018;
        public static final int TYPE_PRIORITY_PHONE = 2007;
        public static final int TYPE_PRIVATE_PRESENTATION = 2030;
        public static final int TYPE_RECENTS_OVERLAY = 2028;
        public static final int TYPE_SEARCH_BAR = 2001;
        public static final int TYPE_SECURE_SYSTEM_OVERLAY = 2015;
        public static final int TYPE_STATUS_BAR = 2000;
        public static final int TYPE_STATUS_BAR_PANEL = 2014;
        public static final int TYPE_STATUS_BAR_SUB_PANEL = 2017;
        public static final int TYPE_SYSTEM_ALERT = 2003;
        public static final int TYPE_SYSTEM_DIALOG = 2008;
        public static final int TYPE_SYSTEM_ERROR = 2010;
        public static final int TYPE_SYSTEM_OVERLAY = 2006;
        public static final int TYPE_TOAST = 2005;
        public static final int TYPE_UNIVERSE_BACKGROUND = 2025;
        public static final int TYPE_VOICE_INTERACTION = 2031;
        public static final int TYPE_VOLUME_OVERLAY = 2020;
        public static final int TYPE_WALLPAPER = 2013;
        public static final int USER_ACTIVITY_TIMEOUT_CHANGED = 262144;
        public float alpha = 1.0f;
        public float buttonBrightness = -1.0f;
        public float dimAmount = 1.0f;
        @ViewDebug.ExportedProperty(flagMapping={@ViewDebug.FlagToString(equals=1, mask=1, name="FLAG_ALLOW_LOCK_WHILE_SCREEN_ON"), @ViewDebug.FlagToString(equals=2, mask=2, name="FLAG_DIM_BEHIND"), @ViewDebug.FlagToString(equals=4, mask=4, name="FLAG_BLUR_BEHIND"), @ViewDebug.FlagToString(equals=8, mask=8, name="FLAG_NOT_FOCUSABLE"), @ViewDebug.FlagToString(equals=16, mask=16, name="FLAG_NOT_TOUCHABLE"), @ViewDebug.FlagToString(equals=32, mask=32, name="FLAG_NOT_TOUCH_MODAL"), @ViewDebug.FlagToString(equals=64, mask=64, name="FLAG_TOUCHABLE_WHEN_WAKING"), @ViewDebug.FlagToString(equals=128, mask=128, name="FLAG_KEEP_SCREEN_ON"), @ViewDebug.FlagToString(equals=256, mask=256, name="FLAG_LAYOUT_IN_SCREEN"), @ViewDebug.FlagToString(equals=512, mask=512, name="FLAG_LAYOUT_NO_LIMITS"), @ViewDebug.FlagToString(equals=1024, mask=1024, name="FLAG_FULLSCREEN"), @ViewDebug.FlagToString(equals=2048, mask=2048, name="FLAG_FORCE_NOT_FULLSCREEN"), @ViewDebug.FlagToString(equals=4096, mask=4096, name="FLAG_DITHER"), @ViewDebug.FlagToString(equals=8192, mask=8192, name="FLAG_SECURE"), @ViewDebug.FlagToString(equals=16384, mask=16384, name="FLAG_SCALED"), @ViewDebug.FlagToString(equals=32768, mask=32768, name="FLAG_IGNORE_CHEEK_PRESSES"), @ViewDebug.FlagToString(equals=65536, mask=65536, name="FLAG_LAYOUT_INSET_DECOR"), @ViewDebug.FlagToString(equals=131072, mask=131072, name="FLAG_ALT_FOCUSABLE_IM"), @ViewDebug.FlagToString(equals=262144, mask=262144, name="FLAG_WATCH_OUTSIDE_TOUCH"), @ViewDebug.FlagToString(equals=524288, mask=524288, name="FLAG_SHOW_WHEN_LOCKED"), @ViewDebug.FlagToString(equals=0x100000, mask=0x100000, name="FLAG_SHOW_WALLPAPER"), @ViewDebug.FlagToString(equals=0x200000, mask=0x200000, name="FLAG_TURN_SCREEN_ON"), @ViewDebug.FlagToString(equals=0x400000, mask=0x400000, name="FLAG_DISMISS_KEYGUARD"), @ViewDebug.FlagToString(equals=0x800000, mask=0x800000, name="FLAG_SPLIT_TOUCH"), @ViewDebug.FlagToString(equals=0x1000000, mask=0x1000000, name="FLAG_HARDWARE_ACCELERATED"), @ViewDebug.FlagToString(equals=0x10000000, mask=0x10000000, name="FLAG_LOCAL_FOCUS_MODE"), @ViewDebug.FlagToString(equals=0x4000000, mask=0x4000000, name="FLAG_TRANSLUCENT_STATUS"), @ViewDebug.FlagToString(equals=0x8000000, mask=0x8000000, name="FLAG_TRANSLUCENT_NAVIGATION"), @ViewDebug.FlagToString(equals=-2147483648, mask=-2147483648, name="FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS")}, formatToHexString=true)
        public int flags;
        public int format;
        public int gravity;
        public boolean hasSystemUiListeners;
        public float horizontalMargin;
        @ViewDebug.ExportedProperty
        public float horizontalWeight;
        public int inputFeatures;
        private int[] mCompatibilityParamsBackup = null;
        private CharSequence mTitle = "";
        @Deprecated
        public int memoryType;
        public String packageName = null;
        public float preferredRefreshRate;
        public int privateFlags;
        public int rotationAnimation = 0;
        public float screenBrightness = -1.0f;
        public int screenOrientation = -1;
        public int softInputMode;
        public int subtreeSystemUiVisibility;
        public Rect surfaceInsets = new Rect();
        public int systemUiVisibility;
        public IBinder token = null;
        @ViewDebug.ExportedProperty(mapping={@ViewDebug.IntToString(from=1, to="TYPE_BASE_APPLICATION"), @ViewDebug.IntToString(from=2, to="TYPE_APPLICATION"), @ViewDebug.IntToString(from=3, to="TYPE_APPLICATION_STARTING"), @ViewDebug.IntToString(from=1000, to="TYPE_APPLICATION_PANEL"), @ViewDebug.IntToString(from=1001, to="TYPE_APPLICATION_MEDIA"), @ViewDebug.IntToString(from=1002, to="TYPE_APPLICATION_SUB_PANEL"), @ViewDebug.IntToString(from=1003, to="TYPE_APPLICATION_ATTACHED_DIALOG"), @ViewDebug.IntToString(from=1004, to="TYPE_APPLICATION_MEDIA_OVERLAY"), @ViewDebug.IntToString(from=2000, to="TYPE_STATUS_BAR"), @ViewDebug.IntToString(from=2001, to="TYPE_SEARCH_BAR"), @ViewDebug.IntToString(from=2002, to="TYPE_PHONE"), @ViewDebug.IntToString(from=2003, to="TYPE_SYSTEM_ALERT"), @ViewDebug.IntToString(from=2005, to="TYPE_TOAST"), @ViewDebug.IntToString(from=2006, to="TYPE_SYSTEM_OVERLAY"), @ViewDebug.IntToString(from=2007, to="TYPE_PRIORITY_PHONE"), @ViewDebug.IntToString(from=2008, to="TYPE_SYSTEM_DIALOG"), @ViewDebug.IntToString(from=2009, to="TYPE_KEYGUARD_DIALOG"), @ViewDebug.IntToString(from=2010, to="TYPE_SYSTEM_ERROR"), @ViewDebug.IntToString(from=2011, to="TYPE_INPUT_METHOD"), @ViewDebug.IntToString(from=2012, to="TYPE_INPUT_METHOD_DIALOG"), @ViewDebug.IntToString(from=2013, to="TYPE_WALLPAPER"), @ViewDebug.IntToString(from=2014, to="TYPE_STATUS_BAR_PANEL"), @ViewDebug.IntToString(from=2015, to="TYPE_SECURE_SYSTEM_OVERLAY"), @ViewDebug.IntToString(from=2016, to="TYPE_DRAG"), @ViewDebug.IntToString(from=2017, to="TYPE_STATUS_BAR_SUB_PANEL"), @ViewDebug.IntToString(from=2018, to="TYPE_POINTER"), @ViewDebug.IntToString(from=2019, to="TYPE_NAVIGATION_BAR"), @ViewDebug.IntToString(from=2020, to="TYPE_VOLUME_OVERLAY"), @ViewDebug.IntToString(from=2021, to="TYPE_BOOT_PROGRESS"), @ViewDebug.IntToString(from=2022, to="TYPE_HIDDEN_NAV_CONSUMER"), @ViewDebug.IntToString(from=2023, to="TYPE_DREAM"), @ViewDebug.IntToString(from=2024, to="TYPE_NAVIGATION_BAR_PANEL"), @ViewDebug.IntToString(from=2026, to="TYPE_DISPLAY_OVERLAY"), @ViewDebug.IntToString(from=2027, to="TYPE_MAGNIFICATION_OVERLAY"), @ViewDebug.IntToString(from=2030, to="TYPE_PRIVATE_PRESENTATION"), @ViewDebug.IntToString(from=2031, to="TYPE_VOICE_INTERACTION")})
        public int type;
        public long userActivityTimeout = -1L;
        public float verticalMargin;
        @ViewDebug.ExportedProperty
        public float verticalWeight;
        public int windowAnimations;
        @ViewDebug.ExportedProperty
        public int x;
        @ViewDebug.ExportedProperty
        public int y;

        public LayoutParams() {
            super(-1, -1);
            this.type = 2;
            this.format = -1;
        }

        public LayoutParams(int n) {
            super(-1, -1);
            this.type = n;
            this.format = -1;
        }

        public LayoutParams(int n, int n2) {
            super(-1, -1);
            this.type = n;
            this.flags = n2;
            this.format = -1;
        }

        public LayoutParams(int n, int n2, int n3) {
            super(-1, -1);
            this.type = n;
            this.flags = n2;
            this.format = n3;
        }

        public LayoutParams(int n, int n2, int n3, int n4, int n5) {
            super(n, n2);
            this.type = n3;
            this.flags = n4;
            this.format = n5;
        }

        public LayoutParams(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            super(n, n2);
            this.x = n3;
            this.y = n4;
            this.type = n5;
            this.flags = n6;
            this.format = n7;
        }

        /*
         * Enabled aggressive block sorting
         */
        public LayoutParams(Parcel parcel) {
            this.width = parcel.readInt();
            this.height = parcel.readInt();
            this.x = parcel.readInt();
            this.y = parcel.readInt();
            this.type = parcel.readInt();
            this.flags = parcel.readInt();
            this.privateFlags = parcel.readInt();
            this.softInputMode = parcel.readInt();
            this.gravity = parcel.readInt();
            this.horizontalMargin = parcel.readFloat();
            this.verticalMargin = parcel.readFloat();
            this.format = parcel.readInt();
            this.windowAnimations = parcel.readInt();
            this.alpha = parcel.readFloat();
            this.dimAmount = parcel.readFloat();
            this.screenBrightness = parcel.readFloat();
            this.buttonBrightness = parcel.readFloat();
            this.rotationAnimation = parcel.readInt();
            this.token = parcel.readStrongBinder();
            this.packageName = parcel.readString();
            this.mTitle = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
            this.screenOrientation = parcel.readInt();
            this.preferredRefreshRate = parcel.readFloat();
            this.systemUiVisibility = parcel.readInt();
            this.subtreeSystemUiVisibility = parcel.readInt();
            boolean bl = parcel.readInt() != 0;
            this.hasSystemUiListeners = bl;
            this.inputFeatures = parcel.readInt();
            this.userActivityTimeout = parcel.readLong();
            this.surfaceInsets.left = parcel.readInt();
            this.surfaceInsets.top = parcel.readInt();
            this.surfaceInsets.right = parcel.readInt();
            this.surfaceInsets.bottom = parcel.readInt();
        }

        public static boolean mayUseInputMethod(int n) {
            switch (0x20008 & n) {
                default: {
                    return false;
                }
                case 0: 
                case 131080: 
            }
            return true;
        }

        void backup() {
            int[] nArray = this.mCompatibilityParamsBackup;
            if (nArray == null) {
                this.mCompatibilityParamsBackup = nArray = new int[4];
            }
            nArray[0] = this.x;
            nArray[1] = this.y;
            nArray[2] = this.width;
            nArray[3] = this.height;
        }

        public final int copyFrom(LayoutParams layoutParams) {
            int n = this.width;
            int n2 = layoutParams.width;
            int n3 = 0;
            if (n != n2) {
                this.width = layoutParams.width;
                n3 = 0 | 1;
            }
            if (this.height != layoutParams.height) {
                this.height = layoutParams.height;
                n3 |= 1;
            }
            if (this.x != layoutParams.x) {
                this.x = layoutParams.x;
                n3 |= 1;
            }
            if (this.y != layoutParams.y) {
                this.y = layoutParams.y;
                n3 |= 1;
            }
            if (this.horizontalWeight != layoutParams.horizontalWeight) {
                this.horizontalWeight = layoutParams.horizontalWeight;
                n3 |= 1;
            }
            if (this.verticalWeight != layoutParams.verticalWeight) {
                this.verticalWeight = layoutParams.verticalWeight;
                n3 |= 1;
            }
            if (this.horizontalMargin != layoutParams.horizontalMargin) {
                this.horizontalMargin = layoutParams.horizontalMargin;
                n3 |= 1;
            }
            if (this.verticalMargin != layoutParams.verticalMargin) {
                this.verticalMargin = layoutParams.verticalMargin;
                n3 |= 1;
            }
            if (this.type != layoutParams.type) {
                this.type = layoutParams.type;
                n3 |= 2;
            }
            if (this.flags != layoutParams.flags) {
                if ((0xC000000 & (this.flags ^ layoutParams.flags)) != 0) {
                    n3 |= 0x80000;
                }
                this.flags = layoutParams.flags;
                n3 |= 4;
            }
            if (this.privateFlags != layoutParams.privateFlags) {
                this.privateFlags = layoutParams.privateFlags;
                n3 |= 0x20000;
            }
            if (this.softInputMode != layoutParams.softInputMode) {
                this.softInputMode = layoutParams.softInputMode;
                n3 |= 0x200;
            }
            if (this.gravity != layoutParams.gravity) {
                this.gravity = layoutParams.gravity;
                n3 |= 1;
            }
            if (this.format != layoutParams.format) {
                this.format = layoutParams.format;
                n3 |= 8;
            }
            if (this.windowAnimations != layoutParams.windowAnimations) {
                this.windowAnimations = layoutParams.windowAnimations;
                n3 |= 0x10;
            }
            if (this.token == null) {
                this.token = layoutParams.token;
            }
            if (this.packageName == null) {
                this.packageName = layoutParams.packageName;
            }
            if (!this.mTitle.equals(layoutParams.mTitle)) {
                this.mTitle = layoutParams.mTitle;
                n3 |= 0x40;
            }
            if (this.alpha != layoutParams.alpha) {
                this.alpha = layoutParams.alpha;
                n3 |= 0x80;
            }
            if (this.dimAmount != layoutParams.dimAmount) {
                this.dimAmount = layoutParams.dimAmount;
                n3 |= 0x20;
            }
            if (this.screenBrightness != layoutParams.screenBrightness) {
                this.screenBrightness = layoutParams.screenBrightness;
                n3 |= 0x800;
            }
            if (this.buttonBrightness != layoutParams.buttonBrightness) {
                this.buttonBrightness = layoutParams.buttonBrightness;
                n3 |= 0x2000;
            }
            if (this.rotationAnimation != layoutParams.rotationAnimation) {
                this.rotationAnimation = layoutParams.rotationAnimation;
                n3 |= 0x1000;
            }
            if (this.screenOrientation != layoutParams.screenOrientation) {
                this.screenOrientation = layoutParams.screenOrientation;
                n3 |= 0x400;
            }
            if (this.preferredRefreshRate != layoutParams.preferredRefreshRate) {
                this.preferredRefreshRate = layoutParams.preferredRefreshRate;
                n3 |= 0x200000;
            }
            if (this.systemUiVisibility != layoutParams.systemUiVisibility || this.subtreeSystemUiVisibility != layoutParams.subtreeSystemUiVisibility) {
                this.systemUiVisibility = layoutParams.systemUiVisibility;
                this.subtreeSystemUiVisibility = layoutParams.subtreeSystemUiVisibility;
                n3 |= 0x4000;
            }
            if (this.hasSystemUiListeners != layoutParams.hasSystemUiListeners) {
                this.hasSystemUiListeners = layoutParams.hasSystemUiListeners;
                n3 |= 0x8000;
            }
            if (this.inputFeatures != layoutParams.inputFeatures) {
                this.inputFeatures = layoutParams.inputFeatures;
                n3 |= 0x10000;
            }
            if (this.userActivityTimeout != layoutParams.userActivityTimeout) {
                this.userActivityTimeout = layoutParams.userActivityTimeout;
                n3 |= 0x40000;
            }
            if (!this.surfaceInsets.equals(layoutParams.surfaceInsets)) {
                this.surfaceInsets.set(layoutParams.surfaceInsets);
                n3 |= 0x100000;
            }
            return n3;
        }

        @Override
        public String debug(String string2) {
            Log.d("Debug", string2 + "Contents of " + this + ":");
            Log.d("Debug", super.debug(""));
            Log.d("Debug", "");
            Log.d("Debug", "WindowManager.LayoutParams={title=" + this.mTitle + "}");
            return "";
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public final CharSequence getTitle() {
            return this.mTitle;
        }

        void restore() {
            int[] nArray = this.mCompatibilityParamsBackup;
            if (nArray != null) {
                this.x = nArray[0];
                this.y = nArray[1];
                this.width = nArray[2];
                this.height = nArray[3];
            }
        }

        public void scale(float f) {
            this.x = (int)(0.5f + f * (float)this.x);
            this.y = (int)(0.5f + f * (float)this.y);
            if (this.width > 0) {
                this.width = (int)(0.5f + f * (float)this.width);
            }
            if (this.height > 0) {
                this.height = (int)(0.5f + f * (float)this.height);
            }
        }

        public final void setTitle(CharSequence charSequence) {
            if (charSequence == null) {
                charSequence = "";
            }
            this.mTitle = TextUtils.stringOrSpannedString(charSequence);
        }

        /*
         * Enabled aggressive block sorting
         */
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(256);
            stringBuilder.append("WM.LayoutParams{");
            stringBuilder.append("(");
            stringBuilder.append(this.x);
            stringBuilder.append(',');
            stringBuilder.append(this.y);
            stringBuilder.append(")(");
            Object object = this.width == -1 ? "fill" : (this.width == -2 ? "wrap" : Integer.valueOf(this.width));
            stringBuilder.append(object);
            stringBuilder.append('x');
            Object object2 = this.height == -1 ? "fill" : (this.height == -2 ? "wrap" : Integer.valueOf(this.height));
            stringBuilder.append(object2);
            stringBuilder.append(")");
            if (this.horizontalMargin != 0.0f) {
                stringBuilder.append(" hm=");
                stringBuilder.append(this.horizontalMargin);
            }
            if (this.verticalMargin != 0.0f) {
                stringBuilder.append(" vm=");
                stringBuilder.append(this.verticalMargin);
            }
            if (this.gravity != 0) {
                stringBuilder.append(" gr=#");
                stringBuilder.append(Integer.toHexString(this.gravity));
            }
            if (this.softInputMode != 0) {
                stringBuilder.append(" sim=#");
                stringBuilder.append(Integer.toHexString(this.softInputMode));
            }
            stringBuilder.append(" ty=");
            stringBuilder.append(this.type);
            stringBuilder.append(" fl=#");
            stringBuilder.append(Integer.toHexString(this.flags));
            if (this.privateFlags != 0) {
                if ((0x80 & this.privateFlags) != 0) {
                    stringBuilder.append(" compatible=true");
                }
                stringBuilder.append(" pfl=0x").append(Integer.toHexString(this.privateFlags));
            }
            if (this.format != -1) {
                stringBuilder.append(" fmt=");
                stringBuilder.append(this.format);
            }
            if (this.windowAnimations != 0) {
                stringBuilder.append(" wanim=0x");
                stringBuilder.append(Integer.toHexString(this.windowAnimations));
            }
            if (this.screenOrientation != -1) {
                stringBuilder.append(" or=");
                stringBuilder.append(this.screenOrientation);
            }
            if (this.alpha != 1.0f) {
                stringBuilder.append(" alpha=");
                stringBuilder.append(this.alpha);
            }
            if (this.screenBrightness != -1.0f) {
                stringBuilder.append(" sbrt=");
                stringBuilder.append(this.screenBrightness);
            }
            if (this.buttonBrightness != -1.0f) {
                stringBuilder.append(" bbrt=");
                stringBuilder.append(this.buttonBrightness);
            }
            if (this.rotationAnimation != 0) {
                stringBuilder.append(" rotAnim=");
                stringBuilder.append(this.rotationAnimation);
            }
            if (this.preferredRefreshRate != 0.0f) {
                stringBuilder.append(" preferredRefreshRate=");
                stringBuilder.append(this.preferredRefreshRate);
            }
            if (this.systemUiVisibility != 0) {
                stringBuilder.append(" sysui=0x");
                stringBuilder.append(Integer.toHexString(this.systemUiVisibility));
            }
            if (this.subtreeSystemUiVisibility != 0) {
                stringBuilder.append(" vsysui=0x");
                stringBuilder.append(Integer.toHexString(this.subtreeSystemUiVisibility));
            }
            if (this.hasSystemUiListeners) {
                stringBuilder.append(" sysuil=");
                stringBuilder.append(this.hasSystemUiListeners);
            }
            if (this.inputFeatures != 0) {
                stringBuilder.append(" if=0x").append(Integer.toHexString(this.inputFeatures));
            }
            if (this.userActivityTimeout >= 0L) {
                stringBuilder.append(" userActivityTimeout=").append(this.userActivityTimeout);
            }
            if (!this.surfaceInsets.equals(Insets.NONE)) {
                stringBuilder.append(" surfaceInsets=").append(this.surfaceInsets);
            }
            stringBuilder.append('}');
            return stringBuilder.toString();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.width);
            parcel.writeInt(this.height);
            parcel.writeInt(this.x);
            parcel.writeInt(this.y);
            parcel.writeInt(this.type);
            parcel.writeInt(this.flags);
            parcel.writeInt(this.privateFlags);
            parcel.writeInt(this.softInputMode);
            parcel.writeInt(this.gravity);
            parcel.writeFloat(this.horizontalMargin);
            parcel.writeFloat(this.verticalMargin);
            parcel.writeInt(this.format);
            parcel.writeInt(this.windowAnimations);
            parcel.writeFloat(this.alpha);
            parcel.writeFloat(this.dimAmount);
            parcel.writeFloat(this.screenBrightness);
            parcel.writeFloat(this.buttonBrightness);
            parcel.writeInt(this.rotationAnimation);
            parcel.writeStrongBinder(this.token);
            parcel.writeString(this.packageName);
            TextUtils.writeToParcel(this.mTitle, parcel, n);
            parcel.writeInt(this.screenOrientation);
            parcel.writeFloat(this.preferredRefreshRate);
            parcel.writeInt(this.systemUiVisibility);
            parcel.writeInt(this.subtreeSystemUiVisibility);
            int n2 = this.hasSystemUiListeners ? 1 : 0;
            parcel.writeInt(n2);
            parcel.writeInt(this.inputFeatures);
            parcel.writeLong(this.userActivityTimeout);
            parcel.writeInt(this.surfaceInsets.left);
            parcel.writeInt(this.surfaceInsets.top);
            parcel.writeInt(this.surfaceInsets.right);
            parcel.writeInt(this.surfaceInsets.bottom);
        }
    }
}

