/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.os.Parcelable;
import android.view.View;
import android.view.accessibility.AccessibilityInteractionClient;
import android.view.accessibility.AccessibilityNodeInfo;
import java.util.ArrayList;
import java.util.List;

public class AccessibilityRecord {
    private static final int GET_SOURCE_PREFETCH_FLAGS = 7;
    private static final int MAX_POOL_SIZE = 10;
    private static final int PROPERTY_CHECKED = 1;
    private static final int PROPERTY_ENABLED = 2;
    private static final int PROPERTY_FULL_SCREEN = 128;
    private static final int PROPERTY_IMPORTANT_FOR_ACCESSIBILITY = 512;
    private static final int PROPERTY_PASSWORD = 4;
    private static final int PROPERTY_SCROLLABLE = 256;
    private static final int UNDEFINED = -1;
    private static AccessibilityRecord sPool;
    private static final Object sPoolLock;
    private static int sPoolSize;
    int mAddedCount = -1;
    CharSequence mBeforeText;
    int mBooleanProperties = 0;
    CharSequence mClassName;
    int mConnectionId = -1;
    CharSequence mContentDescription;
    int mCurrentItemIndex = -1;
    int mFromIndex = -1;
    private boolean mIsInPool;
    int mItemCount = -1;
    int mMaxScrollX = -1;
    int mMaxScrollY = -1;
    private AccessibilityRecord mNext;
    Parcelable mParcelableData;
    int mRemovedCount = -1;
    int mScrollX = -1;
    int mScrollY = -1;
    boolean mSealed;
    long mSourceNodeId = AccessibilityNodeInfo.makeNodeId(-1, -1);
    int mSourceWindowId = -1;
    final List<CharSequence> mText = new ArrayList<CharSequence>();
    int mToIndex = -1;

    static {
        sPoolLock = new Object();
    }

    AccessibilityRecord() {
    }

    private boolean getBooleanProperty(int n) {
        return (n & this.mBooleanProperties) == n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AccessibilityRecord obtain() {
        Object object = sPoolLock;
        synchronized (object) {
            if (sPool == null) return new AccessibilityRecord();
            AccessibilityRecord accessibilityRecord = sPool;
            sPool = AccessibilityRecord.sPool.mNext;
            sPoolSize = -1 + sPoolSize;
            accessibilityRecord.mNext = null;
            accessibilityRecord.mIsInPool = false;
            return accessibilityRecord;
        }
    }

    public static AccessibilityRecord obtain(AccessibilityRecord accessibilityRecord) {
        AccessibilityRecord accessibilityRecord2 = AccessibilityRecord.obtain();
        accessibilityRecord2.init(accessibilityRecord);
        return accessibilityRecord2;
    }

    private void setBooleanProperty(int n, boolean bl) {
        if (bl) {
            this.mBooleanProperties = n | this.mBooleanProperties;
            return;
        }
        this.mBooleanProperties &= ~n;
    }

    void clear() {
        this.mSealed = false;
        this.mBooleanProperties = 0;
        this.mCurrentItemIndex = -1;
        this.mItemCount = -1;
        this.mFromIndex = -1;
        this.mToIndex = -1;
        this.mScrollX = -1;
        this.mScrollY = -1;
        this.mMaxScrollX = -1;
        this.mMaxScrollY = -1;
        this.mAddedCount = -1;
        this.mRemovedCount = -1;
        this.mClassName = null;
        this.mContentDescription = null;
        this.mBeforeText = null;
        this.mParcelableData = null;
        this.mText.clear();
        this.mSourceNodeId = AccessibilityNodeInfo.makeNodeId(-1, -1);
        this.mSourceWindowId = -1;
        this.mConnectionId = -1;
    }

    void enforceNotSealed() {
        if (this.isSealed()) {
            throw new IllegalStateException("Cannot perform this action on a sealed instance.");
        }
    }

    void enforceSealed() {
        if (!this.isSealed()) {
            throw new IllegalStateException("Cannot perform this action on a not sealed instance.");
        }
    }

    public int getAddedCount() {
        return this.mAddedCount;
    }

    public CharSequence getBeforeText() {
        return this.mBeforeText;
    }

    public CharSequence getClassName() {
        return this.mClassName;
    }

    public CharSequence getContentDescription() {
        return this.mContentDescription;
    }

    public int getCurrentItemIndex() {
        return this.mCurrentItemIndex;
    }

    public int getFromIndex() {
        return this.mFromIndex;
    }

    public int getItemCount() {
        return this.mItemCount;
    }

    public int getMaxScrollX() {
        return this.mMaxScrollX;
    }

    public int getMaxScrollY() {
        return this.mMaxScrollY;
    }

    public Parcelable getParcelableData() {
        return this.mParcelableData;
    }

    public int getRemovedCount() {
        return this.mRemovedCount;
    }

    public int getScrollX() {
        return this.mScrollX;
    }

    public int getScrollY() {
        return this.mScrollY;
    }

    public AccessibilityNodeInfo getSource() {
        this.enforceSealed();
        if (this.mConnectionId == -1 || this.mSourceWindowId == -1 || AccessibilityNodeInfo.getAccessibilityViewId(this.mSourceNodeId) == -1) {
            return null;
        }
        return AccessibilityInteractionClient.getInstance().findAccessibilityNodeInfoByAccessibilityId(this.mConnectionId, this.mSourceWindowId, this.mSourceNodeId, false, 7);
    }

    public long getSourceNodeId() {
        return this.mSourceNodeId;
    }

    public List<CharSequence> getText() {
        return this.mText;
    }

    public int getToIndex() {
        return this.mToIndex;
    }

    public int getWindowId() {
        return this.mSourceWindowId;
    }

    void init(AccessibilityRecord accessibilityRecord) {
        this.mSealed = accessibilityRecord.mSealed;
        this.mBooleanProperties = accessibilityRecord.mBooleanProperties;
        this.mCurrentItemIndex = accessibilityRecord.mCurrentItemIndex;
        this.mItemCount = accessibilityRecord.mItemCount;
        this.mFromIndex = accessibilityRecord.mFromIndex;
        this.mToIndex = accessibilityRecord.mToIndex;
        this.mScrollX = accessibilityRecord.mScrollX;
        this.mScrollY = accessibilityRecord.mScrollY;
        this.mMaxScrollX = accessibilityRecord.mMaxScrollX;
        this.mMaxScrollY = accessibilityRecord.mMaxScrollY;
        this.mAddedCount = accessibilityRecord.mAddedCount;
        this.mRemovedCount = accessibilityRecord.mRemovedCount;
        this.mClassName = accessibilityRecord.mClassName;
        this.mContentDescription = accessibilityRecord.mContentDescription;
        this.mBeforeText = accessibilityRecord.mBeforeText;
        this.mParcelableData = accessibilityRecord.mParcelableData;
        this.mText.addAll(accessibilityRecord.mText);
        this.mSourceWindowId = accessibilityRecord.mSourceWindowId;
        this.mSourceNodeId = accessibilityRecord.mSourceNodeId;
        this.mConnectionId = accessibilityRecord.mConnectionId;
    }

    public boolean isChecked() {
        return this.getBooleanProperty(1);
    }

    public boolean isEnabled() {
        return this.getBooleanProperty(2);
    }

    public boolean isFullScreen() {
        return this.getBooleanProperty(128);
    }

    public boolean isImportantForAccessibility() {
        return this.getBooleanProperty(512);
    }

    public boolean isPassword() {
        return this.getBooleanProperty(4);
    }

    public boolean isScrollable() {
        return this.getBooleanProperty(256);
    }

    boolean isSealed() {
        return this.mSealed;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void recycle() {
        if (this.mIsInPool) {
            throw new IllegalStateException("Record already recycled!");
        }
        this.clear();
        Object object = sPoolLock;
        synchronized (object) {
            if (sPoolSize <= 10) {
                this.mNext = sPool;
                sPool = this;
                this.mIsInPool = true;
                sPoolSize = 1 + sPoolSize;
            }
            return;
        }
    }

    public void setAddedCount(int n) {
        this.enforceNotSealed();
        this.mAddedCount = n;
    }

    public void setBeforeText(CharSequence charSequence) {
        this.enforceNotSealed();
        this.mBeforeText = charSequence;
    }

    public void setChecked(boolean bl) {
        this.enforceNotSealed();
        this.setBooleanProperty(1, bl);
    }

    public void setClassName(CharSequence charSequence) {
        this.enforceNotSealed();
        this.mClassName = charSequence;
    }

    public void setConnectionId(int n) {
        this.enforceNotSealed();
        this.mConnectionId = n;
    }

    public void setContentDescription(CharSequence charSequence) {
        this.enforceNotSealed();
        this.mContentDescription = charSequence;
    }

    public void setCurrentItemIndex(int n) {
        this.enforceNotSealed();
        this.mCurrentItemIndex = n;
    }

    public void setEnabled(boolean bl) {
        this.enforceNotSealed();
        this.setBooleanProperty(2, bl);
    }

    public void setFromIndex(int n) {
        this.enforceNotSealed();
        this.mFromIndex = n;
    }

    public void setFullScreen(boolean bl) {
        this.enforceNotSealed();
        this.setBooleanProperty(128, bl);
    }

    public void setItemCount(int n) {
        this.enforceNotSealed();
        this.mItemCount = n;
    }

    public void setMaxScrollX(int n) {
        this.enforceNotSealed();
        this.mMaxScrollX = n;
    }

    public void setMaxScrollY(int n) {
        this.enforceNotSealed();
        this.mMaxScrollY = n;
    }

    public void setParcelableData(Parcelable parcelable) {
        this.enforceNotSealed();
        this.mParcelableData = parcelable;
    }

    public void setPassword(boolean bl) {
        this.enforceNotSealed();
        this.setBooleanProperty(4, bl);
    }

    public void setRemovedCount(int n) {
        this.enforceNotSealed();
        this.mRemovedCount = n;
    }

    public void setScrollX(int n) {
        this.enforceNotSealed();
        this.mScrollX = n;
    }

    public void setScrollY(int n) {
        this.enforceNotSealed();
        this.mScrollY = n;
    }

    public void setScrollable(boolean bl) {
        this.enforceNotSealed();
        this.setBooleanProperty(256, bl);
    }

    public void setSealed(boolean bl) {
        this.mSealed = bl;
    }

    public void setSource(View view) {
        this.setSource(view, -1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setSource(View view, int n) {
        this.enforceNotSealed();
        boolean bl = n == -1 ? (view != null ? view.isImportantForAccessibility() : true) : true;
        this.setBooleanProperty(512, bl);
        int n2 = view != null ? view.getAccessibilityWindowId() : -1;
        this.mSourceWindowId = n2;
        int n3 = view != null ? view.getAccessibilityViewId() : -1;
        this.mSourceNodeId = AccessibilityNodeInfo.makeNodeId(n3, n);
    }

    public void setToIndex(int n) {
        this.enforceNotSealed();
        this.mToIndex = n;
    }

    public void setWindowId(int n) {
        this.mSourceWindowId = n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" [ ClassName: " + this.mClassName);
        stringBuilder.append("; Text: " + this.mText);
        stringBuilder.append("; ContentDescription: " + this.mContentDescription);
        stringBuilder.append("; ItemCount: " + this.mItemCount);
        stringBuilder.append("; CurrentItemIndex: " + this.mCurrentItemIndex);
        stringBuilder.append("; IsEnabled: " + this.getBooleanProperty(2));
        stringBuilder.append("; IsPassword: " + this.getBooleanProperty(4));
        stringBuilder.append("; IsChecked: " + this.getBooleanProperty(1));
        stringBuilder.append("; IsFullScreen: " + this.getBooleanProperty(128));
        stringBuilder.append("; Scrollable: " + this.getBooleanProperty(256));
        stringBuilder.append("; BeforeText: " + this.mBeforeText);
        stringBuilder.append("; FromIndex: " + this.mFromIndex);
        stringBuilder.append("; ToIndex: " + this.mToIndex);
        stringBuilder.append("; ScrollX: " + this.mScrollX);
        stringBuilder.append("; ScrollY: " + this.mScrollY);
        stringBuilder.append("; MaxScrollX: " + this.mMaxScrollX);
        stringBuilder.append("; MaxScrollY: " + this.mMaxScrollY);
        stringBuilder.append("; AddedCount: " + this.mAddedCount);
        stringBuilder.append("; RemovedCount: " + this.mRemovedCount);
        stringBuilder.append("; ParcelableData: " + this.mParcelableData);
        stringBuilder.append(" ]");
        return stringBuilder.toString();
    }
}

