/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.animation.Interpolator;
import com.android.internal.R;
import com.android.internal.view.animation.HasNativeInterpolator;
import com.android.internal.view.animation.NativeInterpolatorFactory;
import com.android.internal.view.animation.NativeInterpolatorFactoryHelper;

@HasNativeInterpolator
public class AnticipateOvershootInterpolator
implements Interpolator,
NativeInterpolatorFactory {
    private final float mTension;

    public AnticipateOvershootInterpolator() {
        this.mTension = 3.0f;
    }

    public AnticipateOvershootInterpolator(float f) {
        this.mTension = 1.5f * f;
    }

    public AnticipateOvershootInterpolator(float f, float f2) {
        this.mTension = f * f2;
    }

    public AnticipateOvershootInterpolator(Context context, AttributeSet attributeSet) {
        this(context.getResources(), context.getTheme(), attributeSet);
    }

    /*
     * Enabled aggressive block sorting
     */
    public AnticipateOvershootInterpolator(Resources resources, Resources.Theme theme, AttributeSet attributeSet) {
        TypedArray typedArray = theme != null ? theme.obtainStyledAttributes(attributeSet, R.styleable.AnticipateOvershootInterpolator, 0, 0) : resources.obtainAttributes(attributeSet, R.styleable.AnticipateOvershootInterpolator);
        this.mTension = typedArray.getFloat(0, 2.0f) * typedArray.getFloat(1, 1.5f);
        typedArray.recycle();
    }

    private static float a(float f, float f2) {
        return f * f * (f * (1.0f + f2) - f2);
    }

    private static float o(float f, float f2) {
        return f * f * (f2 + f * (1.0f + f2));
    }

    @Override
    public long createNativeInterpolator() {
        return NativeInterpolatorFactoryHelper.createAnticipateOvershootInterpolator(this.mTension);
    }

    @Override
    public float getInterpolation(float f) {
        if (f < 0.5f) {
            return 0.5f * AnticipateOvershootInterpolator.a(f * 2.0f, this.mTension);
        }
        return 0.5f * (2.0f + AnticipateOvershootInterpolator.o(f * 2.0f - 2.0f, this.mTension));
    }
}

