/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.android.internal.R;
import java.util.Random;

public class LayoutAnimationController {
    public static final int ORDER_NORMAL = 0;
    public static final int ORDER_RANDOM = 2;
    public static final int ORDER_REVERSE = 1;
    protected Animation mAnimation;
    private float mDelay;
    private long mDuration;
    protected Interpolator mInterpolator;
    private long mMaxDelay;
    private int mOrder;
    protected Random mRandomizer;

    public LayoutAnimationController(Context context, AttributeSet attributeSet) {
        int n;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.LayoutAnimation);
        this.mDelay = Animation.Description.parseValue((TypedValue)typedArray.peekValue((int)1)).value;
        this.mOrder = typedArray.getInt(3, 0);
        int n2 = typedArray.getResourceId(2, 0);
        if (n2 > 0) {
            this.setAnimation(context, n2);
        }
        if ((n = typedArray.getResourceId(0, 0)) > 0) {
            this.setInterpolator(context, n);
        }
        typedArray.recycle();
    }

    public LayoutAnimationController(Animation animation) {
        this(animation, 0.5f);
    }

    public LayoutAnimationController(Animation animation, float f) {
        this.mDelay = f;
        this.setAnimation(animation);
    }

    public Animation getAnimation() {
        return this.mAnimation;
    }

    public final Animation getAnimationForView(View view) {
        long l = this.getDelayForView(view) + this.mAnimation.getStartOffset();
        this.mMaxDelay = Math.max(this.mMaxDelay, l);
        try {
            Animation animation = this.mAnimation.clone();
            animation.setStartOffset(l);
            return animation;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public float getDelay() {
        return this.mDelay;
    }

    protected long getDelayForView(View view) {
        AnimationParameters animationParameters = view.getLayoutParams().layoutAnimationParameters;
        if (animationParameters == null) {
            return 0L;
        }
        float f = this.mDelay * (float)this.mAnimation.getDuration();
        long l = (long)(f * (float)this.getTransformedIndex(animationParameters));
        float f2 = f * (float)animationParameters.count;
        if (this.mInterpolator == null) {
            this.mInterpolator = new LinearInterpolator();
        }
        float f3 = (float)l / f2;
        return (long)(f2 * this.mInterpolator.getInterpolation(f3));
    }

    public Interpolator getInterpolator() {
        return this.mInterpolator;
    }

    public int getOrder() {
        return this.mOrder;
    }

    protected int getTransformedIndex(AnimationParameters animationParameters) {
        switch (this.getOrder()) {
            default: {
                return animationParameters.index;
            }
            case 1: {
                return -1 + animationParameters.count - animationParameters.index;
            }
            case 2: 
        }
        if (this.mRandomizer == null) {
            this.mRandomizer = new Random();
        }
        return (int)((float)animationParameters.count * this.mRandomizer.nextFloat());
    }

    public boolean isDone() {
        return AnimationUtils.currentAnimationTimeMillis() > this.mAnimation.getStartTime() + this.mMaxDelay + this.mDuration;
    }

    public void setAnimation(Context context, int n) {
        this.setAnimation(AnimationUtils.loadAnimation(context, n));
    }

    public void setAnimation(Animation animation) {
        this.mAnimation = animation;
        this.mAnimation.setFillBefore(true);
    }

    public void setDelay(float f) {
        this.mDelay = f;
    }

    public void setInterpolator(Context context, int n) {
        this.setInterpolator(AnimationUtils.loadInterpolator(context, n));
    }

    public void setInterpolator(Interpolator interpolator2) {
        this.mInterpolator = interpolator2;
    }

    public void setOrder(int n) {
        this.mOrder = n;
    }

    public void start() {
        this.mDuration = this.mAnimation.getDuration();
        this.mMaxDelay = Long.MIN_VALUE;
        this.mAnimation.setStartTime(-1L);
    }

    public boolean willOverlap() {
        return this.mDelay < 1.0f;
    }

    public static class AnimationParameters {
        public int count;
        public int index;
    }
}

