/*
 * Decompiled with CFR 0.152.
 */
package android.view.textservice;

import android.os.Parcel;
import android.os.Parcelable;
import android.view.textservice.SuggestionsInfo;
import java.util.Arrays;

public final class SentenceSuggestionsInfo
implements Parcelable {
    public static final Parcelable.Creator<SentenceSuggestionsInfo> CREATOR = new Parcelable.Creator<SentenceSuggestionsInfo>(){

        @Override
        public SentenceSuggestionsInfo createFromParcel(Parcel parcel) {
            return new SentenceSuggestionsInfo(parcel);
        }

        public SentenceSuggestionsInfo[] newArray(int n) {
            return new SentenceSuggestionsInfo[n];
        }
    };
    private final int[] mLengths;
    private final int[] mOffsets;
    private final SuggestionsInfo[] mSuggestionsInfos;

    public SentenceSuggestionsInfo(Parcel parcel) {
        this.mSuggestionsInfos = new SuggestionsInfo[parcel.readInt()];
        parcel.readTypedArray(this.mSuggestionsInfos, SuggestionsInfo.CREATOR);
        this.mOffsets = new int[this.mSuggestionsInfos.length];
        parcel.readIntArray(this.mOffsets);
        this.mLengths = new int[this.mSuggestionsInfos.length];
        parcel.readIntArray(this.mLengths);
    }

    public SentenceSuggestionsInfo(SuggestionsInfo[] suggestionsInfoArray, int[] nArray, int[] nArray2) {
        if (suggestionsInfoArray == null || nArray == null || nArray2 == null) {
            throw new NullPointerException();
        }
        if (suggestionsInfoArray.length != nArray.length || nArray.length != nArray2.length) {
            throw new IllegalArgumentException();
        }
        int n = suggestionsInfoArray.length;
        this.mSuggestionsInfos = Arrays.copyOf(suggestionsInfoArray, n);
        this.mOffsets = Arrays.copyOf(nArray, n);
        this.mLengths = Arrays.copyOf(nArray2, n);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getLengthAt(int n) {
        if (n >= 0 && n < this.mLengths.length) {
            return this.mLengths[n];
        }
        return -1;
    }

    public int getOffsetAt(int n) {
        if (n >= 0 && n < this.mOffsets.length) {
            return this.mOffsets[n];
        }
        return -1;
    }

    public int getSuggestionsCount() {
        return this.mSuggestionsInfos.length;
    }

    public SuggestionsInfo getSuggestionsInfoAt(int n) {
        if (n >= 0 && n < this.mSuggestionsInfos.length) {
            return this.mSuggestionsInfos[n];
        }
        return null;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mSuggestionsInfos.length);
        parcel.writeTypedArray(this.mSuggestionsInfos, 0);
        parcel.writeIntArray(this.mOffsets);
        parcel.writeIntArray(this.mLengths);
    }
}

